/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.composite;

import org.eclipse.bpel.common.ui.composite.CompositeEditorSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class EditorInViewSite
extends EditorSite {
    protected IViewSite parent;
    protected IKeyBindingService keyBindingService;
    private ISelectionProvider selectionProvider;
    private ISelectionChangedListener selectionChangedListener;

    public EditorInViewSite(IViewSite parent, IEditorReference ref, IEditorPart editor, WorkbenchPage page, EditorDescriptor desc) {
        super(ref, editor, page, desc);
        this.parent = parent;
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.keyBindingService == null) {
            INestableKeyBindingService service = (INestableKeyBindingService)this.parent.getKeyBindingService();
            this.keyBindingService = service.getKeyBindingService((IWorkbenchSite)this);
        }
        return this.keyBindingService;
    }

    public void activate() {
        if (this.keyBindingService == null) {
            return;
        }
        INestableKeyBindingService service = (INestableKeyBindingService)this.parent.getKeyBindingService();
        service.activateKeyBindingService((IWorkbenchSite)this);
    }

    public void deactivate() {
        if (this.keyBindingService == null) {
            return;
        }
        INestableKeyBindingService service = (INestableKeyBindingService)this.parent.getKeyBindingService();
        service.activateKeyBindingService(null);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        this.selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
        }
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EditorInViewSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.selectionChangedListener;
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.parent.getSelectionProvider();
        if (parentProvider instanceof CompositeEditorSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((CompositeEditorSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public IViewSite getParent() {
        return this.parent;
    }

    public void dispose() {
        this.deactivate();
        super.dispose();
        this.setSelectionProvider(null);
        super.setSelectionProvider(null);
        this.setPart(null);
    }
}

