/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.jboss.riftsaw.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RiftsawPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.bpel.jboss.riftsaw.runtime";
    private static RiftsawPlugin plugin;
    private boolean imagesInitialized = false;

    public RiftsawPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static RiftsawPlugin getPlugin() {
        return plugin;
    }

    public ImageRegistry getImageRegistry() {
        ImageRegistry result = super.getImageRegistry();
        this.initialize();
        return result;
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.getImageRegistry().getDescriptor(id);
    }

    public Image getImage(String id) {
        return this.getImageRegistry().get(id);
    }

    private void createImageDescriptor(String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, "icons/" + id);
        }
        catch (MalformedURLException e) {
            RiftsawPlugin.log(e);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.getImageRegistry().put(id, desc);
    }

    protected void initialize() {
        if (!this.imagesInitialized) {
            this.imagesInitialized = true;
            this.initializeImages();
        }
    }

    private void initializeImages() {
        URL baseURL = this.getBundle().getEntry("/");
        this.createImageDescriptor("wizban/newprj_bpel_wiz_banner.gif", baseURL);
        this.createImageDescriptor("ctool16/new_bpelprj.gif", baseURL);
        this.createImageDescriptor("obj16/prj_bpel.gif", baseURL);
    }

    public static void log(Exception e, int severity) {
        String m;
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(severity, PLUGIN_ID, 0, (m = e.getMessage()) == null ? "<no message>" : m, (Throwable)e);
        System.out.println(String.valueOf(e.getClass().getName()) + ": " + status);
        RiftsawPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Exception e) {
        RiftsawPlugin.log(e, 4);
    }
}

