/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMWriter;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLGenerator;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XSD2XMLGenerator
extends NewXMLGenerator {
    public static final int BUILD_OPTIONAL_ATTRIBUTES = 1;
    public static final int BUILD_OPTIONAL_ELEMENTS = 2;
    public static final int BUILD_FIRST_CHOICE = 4;
    public static final int BUILD_TEXT_NODES = 8;
    public static final int BUILD_FIRST_SUBSTITUTION = 16;
    public static final int BUILD_STRUCTURE_ONLY = 32;
    public static final int BUILD_ONLY_REQUIRED_CONTENT = 12;
    public static final int BUILD_ALL_CONTENT = 15;
    MyDOMContentBuilderImpl contentBuilder = null;
    protected String[] queryPath = new String[0];
    protected int myBuildPolicy = 12;
    protected String xsdURI = null;

    public XSD2XMLGenerator(String xsdURI, String rootName) {
        this.setRootElementName(rootName);
        this.xsdURI = xsdURI;
    }

    public XSD2XMLGenerator() {
    }

    public void setQueryPath(String path) {
        if (path != null && path.length() > 0) {
            this.queryPath = path.split("/");
            if (this.queryPath != null && this.queryPath.length > 0) {
                int i = 0;
                while (i < this.queryPath.length) {
                    this.queryPath[i] = this.queryPath[i].replaceFirst(".*:", "");
                    ++i;
                }
            }
        }
    }

    public void setBuildPolicy(int buildPolicy) {
        this.myBuildPolicy = buildPolicy;
    }

    public String createXML() throws Exception {
        if (this.xsdURI == null) {
            throw new IllegalArgumentException("XML Generator: XSD location is unknown");
        }
        CMDocument cmDocument = ContentModelManager.getInstance().createCMDocument(this.xsdURI, "xsd");
        this.setCMDocument(cmDocument);
        this.createNamespaceInfoList();
        CMNamedNodeMap map = cmDocument.getElements();
        CMElementDeclaration cmRootElement = null;
        cmRootElement = (CMElementDeclaration)map.getNamedItem(this.getRootElementName());
        if (cmRootElement == null) {
            throw new IllegalArgumentException("XML Generator: Root element '" + this.getRootElementName() + "' is not defined in this XSD");
        }
        Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.createContentBuilder(xmlDocument);
        this.contentBuilder.createDefaultRootContent(cmDocument, cmRootElement, this.namespaceInfoList);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        DOMWriter domWriter = new DOMWriter((Writer)outputStreamWriter);
        domWriter.print((Node)xmlDocument);
        outputStream.flush();
        outputStream.close();
        return outputStream.toString();
    }

    private void createContentBuilder(Document xmlDocument) {
        this.contentBuilder = new MyDOMContentBuilderImpl(xmlDocument);
        int bp = 0;
        if ((this.myBuildPolicy | 1) != 0) {
            bp |= 1;
        }
        if ((this.myBuildPolicy | 2) != 0) {
            bp |= 2;
        }
        if ((this.myBuildPolicy | 4) != 0) {
            bp |= 4;
        }
        if ((this.myBuildPolicy | 8) != 0) {
            bp |= 8;
        }
        if ((this.myBuildPolicy | 0x10) != 0) {
            bp |= 0x10;
        }
        this.contentBuilder.setBuildPolicy(bp);
    }

    public static XSDTypeDefinition getXSDType(CMNode cmNode) {
        XSDAttributeUse xsdAttributeUse;
        XSDAttributeDeclaration xsdAttributeDeclaration;
        XSDImpl.XSDAttributeUseAdapter xsdAttributeUseAdapter;
        Notifier target;
        CMAttributeDeclaration cmAttributeDeclaration;
        XSDTypeDefinition xsdType = null;
        if (cmNode instanceof CMElementDeclaration) {
            XSDImpl.XSDElementDeclarationAdapter xsdElementDeclarationAdapter;
            Notifier target2;
            CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)cmNode;
            if (cmElementDeclaration instanceof XSDImpl.XSDElementDeclarationAdapter && (target2 = (xsdElementDeclarationAdapter = (XSDImpl.XSDElementDeclarationAdapter)cmElementDeclaration).getTarget()) instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)target2;
                xsdType = xsdElementDeclaration.getResolvedElementDeclaration().getTypeDefinition();
            }
        } else if (cmNode instanceof CMAttributeDeclaration && (cmAttributeDeclaration = (CMAttributeDeclaration)cmNode) instanceof XSDImpl.XSDAttributeUseAdapter && (target = (xsdAttributeUseAdapter = (XSDImpl.XSDAttributeUseAdapter)cmAttributeDeclaration).getTarget()) instanceof XSDAttributeUse && (xsdAttributeDeclaration = (xsdAttributeUse = (XSDAttributeUse)target).getAttributeDeclaration()) != null) {
            xsdType = xsdAttributeDeclaration.getResolvedAttributeDeclaration().getTypeDefinition();
        }
        return xsdType;
    }

    public class MyDOMContentBuilderImpl
    extends DOMContentBuilderImpl {
        protected Stack<CMNode> cmNodeStack;

        public MyDOMContentBuilderImpl(Document document) {
            super(document);
            this.cmNodeStack = new Stack();
        }

        public void createDefaultRootContent(CMDocument cmDocument, CMElementDeclaration rootCMElementDeclaration) throws Exception {
            if (this.namespaceInfoList != null) {
                DOMNamespaceInfoManager manager = new DOMNamespaceInfoManager();
                String name = rootCMElementDeclaration.getNodeName();
                if (this.namespaceInfoList.size() > 0) {
                    NamespaceInfo info = (NamespaceInfo)this.namespaceInfoList.get(0);
                    if (info.prefix != null && info.prefix.length() > 0) {
                        name = String.valueOf(info.prefix) + ":" + name;
                    }
                }
                this.rootElement = this.createElement(rootCMElementDeclaration, name, this.document);
                if ((XSD2XMLGenerator.this.myBuildPolicy & 0x20) == 0) {
                    manager.addNamespaceInfo(this.rootElement, this.namespaceInfoList, true);
                }
            }
            this.createDefaultContent(this.document, rootCMElementDeclaration);
        }

        public void visitCMGroup(CMGroup e) {
            this.cmGroupStack.push(e);
            int forcedMin = this.buildOptionalElements(XSD2XMLGenerator.this.myBuildPolicy) || this.alwaysVisit ? 1 : 0;
            int min = Math.max(e.getMinOccur(), forcedMin);
            int max = 0;
            max = e.getMaxOccur() == -1 ? this.getNumOfRepeatableElements() : Math.min(e.getMaxOccur(), this.getNumOfRepeatableElements());
            if (max < min) {
                max = min;
            }
            this.alwaysVisit = false;
            int i = 1;
            while (i <= max) {
                if (e.getOperator() == 2 && this.buildFirstChoice(XSD2XMLGenerator.this.myBuildPolicy)) {
                    CMNodeList nodeList;
                    CMNode cmNode = null;
                    if (this.domLevel > 0 && this.domLevel <= XSD2XMLGenerator.this.queryPath.length) {
                        int n = 0;
                        while (n < e.getChildNodes().getLength()) {
                            CMNode cn = e.getChildNodes().item(n);
                            if (cn.getNodeName().equals(XSD2XMLGenerator.this.queryPath[this.domLevel - 1])) {
                                cmNode = cn;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (cmNode == null && (nodeList = e.getChildNodes()).getLength() > 0) {
                        cmNode = nodeList.item(0);
                    }
                    if (cmNode != null) {
                        this.visitCMNode(cmNode);
                    }
                } else if (e.getOperator() == 3 || e.getOperator() == 1) {
                    super.visitCMGroup(e);
                }
                ++i;
            }
            this.cmGroupStack.pop();
        }

        protected void handlePushParent(Element parent, CMElementDeclaration ed) {
            super.handlePushParent(parent, ed);
            this.cmNodeStack.push((CMNode)ed);
        }

        protected void handlePopParent(Element element, CMElementDeclaration ed) {
            super.handlePopParent(element, ed);
            this.cmNodeStack.pop();
        }

        protected Element createElement(CMElementDeclaration ed, String name, Node parent) {
            if ((XSD2XMLGenerator.this.myBuildPolicy & 0x20) != 0) {
                CMDataType dt = ed.getDataType();
                if (dt != null) {
                    return this.document.createElement("simpleElem");
                }
                return this.document.createElement("complexElem");
            }
            return this.document.createElement(name);
        }

        protected Attr createAttribute(CMAttributeDeclaration ad, String name, Node parent) {
            return this.document.createAttribute(name);
        }

        protected Text createTextNode(CMDataType dataType, String value, Node parent) {
            XSDTypeDefinition xsdType;
            if (this.cmNodeStack.size() > 0 && (xsdType = XSD2XMLGenerator.getXSDType(this.cmNodeStack.peek())) != null) {
                ArrayList result = new ArrayList();
                this.getEnumeratedValuesForSimpleType(xsdType, result);
                if (!result.isEmpty()) {
                    value = (String)result.get(0);
                    return this.document.createTextNode(value);
                }
            }
            if ((XSD2XMLGenerator.this.myBuildPolicy & 0x20) != 0) {
                value = dataType.getDataTypeName();
            }
            return this.document.createTextNode(value);
        }

        public void getEnumeratedValuesForSimpleType(XSDTypeDefinition type, List result) {
            EList enumerationFacets = ((XSDSimpleTypeDefinition)type).getEnumerationFacets();
            for (XSDEnumerationFacet enumFacet : enumerationFacets) {
                EList values = enumFacet.getValue();
                for (Object o : values) {
                    if (o == null || result.contains(o)) continue;
                    result.add(o.toString());
                }
            }
        }
    }
}

