/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.bpel.ui.editors.xpath.ColorManager;
import org.eclipse.bpel.ui.editors.xpath.XPathWhitespaceDetector;
import org.eclipse.bpel.ui.editors.xpath.XPathWordDetector;
import org.eclipse.bpel.ui.editors.xpath.rules.AxisRule;
import org.eclipse.bpel.ui.editors.xpath.rules.FloatRule;
import org.eclipse.bpel.ui.editors.xpath.rules.FunctionRule;
import org.eclipse.bpel.ui.editors.xpath.rules.ITokenContext;
import org.eclipse.bpel.ui.editors.xpath.rules.SingleCharRule;
import org.eclipse.bpel.ui.editors.xpath.rules.SingleOperatorRule;
import org.eclipse.bpel.ui.editors.xpath.rules.StringRule;
import org.eclipse.bpel.ui.editors.xpath.rules.WordRule;
import org.eclipse.bpel.ui.preferences.PreferenceConstants;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class XPathSourceScanner
extends BufferedRuleBasedScanner {
    IWordDetector fNCNameDetector = new XPathWordDetector.NCNameWordDetector();
    IWordDetector fWordDetector = new XPathWordDetector();
    IWordDetector fVariableNameDetector = new XPathWordDetector.VariableDetector();
    IWordDetector fQNameDetector = new XPathWordDetector.QNameDetector();
    LinkedList<IToken> tokenWindow = new LinkedList();
    private static final String[] XPATH_FUNCTIONS = new String[]{"last", "position", "count", "id", "local-name", "namespace-uri", "name", "string", "concat", "starts-with", "contains", "substring-before", "substring-after", "substring", "string-length", "normalize-space", "translate", "boolean", "not", "true", "false", "lang", "number", "sum", "floor", "ceiling", "round"};
    private static final String[] AXIS = new String[]{"ancestor", "ancestor-or-self", "attribute", "child", "descendant", "descendant-or-self", "following", "following-sibling", "namespace", "parent", "preceding", "preceding-sibling", "self"};

    public XPathSourceScanner(ColorManager manager) {
        Token defToken = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.DEFAULT)));
        Token operatorToken = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.OPERAND), null, 1));
        Token number = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.NUMBER), null, 1));
        Token string = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.STRING)));
        Token brackets = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.BRACKET), null, 1));
        Token axis = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.AXIS), null, 2));
        Token pathSep = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.PATH_SEPARATOR), null, 1));
        Token functionsDefault = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.FUNCTIONS_XPATH), null, 2));
        Token functions = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.FUNCTIONS_XPATH), null, 1));
        Token variableToken = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.VARIABLES), null, 1));
        Token partToken = new Token((Object)new TextAttribute(manager.getColor(PreferenceConstants.VARIABLE_PART), null, 1));
        ArrayList<Object> rules = new ArrayList<Object>(24);
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new XPathWhitespaceDetector()));
        rules.add(new FloatRule((IToken)number));
        WordRule wordRule = new WordRule(this.fVariableNameDetector);
        wordRule.addWord("<.:.@>", (IToken)variableToken);
        rules.add(wordRule);
        wordRule = new WordRule(new XPathWordDetector.MessagePartDetector());
        wordRule.addWord("<.:.@>", (IToken)partToken);
        wordRule.setTokenContextCheck(new TokenContext((IToken)variableToken){
            private final /* synthetic */ IToken val$variableToken;
            {
                this.val$variableToken = iToken;
            }

            @Override
            public boolean checkSeenTokens(XPathSourceScanner scanner) {
                return scanner.lastToken(0) == this.val$variableToken;
            }
        });
        rules.add(wordRule);
        rules.add(new SingleOperatorRule((IToken)operatorToken, "+-*=|/<>"));
        rules.add(new StringRule((IToken)operatorToken, "!="));
        rules.add(new StringRule((IToken)operatorToken, ">="));
        rules.add(new StringRule((IToken)operatorToken, "<="));
        rules.add(new StringRule((IToken)operatorToken, ">="));
        rules.add(new SingleCharRule((IToken)brackets, "[]().@,"));
        rules.add(new StringRule((IToken)operatorToken, "//"));
        rules.add(new StringRule((IToken)pathSep, "::"));
        wordRule = new WordRule(new XPathWordDetector());
        wordRule.addWord("mod", (IToken)operatorToken);
        wordRule.addWord("div", (IToken)operatorToken);
        wordRule.addWord("and", (IToken)operatorToken);
        wordRule.addWord("or", (IToken)operatorToken);
        wordRule.setTokenContextCheck(new TokenContext((IToken)operatorToken){
            private final /* synthetic */ IToken val$operatorToken;
            {
                this.val$operatorToken = iToken;
            }

            @Override
            public boolean checkSeenTokens(XPathSourceScanner scanner) {
                int idx;
                int n = idx = scanner.lastToken(0) == Token.WHITESPACE ? 1 : 0;
                return scanner.lastToken(idx) != this.val$operatorToken;
            }
        });
        rules.add(wordRule);
        AxisRule axisRule = new AxisRule(this.fNCNameDetector);
        axisRule.addWords(AXIS, (IToken)axis);
        rules.add((Object)axisRule);
        FunctionRule functionRule = new FunctionRule(this.fQNameDetector);
        functionRule.addWords(XPATH_FUNCTIONS, (IToken)functionsDefault);
        rules.add(functionRule);
        functionRule = new FunctionRule(this.fQNameDetector);
        functionRule.addWord("<.:.@>", (IToken)functions);
        rules.add(functionRule);
        wordRule = new WordRule(this.fWordDetector);
        wordRule.addWord("<.:.@>", (IToken)defToken);
        rules.add(wordRule);
        this.setDefaultReturnToken((IToken)defToken);
        this.setRules(rules.toArray(new IRule[0]));
    }

    public IToken nextToken() {
        IToken next = super.nextToken();
        this.tokenWindow.addFirst(next);
        if (this.tokenWindow.size() > 4) {
            this.tokenWindow.removeLast();
        }
        return next;
    }

    public IToken lastToken(int offset) {
        try {
            return this.tokenWindow.get(offset);
        }
        catch (Throwable throwable) {
            return Token.UNDEFINED;
        }
    }

    abstract class TokenContext
    implements ITokenContext {
        TokenContext() {
        }

        @Override
        public boolean check(ICharacterScanner scanner) {
            if (scanner instanceof XPathSourceScanner) {
                return this.checkSeenTokens((XPathSourceScanner)scanner);
            }
            return false;
        }

        public abstract boolean checkSeenTokens(XPathSourceScanner var1);
    }
}

