/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.ImageUtils;
import org.eclipse.bpel.common.ui.markers.ModelMarkerUtil;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.policies.LinkConnectionEditPolicy;
import org.eclipse.bpel.ui.editparts.util.OverlayCompositeImageDescriptor;
import org.eclipse.bpel.ui.figures.BPELPolylineConnection;
import org.eclipse.bpel.ui.figures.ManhattanConnectionRouterEx;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class LinkEditPart
extends AbstractConnectionEditPart {
    private IFigure layer;
    private MultiObjectAdapter adapter = new MultiObjectAdapter(){

        @Override
        public void notify(Notification n) {
            if (LinkEditPart.this.isActive()) {
                LinkEditPart.this.handleModelChanged();
            }
            LinkEditPart.this.refreshAdapters();
        }
    };
    private Image decorationImage;
    private IFigure decoration;
    private Image topLeft;
    private Image topRight;
    private Image bottomLeft;
    private Image bottomRight;
    private Image arrowDown;
    private Image arrowRight;
    protected AccessibleEditPart acc;

    protected void addAllAdapters() {
        Target target;
        Source source;
        Link link = this.getLink();
        this.adapter.addToObject((Notifier)link);
        if (link.eContainer() != null) {
            this.adapter.addToObject((Notifier)link.eContainer());
        }
        if (link.getSources().size() > 0 && (source = (Source)link.getSources().get(0)) != null) {
            this.adapter.addToObject((Notifier)source);
            Activity sourceActivity = source.getActivity();
            if (sourceActivity != null) {
                this.adapter.addToObject((Notifier)sourceActivity);
                EObject sourceParent = sourceActivity.eContainer();
                if (sourceParent != null) {
                    this.adapter.addToObject((Notifier)sourceParent);
                }
            }
        }
        if (link.getTargets().size() > 0 && (target = (Target)link.getTargets().get(0)) != null) {
            this.adapter.addToObject((Notifier)target);
            Activity targetActivity = target.getActivity();
            if (targetActivity != null) {
                this.adapter.addToObject((Notifier)targetActivity);
                EObject targetParent = targetActivity.eContainer();
                if (targetParent != null) {
                    this.adapter.addToObject((Notifier)targetParent);
                }
            }
        }
    }

    protected void removeAllAdapters() {
        this.adapter.removeFromAll();
    }

    protected void refreshAdapters() {
        this.removeAllAdapters();
        this.addAllAdapters();
    }

    public void refresh() {
        super.refresh();
        this.applyConnectionRouter(this.getConnectionFigure());
    }

    protected void handleModelChanged() {
        if (this.isActive()) {
            this.refreshVisuals();
        }
    }

    protected IFigure createFigure() {
        if (this.getLink() == null) {
            return null;
        }
        BPELUIPlugin plugin = BPELUIPlugin.INSTANCE;
        this.topLeft = plugin.getImage("ovr16/link_topleft.png");
        this.topRight = plugin.getImage("ovr16/link_topright.png");
        this.bottomLeft = plugin.getImage("ovr16/link_bottomleft.png");
        this.bottomRight = plugin.getImage("ovr16/link_bottomright.png");
        this.arrowDown = plugin.getImage("ovr16/link_arrowdown.png");
        this.arrowRight = plugin.getImage("ovr16/link_arrowright.png");
        BPELPolylineConnection c = new BPELPolylineConnection(this.topLeft, this.topRight, this.bottomLeft, this.bottomRight, this.arrowDown, this.arrowRight);
        this.applyConnectionRouter((Connection)c);
        return c;
    }

    public void contributeToGraph(CompoundDirectedGraph graph, Map map) {
        Node source = (Node)map.get(this.getSource());
        Node target = (Node)map.get(this.getTarget());
        Edge e = new Edge((Object)this, source, target);
        graph.edges.add((Object)e);
        map.put(this, e);
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.addAllAdapters();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.removeAllAdapters();
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new LinkConnectionEditPolicy());
    }

    protected void unregisterVisuals() {
        if (this.decorationImage != null) {
            this.decorationImage.dispose();
            this.decorationImage = null;
        }
        super.unregisterVisuals();
    }

    protected Link getLink() {
        return (Link)this.getModel();
    }

    protected void activateFigure() {
        this.layer = this.getLayer("Connection Layer");
        this.layer.add(this.getFigure());
    }

    protected void deactivateFigure() {
        this.layer.remove(this.getFigure());
        this.getConnectionFigure().setSourceAnchor(null);
        this.getConnectionFigure().setTargetAnchor(null);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshDecorations();
    }

    protected void refreshDecorations() {
        Link link;
        if (this.decoration != null) {
            this.getFigure().remove(this.decoration);
            this.decoration = null;
        }
        if (this.decorationImage != null) {
            this.decorationImage.dispose();
            this.decorationImage = null;
        }
        if ((link = this.getLink()).eContainer() == null) {
            return;
        }
        IMarkerHolder markerHolder = BPELUtil.adapt((Object)link, IMarkerHolder.class);
        IMarker[] markers = markerHolder.getMarkers(link);
        IMarker markerToDisplay = null;
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            boolean isVisible = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", true);
            if (isVisible) {
                if (markerToDisplay != null) {
                    int existingPriority;
                    int priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", Integer.MIN_VALUE);
                    if (priority > (existingPriority = markerToDisplay.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", Integer.MIN_VALUE))) {
                        markerToDisplay = marker;
                    }
                } else {
                    markerToDisplay = marker;
                }
            }
            ++i;
        }
        if (markerToDisplay != null) {
            Image image;
            Image temp = this.getImage(markerToDisplay);
            if (temp == null) {
                return;
            }
            ImageData background = temp.getImageData();
            String uri = markerToDisplay.getAttribute("overlayImageTopLeft", "");
            ImageData topLeft = this.getImageData(uri);
            uri = markerToDisplay.getAttribute("overlayImageTopRight", "");
            ImageData topRight = this.getImageData(uri);
            uri = markerToDisplay.getAttribute("overlayImageBottomLeft", "");
            ImageData bottomLeft = this.getImageData(uri);
            uri = markerToDisplay.getAttribute("overlayImageBottomRight", "");
            ImageData bottomRight = this.getImageData(uri);
            OverlayCompositeImageDescriptor descriptor = new OverlayCompositeImageDescriptor(background, topLeft, topRight, bottomLeft, bottomRight);
            this.decorationImage = image = descriptor.createImage();
            this.decoration = new Label(this.decorationImage);
            this.getFigure().add(this.decoration, (Object)new ConnectionLocator(this.getConnectionFigure(), 4));
        } else if (this.hasCondition()) {
            Image image = BPELUIPlugin.INSTANCE.getImage("obj16/condlnk_dgm16.gif");
            this.decorationImage = null;
            this.decoration = new Label(image);
            this.getFigure().add(this.decoration, (Object)new ConnectionLocator(this.getConnectionFigure(), 4));
        }
    }

    protected boolean hasCondition() {
        Link link = this.getLink();
        EList sourcesList = link.getSources();
        if (!sourcesList.isEmpty()) {
            Source source = (Source)sourcesList.get(0);
            return source.getTransitionCondition() != null;
        }
        return false;
    }

    private Image getImage(IMarker marker) {
        Image image = ModelMarkerUtil.getImage((IMarker)marker);
        if (image == null) {
            try {
                if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    return ImageUtils.getImage((IMarker)marker);
                }
            }
            catch (CoreException e) {
                CommonUIPlugin.log((Exception)((Object)e));
            }
        }
        return image;
    }

    private ImageData getImageData(String uri) {
        if (uri.length() == 0) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        return desc.getImageData();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    public AccessibleEditPart createAccessible() {
        LinkEditPart thisPart = this;
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this, (GraphicalEditPart)thisPart){
            private final /* synthetic */ GraphicalEditPart val$thisPart;
            {
                this.val$thisPart = graphicalEditPart;
                super(abstractGraphicalEditPart);
            }

            public void getName(AccessibleEvent e) {
                String childType = null;
                String displayName = null;
                ILabeledElement labeledElement = BPELUtil.adapt(this.val$thisPart.getModel(), ILabeledElement.class);
                if (labeledElement != null) {
                    childType = labeledElement.getTypeLabel(this.val$thisPart.getModel());
                    displayName = labeledElement.getLabel(this.val$thisPart.getModel());
                    if (childType != null && childType.equals(displayName)) {
                        childType = null;
                    }
                } else {
                    e.result = null;
                    return;
                }
                StringBuffer concat = new StringBuffer();
                if (childType != null && childType.length() > 0) {
                    concat.append(childType);
                }
                if (concat.length() > 0) {
                    concat.append(" ");
                }
                if (displayName != null && displayName.length() > 0) {
                    concat.append(displayName);
                }
                e.result = concat.length() > 0 ? concat.toString() : null;
            }

            public void getValue(AccessibleControlEvent e) {
                Link link = (Link)this.val$thisPart.getModel();
                Activity source = FlowLinkUtil.getLinkSource(link);
                Activity target = FlowLinkUtil.getLinkTarget(link);
                if (source != null && target != null) {
                    ILabeledElement labeledElement1 = BPELUtil.adapt((Object)source, ILabeledElement.class);
                    ILabeledElement labeledElement2 = BPELUtil.adapt((Object)target, ILabeledElement.class);
                    if (labeledElement1 != null && labeledElement2 != null) {
                        e.result = String.valueOf(labeledElement1.getLabel(source)) + "-" + labeledElement2.getLabel(target);
                    }
                }
            }
        };
    }

    private void applyConnectionRouter(Connection con) {
        EditPart conTo;
        EditPart editPart = conTo = this.getSource() == null ? this.getTarget() : this.getSource();
        if (conTo != null) {
            if (ModelHelper.isHorizontalLayout(conTo.getModel())) {
                con.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouterEx(ManhattanConnectionRouterEx.RIGHT, ManhattanConnectionRouterEx.LEFT));
            } else {
                con.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
            }
        }
    }
}

