/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.properties.ExpressionSection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;

public class JoinConditionSection
extends ExpressionSection {
    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        Activity activity = (Activity)this.getModel();
        Targets targets = activity.getTargets();
        if (targets != null) {
            this.fAdapters[0].addToObject((Notifier)targets);
        }
    }

    @Override
    protected String getExpressionType() {
        return "joinCondition/boolean";
    }

    @Override
    protected boolean isExpressionOptional() {
        return true;
    }

    @Override
    protected Composite createNoEditorWidgets(Composite composite) {
        return this.createNoEditorWidgetsCreateComposite(composite, String.valueOf(Messages.JoinConditionSection_No_condition_specified_1) + "\n" + "\n" + Messages.JoinConditionSection_Optional_condition_text_2, Messages.JoinConditionSection_Create_a_New_Condition_3);
    }

    @Override
    protected EObject getExpressionTarget() {
        Activity activity = (Activity)this.getModel();
        return activity.getTargets();
    }

    @Override
    protected EStructuralFeature getStructuralFeature(EObject object) {
        if (object instanceof Activity) {
            return BPELPackage.eINSTANCE.getTargets_JoinCondition();
        }
        return super.getStructuralFeature(object);
    }

    @Override
    protected void updateWidgets() {
        super.updateWidgets();
        Activity activity = (Activity)this.getModel();
        Targets targets = activity.getTargets();
        boolean enable = targets != null;
        this.expressionLanguageViewer.getControl().setEnabled(enable);
        if (!this.hasEditor() && this.fCreateExpressionButton != null) {
            this.fCreateExpressionButton.setEnabled(enable);
        }
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.updateWidgets();
    }

    @Override
    protected boolean isValidClientUseType(String useType) {
        return "joinCondition".equals(useType);
    }

    @Override
    protected IMarker[] getMarkers(Object input) {
        Activity activity;
        Targets targets;
        if (input instanceof Activity && (targets = (activity = (Activity)input).getTargets()) != null) {
            return super.getMarkers(targets.getJoinCondition());
        }
        return EMPTY_MARKERS;
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        String context = null;
        try {
            context = (String)marker.getAttribute("href.context");
        }
        catch (Exception exception) {
            return false;
        }
        return !"name".equals(context);
    }
}

