/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import java.util.List;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.InsertInContainerCommand;
import org.eclipse.bpel.ui.commands.SetNameAndDirectEditCommand;
import org.eclipse.bpel.ui.commands.SetSelectionCommand;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;

public class AppendNewAction
extends SelectionAction {
    protected AbstractUIObjectFactory factory;
    protected Object cachedInstance;
    protected BPELExtensibleElement fSelection;

    public AppendNewAction(IWorkbenchPart editor, AbstractUIObjectFactory aFactory) {
        this(editor, aFactory, aFactory.getTypeLabel());
    }

    public AppendNewAction(IWorkbenchPart editor, AbstractUIObjectFactory aFactory, String label) {
        super(editor);
        this.factory = aFactory;
        this.cachedInstance = this.factory.getNewObject();
        this.setId(this.calculateID());
        this.setText(label);
        this.setToolTipText(NLS.bind((String)Messages.AppendNewAction_Add_a_1, (Object[])new Object[]{this.getText()}));
        this.setImageDescriptor(this.factory.getSmallImageDescriptor());
    }

    protected void init() {
        super.init();
        this.setEnabled(false);
    }

    protected String calculateID() {
        return "appendNew." + this.factory.getUniqueIdString();
    }

    public Command getCreateCommand() {
        if (this.fSelection == null) {
            return null;
        }
        CompoundCommand compoundCmd = new CompoundCommand();
        BPELEditor bpelEditor = (BPELEditor)this.getWorkbenchPart();
        GraphicalViewer viewer = bpelEditor.getGraphicalViewer();
        EObject model = (EObject)this.factory.getNewObject();
        compoundCmd.add((Command)new InsertInContainerCommand((EObject)this.fSelection, model, null));
        compoundCmd.add((Command)new SetSelectionCommand((EObject)this.fSelection, true));
        compoundCmd.add((Command)new SetSelectionCommand(model, false));
        compoundCmd.add((Command)new SetNameAndDirectEditCommand(model, (EditPartViewer)viewer));
        return compoundCmd;
    }

    protected boolean calculateEnabled() {
        List objects = this.getSelectedObjects();
        if (objects.size() != 1) {
            this.fSelection = null;
            return false;
        }
        Object sel = objects.get(0);
        if (sel instanceof EditPart) {
            EditPart part = (EditPart)sel;
            sel = part.getModel();
        }
        if (sel instanceof BPELExtensibleElement) {
            this.fSelection = (BPELExtensibleElement)sel;
        }
        if (this.fSelection == null) {
            this.fSelection = null;
            return false;
        }
        IContainer container = BPELUtil.adapt((Object)this.fSelection, IContainer.class);
        if (container == null) {
            this.fSelection = null;
            return false;
        }
        if (!container.canAddObject(this.fSelection, this.cachedInstance, null)) {
            this.fSelection = null;
            return false;
        }
        return true;
    }

    public void run() {
        this.execute(this.getCreateCommand());
    }
}

