/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.composite;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.Utils;
import org.eclipse.bpel.common.ui.composite.CompositeEditorActionBars;
import org.eclipse.bpel.common.ui.composite.CompositeEditorSite;
import org.eclipse.bpel.common.ui.composite.EditorReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class CompositeEditorManager {
    protected WorkbenchPage page;
    protected IEditorSite mainEditorSite;
    protected Map idToDescriptor;
    private static final String EXTPT_EMBEDDED_EDITORS = "embeddedEditors";
    private static final String CHILD_EDITOR = "editor";
    private static final String ATT_EDITOR_ID = "id";
    private static final String ATT_EDITOR_CLASS = "class";

    public CompositeEditorManager(IEditorSite mainEditorSite) {
        this.mainEditorSite = mainEditorSite;
        this.idToDescriptor = new HashMap(10);
        this.page = (WorkbenchPage)mainEditorSite.getPage();
    }

    public IEditorPart createEditor(String editorId, IEditorInput input) throws CoreException {
        IEditorPart editor = this.instantiateEditor(editorId);
        EditorSite site = this.createEditorSite(editorId, editor);
        editor.init((IEditorSite)site, input);
        IMenuManager menuManager = this.mainEditorSite.getActionBars().getMenuManager();
        menuManager.setVisible(false);
        menuManager.setVisible(true);
        return editor;
    }

    protected IEditorPart instantiateEditor(String editorId) throws CoreException {
        EditorDescriptor descriptor = (EditorDescriptor)this.idToDescriptor.get(editorId);
        if (descriptor == null && (descriptor = this.readDescriptor(editorId)) == null) {
            Status status = new Status(4, "org.eclipse.bpel.common.ui", 2, NLS.bind((String)Messages.CompositeEditorManager_Could_not_find_editor, (Object[])new Object[]{editorId}), null);
            throw new CoreException((IStatus)status);
        }
        return (IEditorPart)descriptor.getConfigurationElement().createExecutableExtension(ATT_EDITOR_CLASS);
    }

    protected EditorDescriptor readDescriptor(String editorId) {
        IConfigurationElement[] elements = Utils.getConfigurationElements(EXTPT_EMBEDDED_EDITORS);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(CHILD_EDITOR)) {
                String extensionId = element.getAttribute(ATT_EDITOR_ID);
                if (extensionId == null) {
                    String pluginId = element.getDeclaringExtension().getNamespace();
                    Status status = new Status(4, pluginId, 1, Messages.CompositeEditorManager_5, null);
                    CommonUIPlugin.getDefault().getLog().log((IStatus)status);
                } else if (editorId.equals(extensionId)) {
                    try {
                        Constructor constuctor = EditorDescriptor.class.getDeclaredConstructor(new Class[0]);
                        constuctor.setAccessible(true);
                        EditorDescriptor descriptor = (EditorDescriptor)constuctor.newInstance(new Object[0]);
                        Method method = descriptor.getClass().getDeclaredMethod("setID", String.class);
                        method.setAccessible(true);
                        method.invoke((Object)descriptor, editorId);
                        method = descriptor.getClass().getDeclaredMethod("setConfigurationElement", IConfigurationElement.class);
                        method.setAccessible(true);
                        method.invoke((Object)descriptor, element);
                        this.idToDescriptor.put(editorId, descriptor);
                        return descriptor;
                    }
                    catch (SecurityException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (IllegalArgumentException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (NoSuchMethodException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (InstantiationException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (IllegalAccessException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                    catch (InvocationTargetException e) {
                        CommonUIPlugin.getDefault().createErrorStatus("Problem creating descriptor for " + editorId, e, true);
                    }
                }
            }
            ++i;
        }
        return null;
    }

    protected EditorSite createEditorSite(String editorId, IEditorPart editor) {
        EditorDescriptor descriptor = (EditorDescriptor)this.idToDescriptor.get(editorId);
        EditorReference ref = new EditorReference();
        CompositeEditorSite site = new CompositeEditorSite(this.mainEditorSite, ref, editor, this.page, descriptor);
        IEditorActionBarContributor contributor = descriptor.createActionBarContributor();
        site.setActionBars((SubActionBars)this.createEditorActionBars(descriptor, contributor, site));
        return site;
    }

    protected CompositeEditorActionBars createEditorActionBars(EditorDescriptor descriptor, IEditorActionBarContributor contributor, EditorSite site) {
        EditorActionBuilder builder;
        IEditorActionBarContributor extension;
        String type = String.valueOf(System.currentTimeMillis());
        CompositeEditorActionBars actionBars = new CompositeEditorActionBars(this.page, (IServiceLocator)site, type);
        if (contributor != null) {
            actionBars.setEditorContributor(contributor);
            contributor.init((IActionBars)actionBars, (IWorkbenchPage)this.page);
        }
        if ((extension = (builder = new EditorActionBuilder()).readActionExtensions((IEditorDescriptor)descriptor)) != null) {
            actionBars.setExtensionContributor(extension);
            extension.init((IActionBars)actionBars, (IWorkbenchPage)this.page);
        }
        return actionBars;
    }

    public void activate(IEditorPart editor) {
        editor.setFocus();
        IEditorSite site = editor.getEditorSite();
        CompositeEditorActionBars actionBars = (CompositeEditorActionBars)site.getActionBars();
        actionBars.partChanged((IWorkbenchPart)editor);
        actionBars.activate(true);
        ((CompositeEditorSite)site).activate();
    }

    public void deactivate(IEditorPart editor) {
        if (editor != null) {
            CompositeEditorActionBars actionBars = (CompositeEditorActionBars)editor.getEditorSite().getActionBars();
            actionBars.deactivate(true);
            IEditorSite site = editor.getEditorSite();
            ((CompositeEditorSite)site).deactivate();
        }
    }

    public IEditorPart createEditor(String editorId, IEditorInput input, Composite editorComposite) throws CoreException {
        IEditorPart editor = this.createEditor(editorId, input);
        Composite composite = new Composite(editorComposite, 0);
        composite.setLayout((Layout)new FillLayout());
        editor.createPartControl(composite);
        this.associate(editor, (Control)composite);
        return editor;
    }

    protected void associate(final IEditorPart editor, Control control) {
        control.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                CompositeEditorManager.this.activate(editor);
            }
        });
        control.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                CompositeEditorManager.this.deactivate(editor);
            }
        });
    }

    public void disposeEditor(IEditorPart editor) {
        CompositeEditorSite site = (CompositeEditorSite)editor.getSite();
        CompositeEditorActionBars actionBars = (CompositeEditorActionBars)site.getActionBars();
        actionBars.dispose();
        site.dispose();
        editor.dispose();
    }
}

