/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class VariableValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_VARIABLES);
    String ncName;
    protected INode fMessageTypeNode;
    protected INode fElementNode;
    private INode fTypeNode;
    protected INode fFromNode;

    @Override
    protected void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_NAME);
        this.fFromNode = this.mNode.getNode(ND_FROM);
    }

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_FROM, 0, 1);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/14/2006", desc="Checks that variable NCName further does not contain a period (.) in the name.", sa=24, errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad,BPELC_VARIABLE__NO_DOT")
    public void rule_CheckName_1() {
        if (!this.checkNCName(this.mNode, this.ncName, AT_NAME)) {
            return;
        }
        if (this.ncName.indexOf(46) >= 0) {
            IProblem problem = this.createError();
            problem.setAttribute("context.name", AT_NAME);
            problem.fill("BPELC_VARIABLE__NO_DOT", this.ncName);
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/14/2006", desc="Variable type specification (either element, messaageType, or type).", sa=25, errors="BPELC_VARIABLE__NO_TYPE")
    public void rule_CheckType_2() {
        QName type;
        QName element;
        int typeCount = 0;
        QName messageType = this.mNode.getAttributeAsQName(AT_MESSAGE_TYPE);
        if (messageType != null) {
            ++typeCount;
            this.fMessageTypeNode = this.mModelQuery.lookup(this.mNode, 7, messageType);
        }
        if ((element = this.mNode.getAttributeAsQName(AT_ELEMENT)) != null) {
            ++typeCount;
            this.fElementNode = this.mModelQuery.lookup(this.mNode, 8, element);
        }
        if ((type = this.mNode.getAttributeAsQName(AT_TYPE)) != null) {
            ++typeCount;
            this.fTypeNode = this.mModelQuery.lookup(this.mNode, 9, type);
        }
        if (typeCount == 0) {
            IProblem problem = this.createError();
            problem.setAttribute("context.name", AT_TYPE);
            problem.fill("BPELC_VARIABLE__NO_TYPE", this.ncName);
        } else if (typeCount > 1) {
            IProblem problem = this.createError();
            problem.setAttribute("context.name", AT_TYPE);
            problem.fill("BPELC_VARIABLE__NO_TYPE", this.ncName);
        }
    }

    @ARule(sa=10, desc="Make sure that Message Type is visible from the import(s)", author="michal.chmielewski@oracle.com", date="01/25/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE")
    public void rule_CheckMessageTypeNode_4() {
        if (this.fMessageTypeNode == null) {
            return;
        }
        this.checkAttributeNode(this.mNode, this.fMessageTypeNode, AT_MESSAGE_TYPE, 0);
        this.setValue("type", this.fMessageTypeNode);
    }

    @ARule(sa=10, desc="Make sure that Element is visible from the import(s)", author="michal.chmielewski@oracle.com", date="01/25/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE")
    public void rule_CheckElementNode_4() {
        if (this.fElementNode == null) {
            return;
        }
        this.checkAttributeNode(this.mNode, this.fElementNode, AT_ELEMENT, 0);
        this.setValue("type", this.fElementNode);
    }

    @ARule(sa=10, desc="Make sure that Type is visible from the import(s)", author="michal.chmielewski@oracle.com", date="01/25/2007", errors="BPELC__UNSET_ATTRIBUTE")
    public void rule_CheckTypeNode_4() {
        if (this.fTypeNode == null) {
            return;
        }
        this.checkAttributeNode(this.mNode, this.fTypeNode, AT_TYPE, 0);
        this.setValue("type", this.fTypeNode);
    }

    @ARule(sa=0, desc="Check to see if variable hides super variables", author="michal.chmielewski@oracle.com", date="01/25/2007", infos="BPELC__LEXICAL_HIDE")
    public void rule_CheckIfVariableHidesSuperVariables_15() {
        INode refNode = this.mNode.parentNode();
        if (refNode == null) {
            return;
        }
        if ((refNode = refNode.parentNode()) == null) {
            return;
        }
        if ((refNode = refNode.parentNode()) == null) {
            return;
        }
        INode node = this.mModelQuery.lookup(refNode, 1, this.ncName);
        if (node == null || !node.isResolved() || this.mModelQuery.check(0, node, this.mNode)) {
            return;
        }
        IProblem problem = this.createInfo();
        problem.setAttribute("context.name", AT_NAME);
        problem.fill("BPELC__LEXICAL_HIDE", ND_VARIABLE, this.ncName);
    }

    @ARule(sa=14, desc="Mark the types/elements/messages used to be checked for duplicates", author="michal.chmielewski@oracle.com", date="02/25/2007", errors="BPELC_XSD__CONFLICTING_DEFINITION")
    public void rule_RegisterTypesToCheck_50() {
        this.registerTypeToCheck(this.fElementNode);
        this.registerTypeToCheck(this.fTypeNode);
        this.registerTypeToCheck(this.fMessageTypeNode);
    }

    @ARule(sa=76, desc="For <forEach>  the enclosed scope MUST NOT  declare a variable with the same name as specified in the counterName  attribute of <forEach>.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_VARIABLE__COUNTER")
    public void rule_CheckForEachCounter_30() {
        INode scope = this.fParentNode.parentNode();
        if (!ND_SCOPE.equals(scope.nodeName())) {
            return;
        }
        INode forEachNode = scope.parentNode();
        if (!ND_FOR_EACH.equals(forEachNode.nodeName())) {
            return;
        }
        String counterName = forEachNode.getAttribute(AT_COUNTER_NAME);
        if (VariableValidator.isEmptyOrWhitespace(counterName)) {
            return;
        }
        if (counterName.equals(this.ncName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_VARIABLE__COUNTER", this.toString(this.mNode.nodeName()), this.ncName, forEachNode.nodeName(), forEachNode.getAttribute(AT_NAME));
        }
    }

    @ARule(sa=43, desc="From and to spec must have compatible types", author="michal.chmielewski@oracle.com", date="02/16/2007", tag="pass2", errors="BPELC_COPY__INCOMPATIBLE", warnings="BPELC_COPY__INCOMPATIBLE_SIMPLE", infos="BPELC_COPY__NOT_CHECKED")
    public void rule_CheckCompatibleCopy_40() {
        if (this.isUndefined(this.fFromNode)) {
            return;
        }
        this.compatibleCopyCheck(this.fFromNode, this.mNode);
    }
}

