/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IHoverHelper;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.bpelactions.AbstractBPELAction;
import org.eclipse.bpel.ui.expressions.DefaultExpressionEditor;
import org.eclipse.bpel.ui.expressions.IExpressionEditor;
import org.eclipse.bpel.ui.extensions.ActionCategoryDescriptor;
import org.eclipse.bpel.ui.extensions.ActionDescriptor;
import org.eclipse.bpel.ui.extensions.ExpressionEditorDescriptor;
import org.eclipse.bpel.ui.extensions.HoverHelperDescriptor;
import org.eclipse.bpel.ui.extensions.IModelListener;
import org.eclipse.bpel.ui.extensions.ListenerDescriptor;
import org.eclipse.bpel.ui.extensions.UIObjectFactoryDescriptor;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;

public class BPELUIRegistry {
    static final String EXTPT_HOVERHELPERS = "hoverHelpers";
    static final String ELEMENT_HOVERHELPER = "hoverHelper";
    static final String EXTPT_EXPRESSION_EDITORS = "expressionEditors";
    static final String ELEMENT_EDITOR = "editor";
    static final String ATT_EXPRESSION_LANGUAGE = "expressionLanguage";
    static final String ATT_CLASS = "class";
    static final String ATT_LABEL = "label";
    static final String EXTPT_ACTIONS = "actions";
    static final String ELEMENT_CATEGORY = "category";
    static final String ATT_NAME = "name";
    static final String ATT_ID = "id";
    static final String ELEMENT_ACTION = "action";
    static final String ATT_CATEGORY_ID = "categoryId";
    static final String EXTPT_MODELLISTENER = "modelListener";
    static final String ELEMENT_LISTENER = "listener";
    static final String ATT_SPEC_COMPLIANT = "specCompliant";
    static final ExpressionEditorDescriptor[] EMPTY_EDITOR_DESCRIPTORS = new ExpressionEditorDescriptor[0];
    private static BPELUIRegistry instance;
    private Map<String, ExpressionEditorDescriptor> fLanguageToEditorDescriptor;
    private HoverHelperDescriptor hoverHelperDescriptor;
    private ActionCategoryDescriptor[] fActionCategoryDescriptors;
    private ActionDescriptor[] fActionDescriptors;
    private ListenerDescriptor[] fListenerDescriptors;
    private UIObjectFactoryDescriptor[] uiObjectFactoryDescriptor;
    private IHoverHelper hoverHelper;

    private BPELUIRegistry() {
        this.readExpressionLanguageEditors();
        this.readHoverHelpers();
        this.readActions();
        this.readListeners();
        this.readUIObjecFactories();
    }

    public static BPELUIRegistry getInstance() {
        if (instance == null) {
            instance = new BPELUIRegistry();
        }
        return instance;
    }

    public IHoverHelper getHoverHelper() throws CoreException {
        if (this.hoverHelperDescriptor == null) {
            return null;
        }
        if (this.hoverHelper == null) {
            this.hoverHelper = this.hoverHelperDescriptor.createHoverHelper();
        }
        return this.hoverHelper;
    }

    public IExpressionEditor getExpressionEditor(String expressionLanguage) throws CoreException {
        ExpressionEditorDescriptor descriptor = this.fLanguageToEditorDescriptor.get(expressionLanguage);
        if (descriptor == null) {
            return new DefaultExpressionEditor();
        }
        IExpressionEditor editor = descriptor.createEditor();
        return editor;
    }

    public ExpressionEditorDescriptor getExpressionEditorDescriptor(String expressionLanguage) {
        return this.fLanguageToEditorDescriptor.get(expressionLanguage);
    }

    private void readExpressionLanguageEditors() {
        this.fLanguageToEditorDescriptor = new HashMap<String, ExpressionEditorDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElements(EXTPT_EXPRESSION_EDITORS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement editor = iConfigurationElementArray[n2];
            if (editor.getName().equals(ELEMENT_EDITOR)) {
                String language = editor.getAttribute(ATT_EXPRESSION_LANGUAGE);
                String clazz = editor.getAttribute(ATT_CLASS);
                if (language == null || clazz == null) {
                    String pluginId = BPELUIPlugin.INSTANCE.getBundle().getSymbolicName();
                    Status status = new Status(4, pluginId, 0, Messages.BPELUIRegistry_Expression_language_editors_must_provide_expressionLanguage_and_class__8, null);
                    BPELUIPlugin.INSTANCE.getLog().log((IStatus)status);
                } else {
                    ExpressionEditorDescriptor descriptor = new ExpressionEditorDescriptor();
                    descriptor.setExpressionLanguage(language);
                    descriptor.setElement(editor);
                    String label = editor.getAttribute(ATT_LABEL);
                    descriptor.setLabel(label);
                    this.fLanguageToEditorDescriptor.put(language, descriptor);
                }
            }
            ++n2;
        }
    }

    public UIObjectFactoryDescriptor[] getUIObjectFactoryDescriptors() {
        return this.uiObjectFactoryDescriptor;
    }

    public ActionDescriptor[] getActionDescriptors() {
        return this.fActionDescriptors;
    }

    public ActionDescriptor getActionDescriptor(EClass target) {
        ActionDescriptor[] actionDescriptorArray = this.fActionDescriptors;
        int n = this.fActionDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ActionDescriptor descriptor = actionDescriptorArray[n2];
            if (descriptor.getAction().getModelType() == target) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    public ActionCategoryDescriptor[] getActionCategoryDescriptors() {
        return this.fActionCategoryDescriptors;
    }

    public ListenerDescriptor[] getListenerDescriptors() {
        return this.fListenerDescriptors;
    }

    private void readHoverHelpers() {
        IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElements(EXTPT_HOVERHELPERS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String clazz;
            IConfigurationElement helper = iConfigurationElementArray[n2];
            if (helper.getName().equals(ELEMENT_HOVERHELPER) && (clazz = helper.getAttribute(ATT_CLASS)) != null) {
                HoverHelperDescriptor descriptor = new HoverHelperDescriptor();
                descriptor.setElement(helper);
                this.hoverHelperDescriptor = descriptor;
            }
            ++n2;
        }
    }

    private void readActions() {
        ArrayList<ActionCategoryDescriptor> categories = new ArrayList<ActionCategoryDescriptor>();
        ArrayList<ActionDescriptor> actions = new ArrayList<ActionDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElements(EXTPT_ACTIONS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(ELEMENT_CATEGORY)) {
                String name = element.getAttribute(ATT_NAME);
                String id = element.getAttribute(ATT_ID);
                if (name != null && id != null) {
                    ActionCategoryDescriptor descriptor = new ActionCategoryDescriptor();
                    descriptor.setName(name);
                    descriptor.setId(id);
                    categories.add(descriptor);
                }
            } else if (element.getName().equals(ELEMENT_ACTION)) {
                String id = element.getAttribute(ATT_ID);
                String category = element.getAttribute(ATT_CATEGORY_ID);
                String specCompliant = element.getAttribute(ATT_SPEC_COMPLIANT);
                if (category != null && id != null) {
                    ActionDescriptor descriptor = new ActionDescriptor();
                    descriptor.setId(id);
                    descriptor.setCategoryId(category);
                    descriptor.setSpecCompliant(Boolean.valueOf(specCompliant));
                    try {
                        AbstractBPELAction action = (AbstractBPELAction)element.createExecutableExtension(ATT_CLASS);
                        descriptor.setAction(action);
                    }
                    catch (CoreException e) {
                        BPELUIPlugin.log(e);
                    }
                    actions.add(descriptor);
                    AdapterFactory factory = descriptor.getAction().getAdapterFactory();
                    if (factory != null) {
                        BPELUtil.registerAdapterFactory(descriptor.getAction().getModelType(), factory);
                    }
                }
            }
            ++n2;
        }
        this.fActionCategoryDescriptors = new ActionCategoryDescriptor[categories.size()];
        categories.toArray(this.fActionCategoryDescriptors);
        this.fActionDescriptors = new ActionDescriptor[actions.size()];
        actions.toArray(this.fActionDescriptors);
    }

    private void readUIObjecFactories() {
        ArrayList<UIObjectFactoryDescriptor> factories = new ArrayList<UIObjectFactoryDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements("uiObjectFactories");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            if (element.getName().equals("factory")) {
                String id = element.getAttribute(ATT_ID);
                String category = element.getAttribute(ATT_CATEGORY_ID);
                String specCompliant = element.getAttribute(ATT_SPEC_COMPLIANT);
                if (category != null && id != null) {
                    UIObjectFactoryDescriptor descriptor = new UIObjectFactoryDescriptor();
                    descriptor.setId(id);
                    descriptor.setCategoryId(category);
                    descriptor.setSpecCompliant(Boolean.valueOf(specCompliant));
                    try {
                        AbstractUIObjectFactory factory = (AbstractUIObjectFactory)element.createExecutableExtension(ATT_CLASS);
                        descriptor.setFactory(factory);
                        descriptor.setConfigElement(element);
                    }
                    catch (CoreException e) {
                        BPELUIPlugin.log(e);
                    }
                    factories.add(descriptor);
                }
            }
            ++i;
        }
        this.uiObjectFactoryDescriptor = new UIObjectFactoryDescriptor[factories.size()];
        factories.toArray(this.uiObjectFactoryDescriptor);
    }

    private void readListeners() {
        ArrayList<ListenerDescriptor> listeners = new ArrayList<ListenerDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElements(EXTPT_MODELLISTENER);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(ELEMENT_LISTENER) && (id = element.getAttribute(ATT_ID)) != null) {
                ListenerDescriptor descriptor = new ListenerDescriptor();
                descriptor.setId(id);
                try {
                    IModelListener listener = (IModelListener)element.createExecutableExtension(ATT_CLASS);
                    descriptor.setModelListener(listener);
                }
                catch (CoreException e) {
                    BPELUIPlugin.log(e);
                }
                listeners.add(descriptor);
            }
            ++n2;
        }
        this.fListenerDescriptors = new ListenerDescriptor[listeners.size()];
        listeners.toArray(this.fListenerDescriptors);
    }

    private IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.bpel.ui", extensionPointId);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getConfigurationElements();
    }

    public ExpressionEditorDescriptor[] getExpressionEditorDescriptors() {
        return this.fLanguageToEditorDescriptor.values().toArray(EMPTY_EDITOR_DESCRIPTORS);
    }
}

