/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.common.ui.editmodel.ResourceInfo;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class AddImportCommand
extends AutoUndoCommand {
    Process fProcess;
    Import fImport;
    boolean bNoop = false;
    ResourceInfo fResourceInfo;

    public AddImportCommand(Process process, Object object, ResourceInfo info) {
        super(IBPELUIConstants.CMD_ADD_IMPORT, (EObject)process);
        this.fProcess = process;
        this.fResourceInfo = info;
        this.fImport = this.createImport(object);
        if (this.fImport != null) {
            this.bNoop = ModelHelper.containsImport(this.fProcess, this.fImport);
        }
    }

    public AddImportCommand(Process process, Object object) {
        this(process, object, null);
    }

    protected EList<Import> getList() {
        return this.fProcess.getImports();
    }

    @Override
    public void doExecute() {
        if (this.bNoop) {
            return;
        }
        this.fProcess.getImports().add(0, (Object)this.fImport);
    }

    public boolean wouldCreateDuplicateImport() {
        return this.bNoop;
    }

    Import createImport(Object obj) {
        if (obj instanceof Import) {
            return (Import)obj;
        }
        Import imp = null;
        EObject eObj = this.findImportableEntity((EObject)obj);
        if (eObj instanceof XSDSchema) {
            imp = this.createImportFrom((XSDSchema)eObj);
        } else if (eObj instanceof Definition) {
            imp = this.createImportFrom((Definition)eObj);
        }
        return imp;
    }

    EObject findImportableEntity(EObject eObj) {
        if (eObj instanceof XSDNamedComponent) {
            XSDNamedComponent xsdObj = (XSDNamedComponent)eObj;
            eObj = xsdObj.getSchema();
        }
        while (eObj != null) {
            if (eObj instanceof Definition) {
                return eObj;
            }
            if (eObj instanceof XSDSchema && eObj.eContainer() == null) {
                return eObj;
            }
            eObj = eObj.eContainer();
        }
        return eObj;
    }

    Import createImportFrom(XSDSchema schema) {
        Import imp = BPELFactory.eINSTANCE.createImport();
        String t = schema.getTargetNamespace();
        if (t != null) {
            imp.setNamespace(t);
        }
        Resource resource = this.fProcess.eResource();
        URI schemaURI = URI.createURI((String)schema.getSchemaLocation());
        imp.setLocation(schemaURI.deresolve(resource.getURI()).toString());
        imp.setImportType("http://www.w3.org/2001/XMLSchema");
        return imp;
    }

    Import createImportFrom(Definition defn) {
        Import imp = BPELFactory.eINSTANCE.createImport();
        String t = defn.getTargetNamespace();
        if (t != null) {
            imp.setNamespace(t);
        }
        Resource resource = this.fProcess.eResource();
        URI schemaURI = null;
        if (defn.getLocation() == null) {
            if (this.fResourceInfo != null) {
                imp.setLocation(this.fResourceInfo.getFile().toString());
            }
        } else {
            schemaURI = URI.createURI((String)defn.getLocation());
            imp.setLocation(schemaURI.deresolve(resource.getURI(), true, true, true).toString());
        }
        imp.setImportType("http://schemas.xmlsoap.org/wsdl/");
        return imp;
    }
}

