/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import org.eclipse.bpel.model.messageproperties.MessagepropertiesFactory;
import org.eclipse.bpel.model.messageproperties.MessagepropertiesPackage;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.messageproperties.PropertyAlias;
import org.eclipse.bpel.model.messageproperties.Query;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.properties.ExpressionSection;
import org.eclipse.bpel.ui.util.BrowseUtil;
import org.eclipse.bpel.ui.util.WSDLImportHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;

public class EditPropertyAliasDialog
extends Dialog {
    protected static final int BID_USE_TYPE = 1054;
    protected static final int BID_USE_ELEMENT = 1055;
    protected static final int BID_USE_MESSAGE = 1056;
    protected boolean isNew;
    protected BPELEditor bpelEditor;
    protected Property property;
    protected PropertyAlias alias;
    protected EObject activeTypeElementOrMessage;
    protected Query activeQuery;
    protected XSDTypeDefinition xsdTypeDefinition;
    protected Query xsdTypeQuery;
    protected XSDElementDeclaration xsdElementDeclaration;
    protected Query xsdElementQuery;
    protected Message message;
    protected String messagePart;
    protected Query messageQuery;
    protected Label typeElementOrMessageNameLabel;
    protected Label typeElementOrMessageNameText;
    private Button typeRadio;
    private Button elementRadio;
    private Button messageRadio;
    private int typeElementOrMessage;
    private QueryEditor queryEditor;
    protected Button browseTypeButton;
    protected TabbedPropertySheetWidgetFactory wf;

    public EditPropertyAliasDialog(Shell parentShell, Property property, PropertyAlias alias, BPELEditor bpelEditor, TabbedPropertySheetWidgetFactory wf) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.isNew = alias == null;
        this.alias = alias;
        this.property = property;
        this.bpelEditor = bpelEditor;
        this.wf = wf;
        if (this.isNew) {
            this.typeElementOrMessage = 1056;
            this.alias = MessagepropertiesFactory.eINSTANCE.createPropertyAlias();
        } else if (alias.getMessageType() != null) {
            this.typeElementOrMessage = 1056;
            this.message = (Message)alias.getMessageType();
            this.messagePart = alias.getPart();
            this.messageQuery = alias.getQuery();
        } else if (alias.getType() != null) {
            this.typeElementOrMessage = 1054;
            this.xsdTypeDefinition = (XSDTypeDefinition)alias.getType();
            this.xsdTypeQuery = alias.getQuery();
        } else if (alias.getXSDElement() != null) {
            this.typeElementOrMessage = 1055;
            this.xsdElementDeclaration = (XSDElementDeclaration)alias.getXSDElement();
            this.xsdElementQuery = alias.getQuery();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        Listener enablementListener = new Listener(){

            public void handleEvent(Event e) {
                EditPropertyAliasDialog.this.updateEnablement();
            }
        };
        String groupText = Messages.EditMessagePropertyDialog_10;
        Group typeElementOrMessageRadioGroup = new Group(composite, 16);
        typeElementOrMessageRadioGroup.setText(groupText);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        typeElementOrMessageRadioGroup.setLayout((Layout)layout);
        this.messageRadio = this.createRadioButton((Composite)typeElementOrMessageRadioGroup, Messages.EditMessagePropertyDialog_13, 1056, this.typeElementOrMessage == 1056);
        this.typeRadio = this.createRadioButton((Composite)typeElementOrMessageRadioGroup, Messages.EditMessagePropertyDialog_11, 1054, this.typeElementOrMessage == 1054);
        this.elementRadio = this.createRadioButton((Composite)typeElementOrMessageRadioGroup, Messages.EditMessagePropertyDialog_12, 1055, this.typeElementOrMessage == 1055);
        this.messageRadio.addListener(13, enablementListener);
        this.typeRadio.addListener(13, enablementListener);
        this.elementRadio.addListener(13, enablementListener);
        this.typeElementOrMessageNameLabel = new Label(composite, 0);
        this.typeElementOrMessageNameText = new Label(composite, 0);
        this.browseTypeButton = new Button(composite, 8);
        this.browseTypeButton.setText(Messages.EditMessagePropertyDialog_18);
        this.browseTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditPropertyAliasDialog.this.browsePropertyType();
            }
        });
        this.queryEditor = new QueryEditor();
        Group queryGroup = new Group(composite, 16);
        queryGroup.setText("Query");
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        queryGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        queryGroup.setLayoutData((Object)data);
        this.queryEditor.create((Composite)queryGroup);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        typeElementOrMessageRadioGroup.setLayoutData((Object)data);
        data = new GridData(768);
        this.messageRadio.setLayoutData((Object)data);
        data = new GridData(768);
        this.typeRadio.setLayoutData((Object)data);
        data = new GridData(768);
        this.elementRadio.setLayoutData((Object)data);
        data = new GridData(32);
        this.typeElementOrMessageNameLabel.setLayoutData((Object)data);
        data = new GridData(800);
        this.typeElementOrMessageNameText.setLayoutData((Object)data);
        data = new GridData(128);
        this.browseTypeButton.setLayoutData((Object)data);
        this.updateWidgets();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.property_alias_dialog");
        composite.pack();
        return composite;
    }

    protected Button createRadioButton(Composite parent, String label, int id, boolean checked) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                int val = (Integer)b.getData();
                EditPropertyAliasDialog.this.buttonPressed(val, b.getSelection(), true);
            }
        });
        return button;
    }

    protected void buttonPressed(int id, boolean checked, boolean bRefresh) {
        switch (id) {
            case 1054: 
            case 1055: 
            case 1056: {
                if (!checked) {
                    return;
                }
                this.typeElementOrMessage = id;
                break;
            }
        }
        if (bRefresh) {
            this.updateWidgets();
        }
    }

    protected void updateWidgets() {
        String s = this.queryEditor.getQuery();
        if (s != null && this.activeQuery != null) {
            this.activeQuery.setValue(s);
            this.activeQuery.setQueryLanguage(this.queryEditor.getQueryLanguage());
        }
        if (this.typeElementOrMessage == 1054) {
            this.typeRadio.setSelection(true);
            this.elementRadio.setSelection(false);
            this.messageRadio.setSelection(false);
            this.activeTypeElementOrMessage = this.xsdTypeDefinition;
            if (this.xsdTypeQuery == null) {
                this.xsdTypeQuery = MessagepropertiesFactory.eINSTANCE.createQuery();
            }
            this.activeQuery = this.xsdTypeQuery;
            this.typeElementOrMessageNameLabel.setText(Messages.EditMessagePropertyDialog_Type_1);
            this.alias.setMessageType(null);
            this.alias.setPart(null);
            this.alias.setType((Object)this.xsdTypeDefinition);
            this.alias.setXSDElement(null);
        } else if (this.typeElementOrMessage == 1055) {
            this.typeRadio.setSelection(false);
            this.elementRadio.setSelection(true);
            this.messageRadio.setSelection(false);
            this.activeTypeElementOrMessage = this.xsdElementDeclaration;
            if (this.xsdElementQuery == null) {
                this.xsdElementQuery = MessagepropertiesFactory.eINSTANCE.createQuery();
            }
            this.activeQuery = this.xsdElementQuery;
            this.typeElementOrMessageNameLabel.setText(Messages.EditMessagePropertyDialog_Element_1);
            this.alias.setMessageType(null);
            this.alias.setPart(null);
            this.alias.setType(null);
            this.alias.setXSDElement((Object)this.xsdElementDeclaration);
        } else if (this.typeElementOrMessage == 1056) {
            this.typeRadio.setSelection(false);
            this.elementRadio.setSelection(false);
            this.messageRadio.setSelection(true);
            this.activeTypeElementOrMessage = this.message;
            if (this.messageQuery == null) {
                this.messageQuery = MessagepropertiesFactory.eINSTANCE.createQuery();
            }
            this.activeQuery = this.messageQuery;
            this.typeElementOrMessageNameLabel.setText(Messages.EditMessagePropertyDialog_Message_1);
            this.alias.setMessageType((Object)this.message);
            this.alias.setPart(this.messagePart);
            this.alias.setType(null);
            this.alias.setXSDElement(null);
        }
        this.alias.setQuery(this.activeQuery);
        this.queryEditor.setInput((EObject)this.alias);
        this.updateTypeElementOrMessageName();
        this.updateEnablement();
    }

    protected void updateTypeElementOrMessageName() {
        if (this.activeTypeElementOrMessage instanceof XSDTypeDefinition) {
            this.xsdTypeDefinition = (XSDTypeDefinition)this.activeTypeElementOrMessage;
            this.xsdTypeQuery = this.activeQuery;
            this.typeElementOrMessageNameText.setText(this.xsdTypeDefinition.getName());
        } else if (this.activeTypeElementOrMessage instanceof XSDElementDeclaration) {
            this.xsdElementDeclaration = (XSDElementDeclaration)this.activeTypeElementOrMessage;
            this.xsdElementQuery = this.activeQuery;
            this.typeElementOrMessageNameText.setText(this.xsdElementDeclaration.getName());
        } else if (this.activeTypeElementOrMessage instanceof Message) {
            this.message = (Message)this.activeTypeElementOrMessage;
            String s = this.message.getQName().getLocalPart();
            this.messageQuery = this.activeQuery;
            if (this.messagePart != null) {
                s = String.valueOf(s) + "." + this.messagePart;
            }
            this.typeElementOrMessageNameText.setText(s);
        } else {
            this.typeElementOrMessageNameText.setText("");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isNew) {
            newShell.setText(Messages.EditPropertyAliasDialog_9);
        } else {
            newShell.setText(Messages.EditPropertyAliasDialog_10);
        }
    }

    protected void browsePropertyType() {
        Object type = null;
        Object part = null;
        Object query = null;
        Object[] result = null;
        result = this.typeElementOrMessage == 1054 ? BrowseUtil.browseForXSDType((EObject)this.bpelEditor.getProcess(), this.getShell()) : (this.typeElementOrMessage == 1055 ? BrowseUtil.browseForXSDElement((EObject)this.bpelEditor.getProcess(), this.getShell(), true) : BrowseUtil.browseForMessageType((EObject)this.bpelEditor.getProcess(), this.getShell(), true));
        if (result != null) {
            if (result.length >= 1) {
                Definition definition;
                type = result[0];
                int index = 1;
                if (type instanceof Message) {
                    this.message = (Message)type;
                    if (result.length >= 2 && result[1] instanceof Part) {
                        part = ((Part)result[1]).getName();
                        index = 2;
                    }
                }
                if ((definition = this.property.getEnclosingDefinition()) == null) {
                    IFile targetFile = this.bpelEditor.getEditModelClient().getArtifactsResourceInfo().getFile();
                    URI uri = URI.createPlatformResourceURI((String)targetFile.getFullPath().toString());
                    Resource resource = this.bpelEditor.getResourceSet().getResource(uri, true);
                    definition = (Definition)resource.getContents().get(0);
                }
                query = "";
                while (index < result.length) {
                    if (result[index] instanceof XSDComponent) {
                        XSDNamedComponent nc = (XSDNamedComponent)result[index];
                        WSDLImportHelper.addImportAndNamespace(definition, nc.getSchema(), (IResource)this.bpelEditor.getEditModelClient().getPrimaryResourceInfo().getFile());
                        String prefix = definition.getPrefix(nc.getTargetNamespace());
                        query = prefix != null ? query + "/" + prefix + ":" + nc.getName() : query + "/" + nc.getName();
                    }
                    ++index;
                }
            }
            this.activeTypeElementOrMessage = (EObject)type;
            if (query != null) {
                this.activeQuery.setValue(query.toString());
            } else {
                this.activeQuery.setValue("");
            }
            if (this.typeElementOrMessage == 1054) {
                this.xsdTypeDefinition = (XSDTypeDefinition)type;
                this.xsdTypeQuery = this.activeQuery;
            } else if (this.typeElementOrMessage == 1055) {
                this.xsdElementDeclaration = (XSDElementDeclaration)type;
                this.xsdElementQuery = this.activeQuery;
            } else {
                this.message = (Message)type;
                if (part != null) {
                    this.messagePart = part.toString();
                }
                this.messageQuery = this.activeQuery;
            }
            this.activeQuery = null;
            this.updateWidgets();
        }
    }

    public PropertyAlias getPropertyAlias() {
        return this.alias;
    }

    protected void okPressed() {
        this.alias.setPropertyName((Object)this.property);
        if (this.typeElementOrMessage == 1054) {
            this.alias.setType((Object)this.xsdTypeDefinition);
            if (this.xsdTypeQuery != null && (this.xsdTypeQuery.getValue() == null || this.xsdTypeQuery.getValue().trim().equals(""))) {
                this.xsdTypeQuery = null;
            }
            this.alias.setQuery(this.xsdTypeQuery);
        } else if (this.typeElementOrMessage == 1055) {
            this.alias.setXSDElement((Object)this.xsdElementDeclaration);
            if (this.xsdElementQuery != null && (this.xsdElementQuery.getValue() == null || this.xsdElementQuery.getValue().trim().equals(""))) {
                this.xsdElementQuery = null;
            }
            this.alias.setQuery(this.xsdElementQuery);
        } else {
            this.alias.setMessageType((Object)this.message);
            this.alias.setPart(this.messagePart);
            if (this.messageQuery != null && (this.messageQuery.getValue() == null || this.messageQuery.getValue().trim().equals(""))) {
                this.messageQuery = null;
            }
            this.alias.setQuery(this.messageQuery);
        }
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.updateEnablement();
        return result;
    }

    protected void updateEnablement() {
        boolean isOK = true;
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(isOK);
        }
    }

    public class QueryEditor
    extends ExpressionSection {
        public void create(Composite parent) {
            this.createControls(parent, null);
        }

        public void setInput(EObject obj) {
            this.basicSetInput(obj);
        }

        public String getQuery() {
            if (this.getExpressionEditor() != null) {
                return this.getExpressionEditor().getEditorContent();
            }
            return null;
        }

        public String getQueryLanguage() {
            Object elm = this.selectedExpressionLanguage();
            if (elm == NO_EXPRESSION || elm == null) {
                return null;
            }
            return this.getExpressionLanguage(elm);
        }

        @Override
        protected String getExpressionType() {
            return "any";
        }

        @Override
        public BPELEditor getBPELEditor() {
            return EditPropertyAliasDialog.this.bpelEditor;
        }

        @Override
        public TabbedPropertySheetWidgetFactory getWidgetFactory() {
            return EditPropertyAliasDialog.this.wf;
        }

        @Override
        protected EStructuralFeature getStructuralFeature() {
            this.fStructuralFeature = MessagepropertiesPackage.eINSTANCE.getPropertyAlias_Query();
            return this.fStructuralFeature;
        }

        @Override
        protected void setStructuralFeature(EStructuralFeature feature) {
            this.fStructuralFeature = feature;
        }

        @Override
        protected EStructuralFeature getStructuralFeature(EObject eObject) {
            if (eObject != null) {
                return MessagepropertiesPackage.eINSTANCE.getPropertyAlias_Query();
            }
            return null;
        }

        @Override
        protected Command wrapInShowContextCommand(Command inner) {
            EditPropertyAliasDialog.this.updateWidgets();
            return null;
        }
    }
}

