/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import javax.wsdl.Import;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.messageproperties.PropertyAlias;
import org.eclipse.bpel.model.messageproperties.Query;
import org.eclipse.bpel.model.messageproperties.util.MessagepropertiesConstants;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.partnerlinktype.util.PartnerlinktypeConstants;
import org.eclipse.bpel.ui.details.providers.XSDTypeOrElementContentProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class WSDLImportHelper {
    static final String WSDL_PREFIX_KIND = "wsdl";
    static final String XSD_PREFIX_KIND = "xsd";

    public static void addAllImportsAndNamespaces(Definition definition, IResource contextObject) {
        String TNS = definition.getTargetNamespace();
        if (TNS == null) {
            TNS = definition.getNamespace("tns");
            if (TNS == null) {
                throw new IllegalStateException();
            }
            definition.setTargetNamespace(TNS);
        } else {
            definition.addNamespace("tns", TNS);
        }
        WSDLImportHelper.addToolingNamespaces(definition);
        for (ExtensibilityElement ee : definition.getEExtensibilityElements()) {
            Message msg;
            if (ee instanceof PartnerLinkType) {
                for (Role role : ((PartnerLinkType)ee).getRole()) {
                    PortType pt;
                    if (role.getPortType() == null || (pt = (PortType)role.getPortType()) == null || pt.getQName() == null) continue;
                    WSDLImportHelper.addImportAndNamespace(definition, pt.getEnclosingDefinition());
                }
            }
            if (ee instanceof PropertyAlias && (msg = (Message)((PropertyAlias)ee).getMessageType()) != null && msg.getQName() != null) {
                WSDLImportHelper.addImportAndNamespace(definition, msg.getEnclosingDefinition());
                Query q = ((PropertyAlias)ee).getQuery();
                if (q != null && q.getValue() != null && !"".equals(q.getValue())) {
                    Types types;
                    String query = ((PropertyAlias)ee).getQuery().getValue();
                    String[] queryArr = query.split("/");
                    LinkedList<String> prefixList = new LinkedList<String>();
                    String[] stringArray = queryArr;
                    int n = queryArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String qname = stringArray[n2];
                        String[] strs = qname.split(":");
                        if (strs.length > 1) {
                            prefixList.add(strs[0]);
                        }
                        ++n2;
                    }
                    if (prefixList.size() > 0 && (types = (Types)msg.getEnclosingDefinition().getTypes()) != null && types.getSchemas() != null) {
                        XSDSchema xsd = null;
                        int i = 0;
                        while (i < types.getSchemas().size()) {
                            xsd = (XSDSchema)types.getSchemas().get(i);
                            Map map = xsd.getQNamePrefixToNamespaceMap();
                            if (map != null) {
                                Object[] objectArray = map.keySet().toArray();
                                int n3 = objectArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Object obj = objectArray[n4];
                                    if (prefixList.contains((String)obj)) {
                                        definition.addNamespace((String)obj, (String)map.get((String)obj));
                                    }
                                    ++n4;
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
            if (!(ee instanceof Property)) continue;
            Object xsdType = ((Property)ee).getType();
            if (xsdType instanceof XSDTypeDefinition) {
                XSDTypeDefinition td = (XSDTypeDefinition)xsdType;
                if (td.eResource() != null && !XSDTypeOrElementContentProvider.isBuiltInType(td)) {
                    WSDLImportHelper.addImportAndNamespace(definition, td.getSchema(), contextObject);
                    continue;
                }
                WSDLImportHelper.addNamespace(definition, td.getTargetNamespace(), XSD_PREFIX_KIND);
                continue;
            }
            if (!(xsdType instanceof XSDElementDeclaration)) continue;
            XSDElementDeclaration ed = (XSDElementDeclaration)xsdType;
            if (ed.eResource() != null) {
                WSDLImportHelper.addImportAndNamespace(definition, ed.getSchema(), contextObject);
                continue;
            }
            WSDLImportHelper.addNamespace(definition, ed.getTargetNamespace(), XSD_PREFIX_KIND);
        }
    }

    protected static void addToolingNamespaces(Definition definition) {
        WSDLImportHelper.addNamespace(definition, PartnerlinktypeConstants.NAMESPACE, "plnk");
        WSDLImportHelper.addNamespace(definition, MessagepropertiesConstants.NAMESPACE, "vprop");
    }

    public static void addImportAndNamespace(Definition definition, XSDSchema importedSchema, IResource contextObject) {
        String namespace = importedSchema.getTargetNamespace();
        if (namespace == null) {
            return;
        }
        WSDLImportHelper.addNamespace(definition, namespace, XSD_PREFIX_KIND);
        WSDLImportHelper.addImport(namespace, definition, definition.eResource().getURI(), importedSchema, importedSchema.eResource().getURI(), contextObject);
    }

    public static void addImportAndNamespace(Definition definition, Definition importedDefinition) {
        if (importedDefinition == null || definition == null) {
            return;
        }
        if (definition == importedDefinition) {
            return;
        }
        String namespace = importedDefinition.getTargetNamespace();
        if (namespace == null) {
            return;
        }
        WSDLImportHelper.addNamespace(definition, namespace, WSDL_PREFIX_KIND);
        WSDLImportHelper.addImport(namespace, definition, definition.eResource().getURI(), importedDefinition, importedDefinition.eResource().getURI());
    }

    protected static void addNamespace(Definition definition, String namespace, String pfxRoot) {
        String prefix = definition.getPrefix(namespace);
        if (prefix != null) {
            return;
        }
        prefix = pfxRoot;
        int idx = 1;
        while (true) {
            if (definition.getNamespace(prefix) == null) break;
            prefix = String.valueOf(pfxRoot) + idx;
            ++idx;
        }
        definition.addNamespace(prefix, namespace);
    }

    protected static void addImport(String namespace, Definition importingDefinition, URI importingUri, Definition importedDefinition, URI importedUri) {
        org.eclipse.wst.wsdl.Import _import;
        WSDLFactory wsdlFactory = WSDLPackage.eINSTANCE.getWSDLFactory();
        ArrayList imports = importingDefinition.getImports(namespace);
        if (imports == null) {
            imports = new ArrayList();
        }
        boolean found = false;
        int i = 0;
        while (i < imports.size() && !found) {
            _import = (org.eclipse.wst.wsdl.Import)imports.get(i);
            if (_import.getEDefinition() == importedDefinition) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            String locationURI = WSDLImportHelper.createBuildPathRelativeReference(importingUri, importedUri);
            if (locationURI != null && locationURI.length() != 0) {
                _import = wsdlFactory.createImport();
                _import.setEDefinition(importedDefinition);
                _import.setLocationURI(locationURI);
                _import.setNamespaceURI(namespace);
                importingDefinition.addImport((Import)_import);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    protected static void addImport(String namespace, Definition importingDefinition, URI importingUri, XSDSchema importedSchema, URI importedUri, IResource contextObject) {
        WSDLFactory wsdlFactory = WSDLPackage.eINSTANCE.getWSDLFactory();
        ArrayList imports = importingDefinition.getImports(namespace);
        if (imports == null) {
            imports = new ArrayList();
        }
        boolean found = false;
        int i = 0;
        while (i < imports.size() && !found) {
            org.eclipse.wst.wsdl.Import _import = (org.eclipse.wst.wsdl.Import)imports.get(i);
            if (_import.getESchema() == importedSchema) {
                found = true;
            }
            ++i;
        }
        if (found) {
            return;
        }
        URI locationURI = importedUri.deresolve(importingUri, true, true, false);
        if (!"bundleentry".equals(locationURI.scheme())) {
            String locationString = WSDLImportHelper.createBuildPathRelativeReference(importingUri, importedUri);
            if (locationString != null && locationString.length() != 0) {
                org.eclipse.wst.wsdl.Import _import = wsdlFactory.createImport();
                _import.setESchema(importedSchema);
                _import.setLocationURI(locationString);
                _import.setNamespaceURI(namespace);
                importingDefinition.addImport((Import)_import);
            } else if (!importingUri.equals((Object)importedUri)) {
                throw new IllegalStateException();
            }
        }
    }

    public static String createBuildPathRelativeReference(URI sourceURI, URI targetURI) {
        if (sourceURI == null || targetURI == null) {
            throw new IllegalArgumentException();
        }
        String result = targetURI.deresolve(sourceURI, true, true, true).toFileString();
        try {
            File f;
            if (result != null && (f = new File(result)).exists()) {
                result = f.toURI().toString();
            }
        }
        catch (Exception exception) {}
        return result == null ? targetURI.toString() : result;
    }

    public static Definition getDefinition(org.eclipse.bpel.model.Import bpelImport) {
        Resource baseResource = bpelImport.eResource();
        String location = bpelImport.getLocation();
        if (!baseResource.getURI().isRelative()) {
            location = URI.createURI((String)location).resolve(baseResource.getURI()).toString();
        }
        URI locationURI = URI.createURI((String)location);
        ResourceSet resourceSet = baseResource.getResourceSet();
        Resource resource = resourceSet.getResource(locationURI, true);
        return resource instanceof WSDLResourceImpl ? ((WSDLResourceImpl)resource).getDefinition() : null;
    }
}

