/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.composite.EditorInViewManager;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.expressions.IExpressionEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractExpressionEditor
implements IExpressionEditor {
    protected List<IExpressionEditor.Listener> listeners = new ArrayList<IExpressionEditor.Listener>();
    protected EditorInViewManager fManager;
    private Object fModelObject;
    protected FormToolkit wf;
    private String fExprType;

    @Override
    public void createControls(Composite parent, FormToolkit toolkit) {
        this.wf = toolkit;
    }

    @Override
    public void addListener(IExpressionEditor.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IExpressionEditor.Listener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyChanged() {
        for (IExpressionEditor.Listener next : this.listeners) {
            next.notifyChanged();
        }
    }

    protected void notifyFocusOut() {
        for (IExpressionEditor.Listener next : this.listeners) {
            next.focusOut();
        }
    }

    @Override
    public abstract String getEditorContent();

    @Override
    public abstract void setEditorContent(String var1);

    protected void refresh() {
    }

    @Override
    public void addExtraStoreCommands(CompoundCommand compoundCommand) {
    }

    protected IEditorPart createEditor(String editorID, IEditorInput input, Composite parent) {
        try {
            return this.getEditorManager().createEditor(editorID, input, parent);
        }
        catch (CoreException e) {
            BPELUIPlugin.log(e);
            return null;
        }
    }

    protected EditorInViewManager getEditorManager() {
        if (this.fManager == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            IViewPart view = page.findView("org.eclipse.ui.views.PropertySheet");
            try {
                if (view == null) {
                    view = page.showView("org.eclipse.ui.views.PropertySheet");
                }
                this.fManager = new EditorInViewManager(view.getViewSite());
            }
            catch (PartInitException e) {
                BPELUIPlugin.log(e);
            }
        }
        return this.fManager;
    }

    @Override
    public void setExpressionType(String exprType) {
        this.fExprType = exprType;
    }

    @Override
    public void setModelObject(Object modelObject) {
        this.fModelObject = modelObject;
    }

    protected String getExprType() {
        return this.fExprType;
    }

    protected Object getModelObject() {
        return this.fModelObject;
    }
}

