/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.DelegateIValue;
import org.eclipse.bpel.common.ui.details.FocusContext;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.ViewerIValue;
import org.eclipse.bpel.common.ui.details.viewers.ComboViewer;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.details.providers.ExpressionEditorDescriptorContentProvider;
import org.eclipse.bpel.ui.details.providers.ExpressionEditorDescriptorLabelProvider;
import org.eclipse.bpel.ui.details.providers.ModelViewerSorter;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.extensions.ExpressionEditorDescriptor;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class AttributesSection
extends BPELPropertySection {
    protected Combo fExpressionLanguageCombo;
    protected Combo fQueryLanguageCombo;
    protected ComboViewer fExpressionLanguageViewer;
    protected ComboViewer fQueryLanguageViewer;
    protected EditController fExpressionLanguageController;
    protected EditController fQueryLanguageController;
    protected IValue fContext;

    @Override
    protected void basicSetInput(EObject input) {
        this.saveUserContextToInput();
        super.basicSetInput(input);
        this.restoreUserContextFromInput();
        this.fQueryLanguageController.setInput(input);
        this.fExpressionLanguageController.setInput(input);
    }

    protected void createChangeTrackers() {
        this.fExpressionLanguageController = this.createEditController();
        this.fExpressionLanguageController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getProcess_ExpressionLanguage());
        this.fExpressionLanguageController.setViewIValue((IValue)new ViewerIValue((StructuredViewer)this.fExpressionLanguageViewer));
        this.fExpressionLanguageController.setModeIValue((IValue)new ExpressionEditorDescriptorIValue(this.fExpressionLanguageController.getModelIValue()));
        this.fExpressionLanguageController.startListeningTo(new Control[]{this.fExpressionLanguageCombo});
        this.fQueryLanguageController = this.createEditController();
        this.fQueryLanguageController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getProcess_QueryLanguage());
        this.fQueryLanguageController.setViewIValue((IValue)new ViewerIValue((StructuredViewer)this.fQueryLanguageViewer));
        this.fQueryLanguageController.setModeIValue((IValue)new ExpressionEditorDescriptorIValue(this.fQueryLanguageController.getModelIValue()));
        this.fQueryLanguageController.startListeningTo(new Control[]{this.fQueryLanguageCombo});
    }

    protected void createAttributesWidgets(Composite composite) {
        Label expressionLanguageLabel = this.fWidgetFactory.createLabel(composite, Messages.AttributesDetails_Expression_Language__2);
        this.fExpressionLanguageCombo = new Combo(composite, 0x800008);
        this.fWidgetFactory.adapt((Composite)this.fExpressionLanguageCombo);
        this.fExpressionLanguageCombo.setData("name", (Object)"expressionLanguage");
        this.fExpressionLanguageViewer = new ComboViewer(this.fExpressionLanguageCombo);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)expressionLanguageLabel, 157));
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment(0, 4);
        this.fExpressionLanguageCombo.setLayoutData((Object)data);
        this.fExpressionLanguageViewer.setContentProvider((IContentProvider)new ExpressionEditorDescriptorContentProvider());
        this.fExpressionLanguageViewer.setLabelProvider((IBaseLabelProvider)new ExpressionEditorDescriptorLabelProvider());
        this.fExpressionLanguageViewer.setSorter((ViewerSorter)ModelViewerSorter.getInstance());
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.fExpressionLanguageCombo, -5);
        data.top = new FlatFormAttachment((Control)this.fExpressionLanguageCombo, 0, 0x1000000);
        expressionLanguageLabel.setLayoutData((Object)data);
        this.fExpressionLanguageViewer.setInput(new Object());
        Label queryLanguageLabel = this.fWidgetFactory.createLabel(composite, Messages.AttributesDetails_Query_Language__2);
        this.fQueryLanguageCombo = new Combo(composite, 0x800008);
        this.fWidgetFactory.adapt((Composite)this.fQueryLanguageCombo);
        this.fQueryLanguageCombo.setData("name", (Object)"queryLanguage");
        this.fQueryLanguageViewer = new ComboViewer(this.fQueryLanguageCombo);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)queryLanguageLabel, 157));
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment((Control)this.fExpressionLanguageCombo, 4);
        this.fQueryLanguageCombo.setLayoutData((Object)data);
        this.fQueryLanguageViewer.setLabelProvider((IBaseLabelProvider)new ExpressionEditorDescriptorLabelProvider());
        this.fQueryLanguageViewer.setContentProvider((IContentProvider)new ExpressionEditorDescriptorContentProvider());
        this.fQueryLanguageViewer.setSorter((ViewerSorter)ModelViewerSorter.getInstance());
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.fQueryLanguageCombo, -5);
        data.top = new FlatFormAttachment((Control)this.fQueryLanguageCombo, 0, 0x1000000);
        queryLanguageLabel.setLayoutData((Object)data);
        this.fQueryLanguageViewer.setInput(new Object());
        this.fContext = new FocusContext(new Control[]{this.fExpressionLanguageCombo, this.fQueryLanguageCombo});
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createAttributesWidgets(composite);
        this.createChangeTrackers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_attributes");
    }

    @Override
    public Object getUserContext() {
        return this.fContext.get();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fContext.set(userContext);
    }

    class ExpressionEditorDescriptorIValue
    extends DelegateIValue {
        ExpressionEditorDescriptorIValue(IValue arg) {
            super(arg);
        }

        public Object get() {
            String result = (String)this.fDelegate.get();
            return result != null ? BPELUIRegistry.getInstance().getExpressionEditorDescriptor(result) : null;
        }

        public void set(Object object) {
            ExpressionEditorDescriptor eed = (ExpressionEditorDescriptor)object;
            this.fDelegate.set((Object)(eed != null ? eed.getExpressionLanguage() : null));
        }
    }
}

