/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.ui.expressions.IExpressionEditor;
import org.eclipse.bpel.ui.properties.ExpressionSection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class RadioChoiceExpressionSection
extends ExpressionSection {
    protected Composite radioComposite;
    protected Button[] radioButtons;
    protected int fButtonCount;
    protected int fCurrentButtonIndex;

    @Override
    protected String getExpressionType() {
        return this.getButtonExprType(this.fCurrentButtonIndex);
    }

    protected abstract String[] getButtonLabels();

    protected abstract String getButtonExprType(int var1);

    protected abstract int getButtonIndexFromModel();

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.fCurrentButtonIndex = this.getButtonIndexFromModel();
        this.updateWidgets();
    }

    protected void calculateEnablement() {
        IExpressionEditor exEditor = this.getExpressionEditor();
        if (exEditor == null) {
            throw new IllegalStateException();
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            String btnType = this.getButtonExprType(i);
            boolean enabled = this.fEditor.supportsExpressionType(btnType);
            this.radioButtons[i].setEnabled(enabled);
            ++i;
        }
    }

    protected void updateRadioButtonWidgets() {
        if (!this.hasEditor()) {
            this.radioComposite.setVisible(false);
        } else {
            this.radioComposite.setVisible(true);
            FlatFormData data = (FlatFormData)this.fEditorArea.getLayoutData();
            data.top = new FlatFormAttachment((Control)this.radioComposite, 4);
            this.calculateEnablement();
            this.fCurrentButtonIndex = this.getButtonIndexFromModel();
            if (this.fCurrentButtonIndex >= 0) {
                this.radioButtons[this.fCurrentButtonIndex].setSelection(true);
            }
            int i = 0;
            while (i < this.radioButtons.length) {
                if (i != this.fCurrentButtonIndex) {
                    this.radioButtons[i].setSelection(false);
                }
                ++i;
            }
        }
        this.fParentComposite.layout(true);
    }

    @Override
    protected void updateWidgets() {
        super.updateWidgets();
        this.updateRadioButtonWidgets();
    }

    protected void createRadioButtonWidgets(Composite parent) {
        FlatFormData data;
        String[] labels = this.getButtonLabels();
        this.fButtonCount = labels.length;
        this.radioComposite = this.createFlatFormComposite(parent);
        this.radioButtons = new Button[this.fButtonCount];
        FlatFormAttachment lastLeft = new FlatFormAttachment(0, 157);
        int i = 0;
        while (i < this.fButtonCount) {
            this.radioButtons[i] = this.fWidgetFactory.createButton(this.radioComposite, labels[i], 16);
            data = new FlatFormData();
            data.left = lastLeft;
            data.top = new FlatFormAttachment(0, 0);
            this.radioButtons[i].setLayoutData((Object)data);
            lastLeft = new FlatFormAttachment((Control)this.radioButtons[i], 5);
            final int index = i;
            this.radioButtons[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RadioChoiceExpressionSection.this.radioButtonSelected(index, RadioChoiceExpressionSection.this.radioButtons[index]);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(this.expressionLanguageViewer.getControl(), 6);
        this.radioComposite.setLayoutData((Object)data);
    }

    protected abstract void radioButtonSelected(int var1, Button var2);

    @Override
    protected void createClient(Composite parent) {
        super.createClient(parent);
        this.createRadioButtonWidgets(this.fParentComposite);
    }

    protected boolean showRadioButtons() {
        return this.hasEditor();
    }

    @Override
    protected boolean isEditorSupported(IExpressionEditor exEditor) {
        int i = 0;
        while (i < this.fButtonCount) {
            String btnType = this.getButtonExprType(i);
            if (exEditor.supportsExpressionType(btnType)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

