/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.properties.RadioChoiceExpressionSection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class WaitConditionSection
extends RadioChoiceExpressionSection {
    static final String[] gLabels = new String[]{Messages.WaitConditionSection_Date_1, Messages.WaitConditionSection_Duration_2};
    static Map<EClass, EStructuralFeature[]> CLASS2FEATURES = new HashMap<EClass, EStructuralFeature[]>();

    static {
        CLASS2FEATURES.put(BPELPackage.eINSTANCE.getWait(), new EStructuralFeature[]{BPELPackage.eINSTANCE.getWait_Until(), BPELPackage.eINSTANCE.getWait_For()});
        CLASS2FEATURES.put(BPELPackage.eINSTANCE.getOnAlarm(), new EStructuralFeature[]{BPELPackage.eINSTANCE.getOnAlarm_Until(), BPELPackage.eINSTANCE.getOnAlarm_For()});
    }

    @Override
    protected Composite createNoEditorWidgets(Composite composite) {
        return this.createNoEditorWidgetsCreateComposite(composite, String.valueOf(Messages.WaitConditionSection_No_condition_specified_1) + "\n" + "\n" + Messages.WaitConditionSection_Create_condition_text_2, Messages.WaitConditionSection_Create_a_New_Condition_2);
    }

    @Override
    protected String[] getButtonLabels() {
        return gLabels;
    }

    @Override
    protected String getButtonExprType(int buttonIndex) {
        if (buttonIndex == 0) {
            return "deadline";
        }
        if (buttonIndex == 1) {
            return "duration";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void radioButtonSelected(int index, Button button) {
        if (!button.getSelection()) {
            return;
        }
        this.fCurrentButtonIndex = index;
        this.runCommand(this.newStoreToModelCommand(this.getDefaultBody(this.editorLanguage, this.getButtonExprType(index))));
    }

    @Override
    protected Expression getExprFromModel() {
        Object input = this.getInput();
        EStructuralFeature feature = this.getStructuralFeature((EObject)input);
        if (feature == null) {
            return null;
        }
        Object result = input.eGet(feature);
        if (result != null && result instanceof Expression) {
            return (Expression)result;
        }
        return null;
    }

    @Override
    protected int getButtonIndexFromModel() {
        Object input = this.getInput();
        EStructuralFeature feature = this.getStructuralFeature((EObject)input);
        if (feature == null) {
            return 1;
        }
        if (feature.getName().indexOf("until") >= 0) {
            return 0;
        }
        return 1;
    }

    @Override
    protected boolean isValidClientUseType(String useType) {
        return "deadlineCondition".equals(useType) || "durationCondition".equals(useType);
    }

    @Override
    protected void createClient(Composite parent) {
        super.createClient(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fParentComposite, "org.eclipse.bpel.ui.property_wait");
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        return false;
    }

    @Override
    protected EStructuralFeature getStructuralFeature() {
        return this.getStructuralFeature(this.fCurrentButtonIndex);
    }

    protected EStructuralFeature getStructuralFeature(int index) {
        EStructuralFeature[] features = CLASS2FEATURES.get(this.getInput().eClass());
        assert (features != null) : "Features cannot be null";
        return features[index];
    }

    @Override
    protected EStructuralFeature getStructuralFeature(EObject eObj) {
        EStructuralFeature[] features;
        EStructuralFeature[] eStructuralFeatureArray = features = CLASS2FEATURES.get(eObj.eClass());
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature f = eStructuralFeatureArray[n2];
            Object result = eObj.eGet(f);
            if (result != null) {
                return f;
            }
            ++n2;
        }
        return super.getStructuralFeature(eObj);
    }

    @Override
    protected Command newStoreToModelCommand(Object body) {
        CompoundCommand result = new CompoundCommand();
        Expression oldExp = this.getExprFromModel();
        Expression exp = BPELFactory.eINSTANCE.createExpression();
        if (oldExp != null) {
            exp.setExpressionLanguage(oldExp.getExpressionLanguage());
        }
        exp.setBody(body);
        EStructuralFeature aFeature = this.getStructuralFeature();
        EObject target = this.getExpressionTarget();
        result.add((Command)new SetCommand(target, exp, aFeature));
        EStructuralFeature[] eStructuralFeatureArray = CLASS2FEATURES.get(this.getInput().eClass());
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (!feature.equals(aFeature) && target.eIsSet(feature)) {
                result.add((Command)new SetCommand(target, null, feature));
            }
            ++n2;
        }
        return result;
    }
}

