/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.markers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.ImageUtils;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.markers.IModelMarkerContentProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ModelMarkerUtil {
    public static final String DECORATION_MARKER_PROVIDERS_EXTENSION_ID = "org.eclipse.bpel.common.ui.modelMarkerContentProviders";
    public static final String DECORATION_MARKER_PROVIDER_CONFIG_NAME = "modelMarkerContentProvider";
    public static final String DECORATION_MARKER_PROVIDER_MARKER_TYPE_ATTR = "markerType";
    public static final String DECORATION_MARKER_PROVIDER_CLASS_ATTR = "class";
    private static Map markerTypeMap;

    private ModelMarkerUtil() {
    }

    public static IMarker getDisplayMarker(List markers, String anchorPoint) {
        if (anchorPoint == null) {
            throw new NullPointerException();
        }
        return ModelMarkerUtil.getDisplayMarker(markers.iterator(), anchorPoint);
    }

    public static IMarker getDisplayMarker(List markers) {
        return ModelMarkerUtil.getDisplayMarker(markers.iterator(), null);
    }

    private static IMarker getDisplayMarker(Iterator i, String anchorPoint) {
        IMarker displayMarker = null;
        int displayMarkerPriority = 0;
        while (i.hasNext()) {
            IMarker marker = (IMarker)i.next();
            String visible = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", "true");
            if (Boolean.valueOf(visible).equals(Boolean.FALSE)) continue;
            if (anchorPoint != null) {
                try {
                    String markerAnchorPoint = (String)marker.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint");
                    if (markerAnchorPoint == null) {
                        throw new IllegalArgumentException(Messages.ModelMarkerUtil_5);
                    }
                    if (!anchorPoint.equals(markerAnchorPoint)) {
                        continue;
                    }
                }
                catch (CoreException coreException) {}
            }
            int priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", 5);
            if (displayMarker != null && priority <= displayMarkerPriority) continue;
            displayMarker = marker;
            displayMarkerPriority = priority;
        }
        return displayMarker;
    }

    public static Image getImage(IMarker marker) {
        try {
            String markerType = marker.getType();
            IModelMarkerContentProvider provider = ModelMarkerUtil.getModelMarkerContentProvider(markerType);
            Image image = null;
            if (provider != null) {
                image = provider.getImage(marker);
            }
            if (image == null && marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                image = ImageUtils.getImage(marker);
            }
            return image;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String getText(IMarker marker) {
        try {
            String markerType = marker.getType();
            IModelMarkerContentProvider provider = ModelMarkerUtil.getModelMarkerContentProvider(markerType);
            String text = null;
            if (provider != null) {
                text = provider.getText(marker);
            }
            if (text == null && marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                text = (String)marker.getAttribute("message");
            }
            return text;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IModelMarkerContentProvider getModelMarkerContentProvider(IMarker marker, boolean checkSupertypes) {
        Object provider;
        if (markerTypeMap == null) {
            ModelMarkerUtil.initializeMarkerTypeMap();
        }
        try {
            provider = markerTypeMap.get(marker.getType());
            if (provider == null) {
                if (checkSupertypes) {
                    Iterator iterator = markerTypeMap.keySet().iterator();
                    while (iterator.hasNext() && provider == null) {
                        String type = (String)iterator.next();
                        if (!marker.isSubtypeOf(type)) continue;
                        provider = markerTypeMap.get(type);
                        provider = ModelMarkerUtil.checkProvider(type, provider);
                    }
                }
            } else {
                provider = ModelMarkerUtil.checkProvider(marker.getType(), provider);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return (IModelMarkerContentProvider)provider;
    }

    public static IModelMarkerContentProvider getModelMarkerContentProvider(String markerType) {
        if (markerTypeMap == null) {
            ModelMarkerUtil.initializeMarkerTypeMap();
        }
        if (markerTypeMap == null) {
            return null;
        }
        Object provider = markerTypeMap.get(markerType);
        if (provider == null) {
            return null;
        }
        provider = ModelMarkerUtil.checkProvider(markerType, provider);
        return (IModelMarkerContentProvider)provider;
    }

    private static IModelMarkerContentProvider checkProvider(String markerType, Object obj) {
        Object provider = obj;
        if (provider instanceof IConfigurationElement) {
            IConfigurationElement config = (IConfigurationElement)provider;
            try {
                provider = config.createExecutableExtension(DECORATION_MARKER_PROVIDER_CLASS_ATTR);
                markerTypeMap.put(markerType, provider);
            }
            catch (CoreException e) {
                MultiStatus status = new MultiStatus("org.eclipse.bpel.common.ui", 0, new IStatus[]{e.getStatus()}, NLS.bind((String)Messages.ModelMarkerUtil_6, (Object[])new Object[]{config.getDeclaringExtension().getUniqueIdentifier()}), (Throwable)e);
                CommonUIPlugin.getDefault().getLog().log((IStatus)status);
                return null;
            }
        }
        return (IModelMarkerContentProvider)provider;
    }

    private static void initializeMarkerTypeMap() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DECORATION_MARKER_PROVIDERS_EXTENSION_ID);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        markerTypeMap = new HashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configs = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                if (configs[j].getName().equals(DECORATION_MARKER_PROVIDER_CONFIG_NAME)) {
                    String markerType = configs[j].getAttribute(DECORATION_MARKER_PROVIDER_MARKER_TYPE_ATTR);
                    if (markerType == null) {
                        CommonUIPlugin.getDefault().getLog().log((IStatus)ModelMarkerUtil.createErrorStatus(NLS.bind((String)Messages.ModelMarkerUtil_7, (Object[])new Object[]{extensions[i].getUniqueIdentifier()})));
                    } else if (markerTypeMap.containsKey(markerType)) {
                        CommonUIPlugin.getDefault().getLog().log((IStatus)ModelMarkerUtil.createErrorStatus(NLS.bind((String)Messages.ModelMarkerUtil_8, (Object[])new Object[]{markerType})));
                    } else {
                        markerTypeMap.put(markerType, configs[j]);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static Status createErrorStatus(String message) {
        return new Status(4, "org.eclipse.bpel.common.ui", 0, message, null);
    }
}

