/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.wsdl.importhelpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.bpel.common.wsdl.SoaWsdlCommonPlugin;
import org.eclipse.bpel.common.wsdl.helpers.UriAndUrlHelper;
import org.eclipse.bpel.common.wsdl.importhelpers.WsdlImportBean;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WsdlImportHelper {
    public static final String RELOCATED_DIRECTORY = "relocated";
    public static final String WSDL20_NAMESPACE = "http://www.w3.org/ns/wsdl";
    public static final String WSDL11_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSI_NAMESPACE = "http://http://www.w3.org/2001/XMLSchema-instance";
    private final DocumentBuilder documentBuilder;

    public WsdlImportHelper() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.documentBuilder = factory.newDocumentBuilder();
    }

    public Map<String, File> importWsdlOrXsdAndDependencies(File targetDirectory, String ... wsdlUris) throws IllegalArgumentException, IOException, URISyntaxException, SAXException {
        HashMap<String, WsdlImportBean> resourceUriToWIBean = new HashMap<String, WsdlImportBean>();
        this.analyzeResources(resourceUriToWIBean, null, wsdlUris);
        HashSet<File> targetFiles = new HashSet<File>();
        Path rootPath = new Path(targetDirectory.getAbsolutePath());
        for (Map.Entry entry : resourceUriToWIBean.entrySet()) {
            File targetFile;
            String relativeFilePath = ((WsdlImportBean)entry.getValue()).getRelativePathToTargetDirectory();
            if (relativeFilePath.length() == 0) {
                relativeFilePath = UriAndUrlHelper.extractOrGenerateFileName((String)entry.getKey());
            } else if (!relativeFilePath.contains("/") && !relativeFilePath.contains("\\")) {
                relativeFilePath = UriAndUrlHelper.extractOrGenerateFileName(relativeFilePath);
            }
            IPath path = rootPath.append(relativeFilePath);
            if (!rootPath.isPrefixOf(path)) {
                relativeFilePath = "relocated/" + UriAndUrlHelper.extractOrGenerateFileName((String)entry.getKey());
            }
            String newRelativeFilePath = relativeFilePath;
            int cpt = 0;
            while ((targetFile = new File(targetDirectory, newRelativeFilePath)).exists() || targetFiles.contains(targetFile)) {
                newRelativeFilePath = WsdlImportHelper.insertSuffixBeforeFileExtension(relativeFilePath, "_" + cpt);
                ++cpt;
            }
            ((WsdlImportBean)entry.getValue()).setRelativePathToTargetDirectory(newRelativeFilePath);
            targetFiles.add(targetFile);
        }
        HashMap<String, File> originUriToTargetFile = new HashMap<String, File>();
        for (WsdlImportBean bean : resourceUriToWIBean.values()) {
            ByteArrayInputStream is;
            File targetFile = new File(targetDirectory, bean.getRelativePathToTargetDirectory());
            URI uri = UriAndUrlHelper.urlToUri(bean.getOriginUri());
            StringBuilder fileContent = new StringBuilder(WsdlImportHelper.readResourceContent(uri));
            for (Map.Entry<String, String> entry : bean.getImportDeclarationToImportFullUri().entrySet()) {
                WsdlImportBean importBean = (WsdlImportBean)resourceUriToWIBean.get(entry.getValue());
                File importFile = new File(targetDirectory, importBean.getRelativePathToTargetDirectory());
                String relLoc = WsdlImportHelper.getRelativeLocationToFile(targetFile, importFile);
                String pattern = "(\\s|\")" + Pattern.quote(entry.getKey()) + "(\\s|\")";
                Matcher matcher = Pattern.compile(pattern, 40).matcher(fileContent.toString());
                while (matcher.find()) {
                    int start = matcher.start() + 1;
                    int end = matcher.end() - 1;
                    fileContent.replace(start, end, relLoc);
                }
            }
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new IOException("Could not create " + targetFile.getParentFile());
            }
            FileOutputStream os = new FileOutputStream(targetFile);
            try {
                is = new ByteArrayInputStream(fileContent.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                is = new ByteArrayInputStream(fileContent.toString().getBytes());
            }
            WsdlImportHelper.copyStream(is, os);
            ((OutputStream)os).close();
            originUriToTargetFile.put(bean.getOriginUri(), targetFile);
        }
        return originUriToTargetFile;
    }

    private void analyzeResources(Map<String, WsdlImportBean> resourceUriToWIBean, URI referentUri, String ... wsdlUris) throws URISyntaxException, IOException, SAXException {
        String[] stringArray = wsdlUris;
        int n = wsdlUris.length;
        int n2 = 0;
        while (n2 < n) {
            WsdlImportBean bean;
            String wsdlUri = stringArray[n2];
            if (!resourceUriToWIBean.containsKey(wsdlUri)) {
                bean = new WsdlImportBean();
                bean.setOriginUri(wsdlUri);
                bean.setRelativePathToTargetDirectory("");
                resourceUriToWIBean.put(wsdlUri, bean);
            }
            bean = resourceUriToWIBean.get(wsdlUri);
            bean.setAnalyzed(true);
            URI uri = UriAndUrlHelper.urlToUri(wsdlUri);
            referentUri = referentUri != null ? referentUri : uri;
            Set<String> brutImports = this.findImports(uri);
            for (String brutImport : brutImports) {
                WsdlImportBean childBean;
                URI importFullUri = null;
                String importFullUriAsString = null;
                if (UriAndUrlHelper.isAbsoluteUri(brutImport)) {
                    importFullUri = UriAndUrlHelper.urlToUri(brutImport);
                    importFullUriAsString = brutImport;
                } else {
                    importFullUri = UriAndUrlHelper.buildNewURI(uri, brutImport);
                    importFullUriAsString = importFullUri.toString();
                }
                bean.registerImport(brutImport, importFullUriAsString);
                if (!resourceUriToWIBean.containsKey(importFullUriAsString)) {
                    childBean = new WsdlImportBean();
                    childBean.setOriginUri(importFullUriAsString);
                    URI relativeUri = UriAndUrlHelper.getRelativeLocationToUri(referentUri, importFullUri);
                    String relPath = relativeUri.toString();
                    if (UriAndUrlHelper.isAbsoluteUri(relPath)) {
                        relPath = "";
                    }
                    childBean.setRelativePathToTargetDirectory(relPath);
                    resourceUriToWIBean.put(importFullUriAsString, childBean);
                }
                if ((childBean = resourceUriToWIBean.get(importFullUriAsString)).wasAnalyzed()) continue;
                this.analyzeResources(resourceUriToWIBean, referentUri, importFullUriAsString);
            }
            ++n2;
        }
    }

    private Set<String> findImports(URI referencerUri) throws IOException, SAXException {
        HashSet<String> result = new HashSet<String>();
        URLConnection connection = referencerUri.toURL().openConnection();
        InputStream is = connection.getInputStream();
        Document referencerDocument = this.documentBuilder.parse(is);
        Element docRoot = referencerDocument.getDocumentElement();
        String rootNs = docRoot.getNamespaceURI();
        String rootName = docRoot.getLocalName();
        int index = rootName.lastIndexOf(58);
        if (index != -1) {
            rootName = rootName.substring(++index);
        }
        if ("definitions".equals(rootName) && WSDL11_NAMESPACE.equals(rootNs) || "description".equals(rootName) && WSDL20_NAMESPACE.equals(rootNs) || "schema".equals(rootName) && SCHEMA_NAMESPACE.equals(rootNs)) {
            result.addAll(this.findImports(docRoot));
        }
        return result;
    }

    private Set<String> findImports(Element docRoot) {
        ArrayList<NodeList> importElements = new ArrayList<NodeList>();
        importElements.add(docRoot.getElementsByTagNameNS(WSDL11_NAMESPACE, "import"));
        importElements.add(docRoot.getElementsByTagNameNS(WSDL20_NAMESPACE, "import"));
        importElements.add(docRoot.getElementsByTagNameNS(WSDL20_NAMESPACE, "include"));
        importElements.add(docRoot.getElementsByTagNameNS(SCHEMA_NAMESPACE, "import"));
        importElements.add(docRoot.getElementsByTagNameNS(SCHEMA_NAMESPACE, "include"));
        HashSet<String> importLocations = new HashSet<String>();
        for (NodeList nodeList : importElements) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String location;
                Element importElement = (Element)nodeList.item(i);
                String string = location = importElement.hasAttribute("location") ? importElement.getAttribute("location") : null;
                if (location == null) {
                    int index;
                    String string2 = location = importElement.hasAttribute("schemaLocation") ? importElement.getAttribute("schemaLocation") : null;
                    if (location != null && (index = location.lastIndexOf(32)) != -1) {
                        location = location.substring(++index);
                    }
                }
                if (location != null) {
                    importLocations.add(location);
                }
                ++i;
            }
        }
        return importLocations;
    }

    private static String getRelativeLocationToFile(File originFile, File file) {
        String result = file.getAbsolutePath();
        try {
            URI originUri = UriAndUrlHelper.urlToUri(originFile.toURI().toURL());
            URI fileUri = UriAndUrlHelper.urlToUri(file.toURI().toURL());
            result = UriAndUrlHelper.getRelativeLocationToUri(originUri, fileUri).toString();
        }
        catch (MalformedURLException e) {
            SoaWsdlCommonPlugin.log(e, 4);
        }
        return result;
    }

    public static String readResourceContent(URI uri) throws IOException {
        String result = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            is = uri.toURL().openStream();
            WsdlImportHelper.copyStream(is, os);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        try {
            result = os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = os.toString();
        }
        return result;
    }

    private static void copyStream(InputStream in, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
    }

    private static String insertSuffixBeforeFileExtension(String string, String suffix) {
        int index = string.lastIndexOf(46);
        String result = index == -1 ? String.valueOf(string) + suffix : String.valueOf(string.substring(0, index)) + suffix + string.substring(index);
        return result;
    }
}

