/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.expressions;

import org.eclipse.bpel.ui.editors.TextEditor;
import org.eclipse.bpel.ui.editors.TextEditorInput;
import org.eclipse.bpel.ui.expressions.AbstractExpressionEditor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DefaultExpressionEditor
extends AbstractExpressionEditor {
    protected Composite editorComposite;
    protected TextEditor editor;
    protected IPropertyListener propertyListener;
    protected String undoRedoLabel;
    protected String fBody;
    protected boolean updating = false;
    protected FocusListener focusListener;

    @Override
    public String getEditorContent() {
        if (this.editor != null) {
            return this.editor.getContents();
        }
        return this.fBody;
    }

    @Override
    public void createControls(Composite parent, FormToolkit toolkit) {
        super.createControls(parent, toolkit);
        this.createEditor(parent);
    }

    @Override
    public void setEditorContent(String aBody) {
        this.fBody = aBody;
        try {
            this.updating = true;
            if (this.editor != null) {
                this.editor.setInput(new TextEditorInput(this.fBody, this.getModelObject(), this.getExprType()));
            }
        }
        finally {
            this.updating = false;
        }
    }

    protected void createEditor(Composite parent) {
        TextEditorInput input = new TextEditorInput(this.fBody, this.getModelObject(), this.getExprType());
        this.editorComposite = this.wf.createComposite(parent, 2048);
        this.editorComposite.setLayout((Layout)new FillLayout());
        this.editor = (TextEditor)this.createEditor(TextEditor.TEXT_EDITOR_ID, input, this.editorComposite);
    }

    @Override
    public void dispose() {
        this.disposeEditor();
    }

    protected void disposeEditor() {
        if (this.editor != null) {
            this.getEditorManager().disposeEditor((IEditorPart)this.editor);
            if (this.editorComposite != null && !this.editorComposite.isDisposed()) {
                this.editorComposite.dispose();
                this.editorComposite = null;
            }
            this.editor = null;
        }
    }

    @Override
    public void aboutToBeHidden() {
        if (this.editor != null) {
            this.editor.removePropertyListener(this.getPropertyListener());
            this.editor.removeFocusListener(this.getFocusListener());
        }
    }

    @Override
    public void aboutToBeShown() {
        if (this.editor != null) {
            this.editor.addPropertyListener(this.getPropertyListener());
            this.editor.addFocusListener(this.getFocusListener());
        }
    }

    protected IPropertyListener getPropertyListener() {
        if (this.propertyListener == null) {
            this.propertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (!DefaultExpressionEditor.this.updating && propId == 257 && DefaultExpressionEditor.this.editor.isDirty()) {
                        DefaultExpressionEditor.this.notifyChanged();
                    }
                }
            };
        }
        return this.propertyListener;
    }

    protected FocusListener getFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    DefaultExpressionEditor.this.notifyFocusOut();
                }
            };
        }
        return this.focusListener;
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.editor.setFocus();
    }

    @Override
    public String getDefaultContent() {
        return "";
    }

    @Override
    public void gotoTextMarker(IMarker marker, String codeType, Object modelObject) {
    }

    @Override
    public boolean supportsExpressionType(String exprType) {
        return true;
    }

    @Override
    public void markAsClean() {
        if (this.editor != null) {
            this.editor.markAsClean();
        }
    }
}

