/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.composite;

import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IKeyBindingService;

public class CompositeEditorKeyBindingService
implements IKeyBindingService {
    protected IKeyBindingService parent;
    protected SortedMap commandIdToActionMap;

    public CompositeEditorKeyBindingService(IKeyBindingService parent) {
        this.parent = parent;
        this.commandIdToActionMap = new TreeMap();
    }

    public void activate() {
        for (IAction action : this.commandIdToActionMap.values()) {
            this.parent.registerAction(action);
        }
    }

    public void deactivate() {
        for (IAction action : this.commandIdToActionMap.values()) {
            this.parent.unregisterAction(action);
        }
    }

    public void enable(boolean enable) {
    }

    public String getActiveAcceleratorConfigurationId() {
        return null;
    }

    public String getActiveAcceleratorScopeId() {
        return null;
    }

    public boolean processKey(KeyEvent event) {
        return false;
    }

    public void registerAction(IAction action) throws IllegalArgumentException {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.put(command, action);
        }
    }

    public void setActiveAcceleratorScopeId(String scopeId) throws IllegalArgumentException {
    }

    public void unregisterAction(IAction action) throws IllegalArgumentException {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.remove(command);
        }
    }

    public String[] getScopes() {
        return null;
    }

    public void setScopes(String[] scopes) throws IllegalArgumentException {
    }
}

