/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.expressions;

import org.eclipse.bpel.fnmeta.model.Function;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetNamespaceMappingCommand;
import org.eclipse.bpel.ui.editors.TextEditorInput;
import org.eclipse.bpel.ui.editors.xpath.XPathTextEditor;
import org.eclipse.bpel.ui.expressions.AbstractExpressionEditor;
import org.eclipse.bpel.ui.expressions.Functions;
import org.eclipse.bpel.ui.properties.DateTimeSelector;
import org.eclipse.bpel.ui.properties.DurationSelector;
import org.eclipse.bpel.ui.util.BPELDateTimeHelpers;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class XPathExpressionEditor
extends AbstractExpressionEditor {
    static final String BOOLEAN_EXPR_DEFAULT = "true()";
    static final String UNSIGNED_INT_EXPR_DEFAULT = "1";
    static final String TEXT_STRING = Messages.XPathExpressionEditor_Text_0;
    static final String LITERAL_STRING = Messages.XPathExpressionEditor_Literal_1;
    static final int TEXT = 0;
    static final int LITERAL = 1;
    protected static final String DEFAULT_DURATION_VALUE = "'P0D'";
    protected Combo combo;
    protected Label comboLabel;
    protected Composite mainComposite;
    protected XPathTextEditor textEditor;
    protected DateTimeSelector dateTimeSelector;
    protected DurationSelector durationSelector;
    protected IPropertyListener propertyListener;
    protected Composite editorComposite;
    protected Composite textEditorComposite;
    protected Composite durationEditorComposite;
    protected Composite dateTimeEditorComposite;
    protected TextEditorInput textEditorInput;
    private FocusListener focusListener;

    @Override
    public void createControls(Composite parent, FormToolkit toolkit) {
        super.createControls(parent, toolkit);
        this.createEditor(parent);
    }

    protected void createEditor(Composite parent) {
        this.mainComposite = this.wf.createComposite(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setBackground(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_WHITE"));
        this.comboLabel = this.wf.createLabel(this.mainComposite, Messages.XPathExpressionEditor_Expression_Type_2);
        this.combo = new Combo(this.mainComposite, 0x800808);
        this.combo.add(TEXT_STRING);
        this.combo.add(LITERAL_STRING);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XPathExpressionEditor.this.updateEditorToType(XPathExpressionEditor.this.combo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.combo, 0, 0x1000000);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.combo, -5);
        this.comboLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.comboLabel, 157));
        data.right = new FormAttachment(100, 0);
        this.combo.setLayoutData((Object)data);
        this.editorComposite = this.wf.createComposite(this.mainComposite);
        this.editorComposite.setLayout((Layout)new StackLayout());
        data = new FormData();
        data.top = new FormAttachment((Control)this.combo, 8);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.editorComposite.setLayoutData((Object)data);
    }

    protected void rearrangeComboAndEditorComposite() {
        boolean comboVisible = this.isLiteralType();
        this.combo.setVisible(comboVisible);
        this.comboLabel.setVisible(comboVisible);
        if (this.editorComposite != null) {
            FormData data = (FormData)this.editorComposite.getLayoutData();
            data.top = comboVisible ? new FormAttachment((Control)this.combo, 8) : new FormAttachment(0, 8);
        }
    }

    Composite getTextEditorComposite() {
        if (this.textEditorComposite != null) {
            return this.textEditorComposite;
        }
        this.textEditorComposite = this.wf.createComposite(this.editorComposite, 2048);
        this.textEditorComposite.setLayout((Layout)new FillLayout());
        this.textEditor = (XPathTextEditor)this.createEditor(XPathTextEditor.XPATH_EDITOR_ID, this.textEditorInput, this.textEditorComposite);
        this.textEditor.addPropertyListener(this.getPropertyListener());
        this.textEditor.addFocusListener(this.getFocusListener());
        this.textEditor.setDecoration(true);
        return this.textEditorComposite;
    }

    protected FocusListener getFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    XPathExpressionEditor.this.notifyFocusOut();
                }
            };
        }
        return this.focusListener;
    }

    Composite getDateTimeEditor() {
        if (this.dateTimeEditorComposite != null) {
            return this.dateTimeEditorComposite;
        }
        this.dateTimeEditorComposite = this.wf.createComposite(this.editorComposite, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.dateTimeEditorComposite.setLayout((Layout)layout);
        Label label = this.wf.createLabel(this.dateTimeEditorComposite, Messages.XPathExpressionEditor_Date_Time_UTC_3);
        this.dateTimeSelector = new DateTimeSelector(this.wf, this.dateTimeEditorComposite, 0, 2002, BPELDateTimeHelpers.yearMax);
        String body = (String)this.textEditorInput.getAdapter(String.class);
        int[] dateTime = BPELDateTimeHelpers.parseXPathDateTime(body, false);
        this.dateTimeSelector.setValues(dateTime);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.dateTimeSelector, -5);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, BPELUtil.calculateLabelWidth((Widget)label, 157));
        this.dateTimeSelector.setLayoutData(data);
        this.dateTimeSelector.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (XPathExpressionEditor.this.textEditorInput != null) {
                    int[] values = XPathExpressionEditor.this.dateTimeSelector.getValues();
                    XPathExpressionEditor.this.textEditorInput.setEditorContent(BPELDateTimeHelpers.createXPathDateTime(values, false), XPathExpressionEditor.this.getModelObject());
                }
                XPathExpressionEditor.this.notifyChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.dateTimeEditorComposite, "org.eclipse.bpel.ui.xpath_date");
        return this.dateTimeEditorComposite;
    }

    Composite getDurationEditor() {
        if (this.durationEditorComposite != null) {
            return this.durationEditorComposite;
        }
        this.durationEditorComposite = this.wf.createComposite(this.editorComposite, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.durationEditorComposite.setLayout((Layout)layout);
        Label label = this.wf.createLabel(this.durationEditorComposite, Messages.XPathExpressionEditor_Duration_4);
        this.durationSelector = new DurationSelector(this.wf, this.durationEditorComposite, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.durationSelector, -5);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, BPELUtil.calculateLabelWidth((Widget)label, 157));
        this.durationSelector.setLayoutData(data);
        this.durationSelector.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (XPathExpressionEditor.this.textEditorInput != null) {
                    int[] duration = XPathExpressionEditor.this.durationSelector.getValues();
                    XPathExpressionEditor.this.textEditorInput.setEditorContent(BPELDateTimeHelpers.createXPathDuration(duration), XPathExpressionEditor.this.getModelObject());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.durationEditorComposite, "org.eclipse.bpel.ui.xpath_duration");
        return this.durationEditorComposite;
    }

    @Override
    public void dispose() {
        if (this.textEditor != null) {
            this.getEditorManager().disposeEditor((IEditorPart)this.textEditor);
            this.textEditor = null;
        }
        if (this.editorComposite != null && !this.editorComposite.isDisposed()) {
            this.editorComposite.dispose();
            this.editorComposite = null;
        }
    }

    @Override
    public void refresh() {
        int editorType = this.combo.getSelectionIndex();
        if (editorType < 0) {
            String body = (String)this.textEditorInput.getAdapter(String.class);
            editorType = 0;
            if (BPELDateTimeHelpers.parseXPathDuration(body) != null) {
                editorType = 1;
            } else if (BPELDateTimeHelpers.parseXPathDateTime(body, false) != null) {
                editorType = 1;
            }
            this.combo.select(editorType);
        }
        this.updateEditorToType(editorType);
    }

    void updateEditorToType(int editorType) {
        String body = (String)this.textEditorInput.getAdapter(String.class);
        switch (editorType) {
            case 0: {
                this.restackEditorComposite(this.getTextEditorComposite());
                break;
            }
            case 1: {
                if ("duration".equals(this.getExprType())) {
                    this.restackEditorComposite(this.getDurationEditor());
                    int[] duration = BPELDateTimeHelpers.parseXPathDuration(body);
                    if (duration == null) break;
                    this.durationSelector.setValues(duration);
                    break;
                }
                this.restackEditorComposite(this.getDateTimeEditor());
                int[] dateTime = BPELDateTimeHelpers.parseXPathDateTime(body, false);
                if (dateTime == null) break;
                this.dateTimeSelector.setValues(dateTime);
            }
        }
    }

    void restackEditorComposite(Composite c) {
        Layout layout = c.getParent().getLayout();
        if (layout instanceof StackLayout) {
            StackLayout stackLayout = (StackLayout)layout;
            if (c != stackLayout.topControl) {
                stackLayout.topControl = c;
                this.rearrangeComboAndEditorComposite();
                c.getParent().layout(true);
            }
        }
    }

    @Override
    public void aboutToBeHidden() {
    }

    @Override
    public void aboutToBeShown() {
        this.refresh();
    }

    protected IPropertyListener getPropertyListener() {
        if (this.propertyListener == null) {
            this.propertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 257) {
                        boolean isEditorDirty = false;
                        if (XPathExpressionEditor.this.textEditor != null) {
                            isEditorDirty = XPathExpressionEditor.this.textEditor.isDirty();
                        }
                        if (isEditorDirty) {
                            XPathExpressionEditor.this.notifyChanged();
                        }
                    }
                }
            };
        }
        return this.propertyListener;
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        if (this.textEditor != null) {
            this.textEditor.setFocus();
        }
    }

    @Override
    public String getEditorContent() {
        int editorType = this.combo.getSelectionIndex();
        if (editorType == 1) {
            if ("duration".equals(this.getExprType())) {
                int[] duration = this.durationSelector.getValues();
                return BPELDateTimeHelpers.createXPathDuration(duration);
            }
            int[] dateTime = this.dateTimeSelector.getValues();
            return BPELDateTimeHelpers.createXPathDateTime(dateTime, false);
        }
        return this.textEditor.getContents();
    }

    @Override
    public void setEditorContent(String body) {
        this.textEditorInput = new TextEditorInput(body, this.getModelObject(), this.getExprType());
        if (this.textEditor != null) {
            this.textEditor.setInput(this.textEditorInput);
        }
    }

    boolean isLiteralType() {
        return "duration".equals(this.getExprType()) || "deadline".equals(this.getExprType());
    }

    @Override
    public String getDefaultContent() {
        if (this.isLiteralType()) {
            return this.getDefaultBody(1);
        }
        return this.getDefaultBody(0);
    }

    protected String getDefaultBody(int comboValue) {
        String exprType = this.getExprType();
        switch (comboValue) {
            case 0: {
                if (exprType.indexOf("boolean") >= 0) {
                    return BOOLEAN_EXPR_DEFAULT;
                }
                if (exprType.indexOf("unsignedInt") >= 0) {
                    return UNSIGNED_INT_EXPR_DEFAULT;
                }
                return "";
            }
            case 1: {
                if (exprType.indexOf("duration") >= 0) {
                    return DEFAULT_DURATION_VALUE;
                }
                int[] dateTime = BPELDateTimeHelpers.getCurrentLocalDateTime();
                BPELDateTimeHelpers.convertLocalToGMT(dateTime);
                return BPELDateTimeHelpers.createXPathDateTime(dateTime, false);
            }
        }
        return "";
    }

    @Override
    public void gotoTextMarker(IMarker marker, String codeType, Object modelObject) {
    }

    @Override
    public boolean supportsExpressionType(String exprType) {
        return true;
    }

    @Override
    public void markAsClean() {
        if (this.textEditor != null) {
            this.textEditor.markAsClean();
        }
    }

    @Override
    public void addExtraStoreCommands(CompoundCommand compoundCommand) {
        EObject eObj = (EObject)this.getModelObject();
        for (Function fn : Functions.getInstance("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0").getFunctions().values()) {
            String pfx;
            if (BPELUtils.isEmptyOrWhitespace((String)fn.getNamespace()) || "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(fn.getNamespace()) || (pfx = BPELUtils.getNamespacePrefix((EObject)eObj, (String)fn.getNamespace())) != null) continue;
            compoundCommand.add((Command)new SetNamespaceMappingCommand(eObj, fn.getNamespace(), fn.getPrefix()));
        }
    }
}

