/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.ImportResolver;
import org.eclipse.bpel.model.util.ImportResolverRegistry;
import org.eclipse.bpel.ui.details.providers.AbstractContentProvider;
import org.eclipse.bpel.ui.properties.NamespacePrefixElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Definition;

public class NamespacePrefixesProvider
extends AbstractContentProvider {
    @Override
    public void collectElements(Object input, List<Object> list) {
        ArrayList<NamespacePrefixElement> elements = new ArrayList<NamespacePrefixElement>();
        Process process = null;
        if (input instanceof EObject) {
            EObject context = (EObject)input;
            process = BPELUtils.getProcess((Object)input);
            while (context != null) {
                try {
                    INamespaceMap iNamespaceMap = BPELUtils.getNamespaceMap((EObject)context);
                    for (Map.Entry e : iNamespaceMap.entrySet()) {
                        String ns = ((String)e.getValue()).toString();
                        NamespacePrefixElement elem = new NamespacePrefixElement((String)e.getKey(), ns, context, null);
                        elements.add(elem);
                        if (!"http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals(ns) && !process.getTargetNamespace().equals(ns)) continue;
                        elem.location = process.eResource().getURI().lastSegment();
                    }
                }
                catch (Exception exception) {}
                context = context.eContainer();
            }
        }
        ArrayList<Object> imports = new ArrayList<Object>();
        if (process != null) {
            for (Import import_ : process.getImports()) {
                ImportResolver r;
                List rl;
                imports.add(import_);
                if (!import_.getImportType().equals("http://schemas.xmlsoap.org/wsdl/") || import_.getLocation().startsWith("http://") || import_.getLocation().startsWith("https://") || (rl = (r = ImportResolverRegistry.INSTANCE.getResolvers(import_.getImportType())[0]).resolve(import_, 2)).size() <= 0) continue;
                Definition wsdl = (Definition)rl.get(0);
                this.recurseImports(wsdl.getImports(), imports, elements);
            }
        }
        for (Object e : imports) {
            String namespace = "";
            String location = "";
            if (e instanceof org.eclipse.wst.wsdl.Import) {
                location = ((org.eclipse.wst.wsdl.Import)e).getLocationURI();
                namespace = ((org.eclipse.wst.wsdl.Import)e).getNamespaceURI();
            } else {
                if (!(e instanceof Import)) continue;
                location = ((Import)e).getLocation();
                namespace = ((Import)e).getNamespace();
            }
            boolean found = false;
            for (NamespacePrefixElement elem : elements) {
                if (!namespace.equals(elem.namespace)) continue;
                if (elem.location == null) {
                    elem.location = location;
                }
                found = true;
            }
            if (found) continue;
            elements.add(new NamespacePrefixElement("", namespace, null, location));
        }
        list.addAll(elements);
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((NamespacePrefixElement)o1).prefix.compareTo(((NamespacePrefixElement)o2).prefix);
            }
        });
    }

    private void recurseImports(Map m, List<Object> imports, List<NamespacePrefixElement> elements) {
        for (Map.Entry e : m.entrySet()) {
            ArrayList v = (ArrayList)e.getValue();
            for (org.eclipse.wst.wsdl.Import wsdlImp : v) {
                boolean foundNew = true;
                for (Object o : imports) {
                    if (o instanceof org.eclipse.wst.wsdl.Import) {
                        Definition wsdl = ((org.eclipse.wst.wsdl.Import)o).getEDefinition();
                        if (((org.eclipse.wst.wsdl.Import)o).getLocationURI().equals(wsdlImp.getLocationURI())) {
                            foundNew = false;
                        }
                        Set ns = wsdl.getNamespaces().entrySet();
                        System.out.println("ns=" + ns);
                        continue;
                    }
                    if (!(o instanceof Import) || !((Import)o).getLocation().equals(wsdlImp.getLocationURI())) continue;
                    foundNew = false;
                }
                if (foundNew) {
                    imports.add(wsdlImp);
                }
                if (wsdlImp.getLocationURI().startsWith("http://") || wsdlImp.getDefinition() == null) continue;
                block3: for (NamespacePrefixElement elem : elements) {
                    if (elem.location != null) continue;
                    Map ns = wsdlImp.getDefinition().getNamespaces();
                    for (Map.Entry ens : ns.entrySet()) {
                        if (!ens.getValue().equals(elem.namespace)) continue;
                        elem.location = wsdlImp.getLocationURI();
                        continue block3;
                    }
                }
                this.recurseImports(wsdlImp.getDefinition().getImports(), imports, elements);
            }
        }
    }
}

