/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.composite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.Policy;
import org.eclipse.bpel.common.ui.composite.CompositeEditorActionBars;
import org.eclipse.bpel.common.ui.composite.CompositeEditorManager;
import org.eclipse.bpel.common.ui.composite.CompositeEditorSelectionProvider;
import org.eclipse.bpel.common.ui.composite.CompositeEditorSite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class CompositeEditor
extends EditorPart {
    protected EmbeddedEditorsCollection embeddedEditors = new EmbeddedEditorsCollection();
    protected IPropertyListener propertyListener;
    protected CompositeEditorManager editorManager;
    protected IEditorPart mainEditor;
    private IPartListener partListener;

    public IEditorPart connectEditor(String editorId, IEditorInput input, Composite editorComposite) throws CoreException {
        IEditorPart editor = this.editorManager.createEditor(editorId, input);
        this.embeddedEditors.add(editor);
        Composite composite = new Composite(editorComposite, 0);
        composite.setLayout((Layout)new FillLayout());
        editor.createPartControl(composite);
        editor.addPropertyListener(this.getPropertyListener());
        this.associate(editor, (Control)composite);
        return editor;
    }

    public void associate(final IEditorPart editor, Control control) {
        control.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                CompositeEditor.this.activateEditor(editor);
            }
        });
    }

    protected void activateEditor(IEditorPart newEditor) {
        IEditorPart oldEditor = this.embeddedEditors.getActiveEditor();
        if (oldEditor != null) {
            if (oldEditor == newEditor) {
                return;
            }
            this.editorManager.deactivate(oldEditor);
        }
        this.editorManager.activate(newEditor);
        this.embeddedEditors.setActiveEditor(newEditor);
    }

    public void disconnectEditor(IEditorPart editor) throws CoreException {
        if (editor == this.embeddedEditors.getActiveEditor()) {
            if (this.mainEditor != null && editor != this.mainEditor) {
                this.activateEditor(this.mainEditor);
            } else {
                Status status = new Status(4, "org.eclipse.bpel.common.ui", 3, NLS.bind((String)Messages.CompositeEditor_Cannot_disconnect_active_editor, (Object[])new Object[]{editor.getTitle()}), null);
                throw new CoreException((IStatus)status);
            }
        }
        this.embeddedEditors.remove(editor);
        editor.removePropertyListener(this.getPropertyListener());
        CompositeEditorSite site = (CompositeEditorSite)editor.getSite();
        CompositeEditorActionBars actionBars = (CompositeEditorActionBars)site.getActionBars();
        actionBars.dispose();
        site.dispose();
        editor.dispose();
    }

    protected IPropertyListener getPropertyListener() {
        if (this.propertyListener == null) {
            this.propertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    CompositeEditor.this.firePropertyChange(propId);
                }
            };
        }
        return this.propertyListener;
    }

    public final void dispose() {
        this.embeddedEditors.setActiveEditor(null);
        this.internalDispose();
        IEditorPart[] editors = this.embeddedEditors.getEmbeddedEditors();
        int i = 0;
        while (i < editors.length) {
            try {
                this.disconnectEditor(editors[i]);
            }
            catch (CoreException coreException) {}
            ++i;
        }
        this.getEditorSite().getPage().removePartListener(this.getPartlistener());
        super.dispose();
        this.getEditorSite().setSelectionProvider(null);
        this.embeddedEditors.clearEditors();
        this.embeddedEditors = null;
    }

    protected void internalDispose() {
    }

    public boolean isDirty() {
        IEditorPart[] editors = this.embeddedEditors.getEmbeddedEditors();
        int i = 0;
        while (i < editors.length) {
            if (editors[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            IEditorPart[] editors = this.getEmbeddedEditorsSaveOrder(this.embeddedEditors.getEmbeddedEditors());
            String message = Messages.CompositeEditor_2;
            monitor.beginTask(message, Math.max(1, editors.length));
            int i = 0;
            while (i < editors.length) {
                final IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 1);
                final IEditorPart editor = editors[i];
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        editor.doSave(subMonitor);
                    }

                    public void handleException(Throwable exception) {
                    }
                };
                SafeRunnable.run((ISafeRunnable)runnable);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IEditorPart[] getEmbeddedEditorsSaveOrder(IEditorPart[] editors) {
        return editors;
    }

    public void setFocus() {
        IEditorPart active = this.embeddedEditors.getActiveEditor();
        if (active != null) {
            active.setFocus();
        }
    }

    public void setMainEditor(IEditorPart editor) throws CoreException {
        if (!this.embeddedEditors.contains(editor)) {
            Status status = new Status(4, "org.eclipse.bpel.common.ui", 4, String.valueOf(Messages.CompositeEditor_3) + editor.getTitle(), null);
            throw new CoreException((IStatus)status);
        }
        this.mainEditor = editor;
        this.activateEditor(editor);
    }

    public IEditorPart getMainEditor() {
        return this.mainEditor;
    }

    public IEditorPart getActiveEditor() {
        return this.embeddedEditors.getActiveEditor();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.editorManager = new CompositeEditorManager(site);
        this.getEditorSite().getPage().addPartListener(this.getPartlistener());
        this.getEditorSite().setSelectionProvider((ISelectionProvider)new CompositeEditorSelectionProvider(this));
    }

    private IPartListener getPartlistener() {
        if (this.partListener == null) {
            this.partListener = new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                    IEditorPart lastActiveEditor;
                    if (part == CompositeEditor.this && (lastActiveEditor = CompositeEditor.this.embeddedEditors.getActiveEditor()) != null) {
                        CompositeEditor.this.editorManager.activate(lastActiveEditor);
                    }
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                    if (part == CompositeEditor.this) {
                        CompositeEditor.this.editorManager.deactivate(CompositeEditor.this.embeddedEditors.getActiveEditor());
                    }
                }

                public void partOpened(IWorkbenchPart part) {
                }
            };
        }
        return this.partListener;
    }

    class EmbeddedEditorsCollection {
        private List<IEditorPart> editors = new ArrayList<IEditorPart>(10);
        private IEditorPart[] editorsArrayCache = null;
        private int activeEditorIndex = -1;

        EmbeddedEditorsCollection() {
        }

        void add(IEditorPart editor) {
            this.editors.add(editor);
            this.editorsArrayCache = null;
        }

        void remove(IEditorPart editor) {
            IEditorPart currentActiveEditor = this.getActiveEditor();
            if (currentActiveEditor == editor) {
                throw new IllegalArgumentException(Messages.CompositeEditor_0);
            }
            this.editors.remove(editor);
            this.editorsArrayCache = null;
            this.setActiveEditor(currentActiveEditor);
        }

        IEditorPart[] getEmbeddedEditors() {
            if (this.editorsArrayCache == null) {
                this.editorsArrayCache = this.editors.toArray(new IEditorPart[this.editors.size()]);
            }
            return this.editorsArrayCache;
        }

        IEditorPart getActiveEditor() {
            if (this.activeEditorIndex == -1) {
                return null;
            }
            IEditorPart[] editors = this.getEmbeddedEditors();
            return editors[this.activeEditorIndex];
        }

        boolean contains(IEditorPart editor) {
            return this.editors.contains(editor);
        }

        void setActiveEditor(IEditorPart editor) {
            if (editor == null) {
                this.activeEditorIndex = -1;
                return;
            }
            IEditorPart[] editors = this.getEmbeddedEditors();
            int i = 0;
            while (i < editors.length) {
                if (editor == editors[i]) {
                    this.activeEditorIndex = i;
                    return;
                }
                ++i;
            }
        }

        void clearEditors() {
            this.setActiveEditor(null);
            this.editors.clear();
            this.editorsArrayCache = null;
        }
    }
}

