/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.jboss.riftsaw.runtime.module;

import org.eclipse.bpel.runtimes.module.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class RiftsawModuleDelegate
extends ProjectModule {
    private IFile file;

    public RiftsawModuleDelegate(IProject project, IFile file) {
        super(project);
        this.file = file;
    }

    public String getId() {
        return "jbt.bpel.module";
    }

    public String getName() {
        return this.file.getName();
    }

    public IFile getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public IModuleResource[] members() {
        IModuleResource[] result = new IModuleResource[]{new ModuleFile(this.file, this.file.getName(), (IPath)Path.EMPTY)};
        return result;
    }

    public IStatus validate() {
        super.validate();
        if (".bpel".equalsIgnoreCase(this.file.getFileExtension())) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.bpel.runtimes", 0, Messages.InvalidFileExtension, null);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RiftsawModuleDelegate)) {
            return false;
        }
        RiftsawModuleDelegate bmd = (RiftsawModuleDelegate)((Object)obj);
        if (this.getProject() != null && this.getProject().exists() && !this.getProject().equals((Object)bmd.getProject())) {
            return false;
        }
        if (this.file != null && this.file.exists() && !this.file.getFullPath().equals((Object)bmd.getFile().getFullPath())) {
            return false;
        }
        return this.getId() == null || this.getId().equals(bmd.getId());
    }

    public int hashCode() {
        return this.file == null ? 0 : this.file.getFullPath().toOSString().length();
    }
}

