/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.ui.editmodel.IEditModelListener;
import org.eclipse.bpel.common.ui.editmodel.ResourceInfo;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELEditDomain;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELModelReconcileAdapter;
import org.eclipse.bpel.ui.BPELTabbedPropertySheetPage;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.GraphicalBPELRootEditPart;
import org.eclipse.bpel.ui.IFileChangeListener;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.ModelListenerAdapter;
import org.eclipse.bpel.ui.ProcessContextMenuProvider;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.ProcessTrayEditPart;
import org.eclipse.bpel.ui.editparts.util.OutlineTreePartFactory;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.uiextensionmodel.StartNode;
import org.eclipse.bpel.ui.util.BPELEditModelClient;
import org.eclipse.bpel.ui.util.BPELEditorUtil;
import org.eclipse.bpel.ui.util.BPELReader;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabDescriptor;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyViewer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BPELMultipageEditorPart
extends MultiPageEditorPart
implements IEditModelListener,
IGotoMarker {
    private Process process;
    private DefaultEditDomain editDomain;
    protected ModelListenerAdapter modelListenerAdapter;
    private Resource extensionsResource;
    private ExtensionMap extensionMap;
    protected StructuredTextEditor fTextEditor = null;
    protected BPELEditor fDesignViewer = null;
    protected int currentPage = -1;
    protected TextEditorSelectionListener textEditorSelectionListener;
    protected DesignViewerSelectionListener designViewerSelectionListener;
    private IFileChangeListener fileChangeListener;
    protected IResourceChangeListener postBuildRefactoringListener;
    protected IResourceChangeListener preBuildRefactoringListener;
    BPELModelReconcileAdapter bpelModelReconcileAdapter;
    private OutlinePage outlinePage;
    protected BPELTabbedPropertySheetPage currentPropertySheetPage;
    protected ActionRegistry actionRegistry;
    private static int DESIGN_PAGE_INDEX = 0;
    private static int SOURCE_PAGE_INDEX = 1;
    private final Map<Long, EObject> fMarkers2EObject = new HashMap<Long, EObject>();
    private final Notification fMarkersStale = new NotificationImpl(2100, null, null);
    private IFile openFile;
    private static String filePrefix = new SimpleDateFormat("yyyyMMF_").format(new GregorianCalendar().getTime());

    public BPELMultipageEditorPart() {
        this.setEditDomain(new BPELEditDomain((IEditorPart)this));
    }

    protected void connectDesignPage() {
        this.designViewerSelectionListener = new DesignViewerSelectionListener();
        this.fDesignViewer.getAdaptingSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.designViewerSelectionListener);
        this.textEditorSelectionListener = new TextEditorSelectionListener();
        ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
        if (provider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.textEditorSelectionListener);
        } else {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.textEditorSelectionListener);
        }
    }

    protected void createDesignPage() {
        this.fDesignViewer = new BPELEditor(this.getEditDomain(), this);
        if (this.getFileInput() == null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.Editor_load_error_title, (String)Messages.Editor_load_error);
            return;
        }
        try {
            this.loadModel();
            this.addPage(0, (IEditorPart)this.fDesignViewer, this.getEditorInput());
            this.setPageText(0, "Design");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.Editor_design_page_error, null, (IStatus)e.getStatus());
        }
        catch (CoreException coreException) {}
    }

    protected IEditorSite createSite(IEditorPart page) {
        Object site = null;
        site = page == this.fTextEditor ? new MultiPageEditorSite(this, page){

            public String getId() {
                return "org.eclipse.bpel.contenttype";
            }
        } : super.createSite(page);
        return site;
    }

    protected void createSourcePage() throws PartInitException {
        this.fTextEditor = new StructuredTextEditor();
        try {
            this.addPage(0, (IEditorPart)this.fTextEditor, this.getEditorInput());
            this.setPageText(0, "Source");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating Source page", null, (IStatus)e.getStatus());
        }
    }

    protected void createPages() {
        try {
            this.createSourcePage();
            this.createDesignPage();
            this.firePropertyChange(1);
            this.connectDesignPage();
            this.initializeFileChangeListener();
            this.initializeRefactoringListener();
        }
        catch (PartInitException e) {
            throw new RuntimeException(e);
        }
        if (BPELUIPlugin.INSTANCE.getDefaultPage().equals("org.eclipse.bpel.ui.bpeleditor.sourcepage")) {
            this.setActivePage(SOURCE_PAGE_INDEX);
        } else {
            this.setActivePage(DESIGN_PAGE_INDEX);
        }
    }

    public void dispose() {
        IStructuredModel model;
        IWorkspace workspace;
        if (this.currentPage == SOURCE_PAGE_INDEX) {
            BPELUIPlugin.INSTANCE.setDefaultPage("org.eclipse.bpel.ui.bpeleditor.sourcepage");
        } else {
            BPELUIPlugin.INSTANCE.setDefaultPage("org.eclipse.bpel.ui.bpeleditor.designpage");
        }
        this.outlinePage = null;
        this.process = null;
        if (this.fileChangeListener != null) {
            BPELUIPlugin.INSTANCE.getResourceChangeListener().removeListener(this.fileChangeListener);
        }
        if (this.postBuildRefactoringListener != null) {
            workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener(this.postBuildRefactoringListener);
        }
        if (this.preBuildRefactoringListener != null) {
            workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener(this.preBuildRefactoringListener);
        }
        if ((model = this.fTextEditor.getModel()) != null) {
            model.releaseFromEdit();
            this.fDesignViewer.dispose();
            this.fTextEditor.dispose();
        }
        super.dispose();
    }

    public void doRevertToSaved(IProgressMonitor monitor) {
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.fDesignViewer.getCommandFramework().applyCurrentChange();
        this.fTextEditor.doSave(progressMonitor);
        this.fDesignViewer.getEditModelClient().getPrimaryResourceInfo().resetSynchronizeStamp();
        this.fDesignViewer.getEditModelClient().getPrimaryResourceInfo().getResource().setModified(false);
        this.fDesignViewer.doSave(progressMonitor);
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
    }

    protected BPELTabbedPropertySheetPage createBPELTabbedPropertySheetPage() {
        return new BPELTabbedPropertySheetPage(new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.eclipse.bpel.ui.bpeleditor";
            }
        }, this.fDesignViewer);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        if (type == Process.class) {
            return this.process;
        }
        if (type == BPELEditModelClient.class) {
            return this.process;
        }
        if (type == ModelListenerAdapter.class) {
            return this.modelListenerAdapter;
        }
        if (type == Resource.class) {
            return this.extensionsResource;
        }
        if (type == ExtensionMap.class) {
            return this.extensionMap;
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new OutlinePage((EditPartViewer)new TreeViewer());
            }
            return this.outlinePage;
        }
        if (type == IPropertySheetPage.class) {
            this.currentPropertySheetPage = this.createBPELTabbedPropertySheetPage();
            return this.currentPropertySheetPage;
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        return super.getAdapter(type);
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected int getDefaultPageTypeIndex() {
        int pageIndex = DESIGN_PAGE_INDEX;
        if (BPELUIPlugin.INSTANCE.getDefaultPage().equals("org.eclipse.bpel.ui.bpeleditor.sourcepage")) {
            pageIndex = SOURCE_PAGE_INDEX;
        }
        return pageIndex;
    }

    protected BPELEditor getDesignEditor() {
        return this.fDesignViewer;
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected IFile getFileInput() {
        block10: {
            if (this.openFile == null) {
                try {
                    if (this.getEditorInput() instanceof IFileEditorInput) {
                        this.openFile = ((IFileEditorInput)this.getEditorInput()).getFile();
                        break block10;
                    }
                    if (!(this.getEditorInput() instanceof FileStoreEditorInput)) break block10;
                    File f = new File(((FileStoreEditorInput)this.getEditorInput()).getURI());
                    Path path = new Path(f.getAbsolutePath());
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    IProject tempProject = ResourcesPlugin.getWorkspace().getRoot().getProject(".temp");
                    if (!tempProject.exists()) {
                        tempProject.create((IProgressMonitor)monitor);
                    }
                    if (!tempProject.isOpen()) {
                        tempProject.open((IProgressMonitor)monitor);
                    }
                    IResource[] iResourceArray = tempProject.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource res = iResourceArray[n2];
                        if (res.getName().substring(0, 7).compareTo(filePrefix) < 0) {
                            try {
                                res.delete(false, (IProgressMonitor)monitor);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    this.openFile = tempProject.getFile(String.valueOf(filePrefix) + path.lastSegment());
                    this.openFile.createLink((IPath)path, 0, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.openFile;
    }

    public Process getProcess() {
        return this.process;
    }

    protected StructuredTextEditor getSourceViewer() {
        return this.fTextEditor;
    }

    StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public void gotoMarker(IMarker marker) {
        String href = null;
        try {
            href = (String)marker.getAttribute("address.model");
        }
        catch (CoreException ex) {
            BPELUIPlugin.log(ex);
        }
        EObject modelObject = null;
        if (href != null) {
            try {
                modelObject = this.fDesignViewer.getResource().getEObject(href);
            }
            catch (Throwable t) {
                BPELUIPlugin.log(t);
            }
        }
        this.gotoText(marker);
        if (modelObject == null) {
            return;
        }
        this.gotoMarker(marker, modelObject);
    }

    private void gotoText(IMarker marker) {
        Integer charStart = null;
        Integer charEnd = null;
        try {
            charStart = (Integer)marker.getAttribute("charStart");
            charEnd = (Integer)marker.getAttribute("charEnd");
        }
        catch (CoreException ex) {
            BPELUIPlugin.log(ex);
        }
        charStart = charStart == null ? 0 : charStart;
        charEnd = charEnd == null ? charStart : charEnd;
        try {
            this.fTextEditor.setHighlightRange(charStart.intValue(), charEnd - charStart, true);
        }
        catch (Throwable t) {
            BPELUIPlugin.log(t);
        }
    }

    void gotoMarker(IMarker marker, EObject modelObject) {
        GraphicalViewer graphViewer = this.fDesignViewer.getGraphicalViewer();
        EObject refObj = null;
        EditPart editPart = null;
        if (modelObject instanceof Variable || modelObject instanceof PartnerLink || modelObject instanceof CorrelationSet || modelObject instanceof MessageExchange) {
            refObj = ModelHelper.getContainingScope(modelObject);
            editPart = (EditPart)graphViewer.getEditPartRegistry().get(refObj);
            if (editPart != null) {
                graphViewer.reveal(editPart);
            }
            this.fDesignViewer.selectModelObject(modelObject);
        } else if (modelObject instanceof Activity) {
            refObj = modelObject;
            editPart = (EditPart)graphViewer.getEditPartRegistry().get(refObj);
            if (editPart != null) {
                graphViewer.reveal(editPart);
            }
            this.fDesignViewer.selectModelObject(modelObject);
        } else {
            refObj = modelObject;
            while (refObj != null && !(refObj instanceof Activity)) {
                refObj = refObj.eContainer();
            }
            if (refObj == null) {
                refObj = BPELUtils.getProcess((Object)modelObject);
            }
            modelObject = refObj;
            editPart = (EditPart)graphViewer.getEditPartRegistry().get(modelObject);
            if (editPart != null) {
                graphViewer.reveal(editPart);
            }
            this.fDesignViewer.selectModelObject(modelObject);
        }
        BPELTabbedPropertySheetPage propertySheetPage = this.currentPropertySheetPage;
        if (propertySheetPage == null) {
            return;
        }
        TabbedPropertyViewer viewer = propertySheetPage.getTabbedPropertyViewer();
        int j = 0;
        block3: while (true) {
            TabDescriptor descriptor = null;
            try {
                descriptor = (TabDescriptor)viewer.getElementAt(j++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            if (descriptor == null) break;
            TabContents tab = descriptor.createTab();
            ISection[] sections = tab.getSections();
            int i = 0;
            while (true) {
                if (i >= sections.length) continue block3;
                if (BPELPropertySection.class.isInstance(sections[i])) {
                    BPELPropertySection section = (BPELPropertySection)sections[i];
                    section.createControls(new Composite((Composite)this.getSite().getShell(), 0), propertySheetPage);
                    section.setInput((IWorkbenchPart)this, (ISelection)new StructuredSelection((Object)modelObject));
                    if (section.isValidMarker(marker)) {
                        this.showPropertiesView();
                        viewer = this.currentPropertySheetPage.getTabbedPropertyViewer();
                        viewer.setSelection((ISelection)new StructuredSelection((Object)descriptor));
                        tab = this.currentPropertySheetPage.getCurrentTab();
                        section = (BPELPropertySection)tab.getSectionAtIndex(i);
                        section.gotoMarker(marker);
                        return;
                    }
                }
                ++i;
            }
            break;
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPartName(input.getName());
    }

    protected void initializeFileChangeListener() {
        this.fileChangeListener = new IFileChangeListener(){

            @Override
            public void deleted(IFile file) {
                IFile current = ((IFileEditorInput)BPELMultipageEditorPart.this.getEditorInput()).getFile();
                if (current.equals((Object)file)) {
                    Display display = BPELMultipageEditorPart.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BPELMultipageEditorPart.this.getSite().getPage().closeEditor((IEditorPart)BPELMultipageEditorPart.this, false);
                        }
                    });
                }
            }

            @Override
            public void moved(IFile source, IFile destination) {
            }
        };
        BPELUIPlugin.INSTANCE.getResourceChangeListener().addListener(this.fileChangeListener);
    }

    protected void initializeRefactoringListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.postBuildRefactoringListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IFile newFile = ((FileEditorInput)BPELMultipageEditorPart.this.getEditorInput()).getFile();
                IResourceDelta bpelFileDelta = event.getDelta().findMember(newFile.getFullPath());
                if (bpelFileDelta != null && (bpelFileDelta.getFlags() & 0x1000) != 0) {
                    BPELMultipageEditorPart.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            BPELMultipageEditorPart.this.doRevertToSaved(null);
                        }
                    });
                }
            }
        };
        workspace.addResourceChangeListener(this.postBuildRefactoringListener, 16);
        this.preBuildRefactoringListener = new RefactoringListener();
        workspace.addResourceChangeListener(this.preBuildRefactoringListener, 8);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void loadModel() throws CoreException {
        String msg;
        Shell shell;
        boolean keepGoing;
        BPELEditModelClient editModelClient;
        IFile file;
        IDOMDocument structuredDocument;
        block19: {
            structuredDocument = null;
            try {
                IDocument doc = this.fTextEditor.getDocumentProvider().getDocument((Object)this.getEditorInput());
                if (doc instanceof IStructuredDocument) {
                    IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
                    if (model == null) {
                        model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)doc);
                    }
                    if (model != null) {
                        structuredDocument = ((IDOMModel)model).getDocument();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, IDOMDocument> loadOptions = null;
            if (structuredDocument != null) {
                loadOptions = new HashMap<String, IDOMDocument>(1);
                loadOptions.put("DOMDocument", structuredDocument);
            }
            file = null;
            editModelClient = new BPELEditModelClient((IEditorPart)this);
            keepGoing = false;
            shell = this.getEditorSite().getShell();
            try {
                file = this.getFileInput();
                editModelClient.loadPrimaryResource(file, loadOptions);
            }
            catch (RuntimeException ex) {
                msg = NLS.bind((String)Messages.EditModelClient_bpel_load_error, (Object[])new String[]{file.toString()});
                keepGoing = MessageDialog.openQuestion((Shell)shell, (String)Messages.EditModelClient_load_error_title, (String)msg);
                if (keepGoing) break block19;
                throw ex;
            }
        }
        try {
            editModelClient.loadExtensionsResource();
        }
        catch (RuntimeException ex) {
            file = editModelClient.getExtensionsFile();
            msg = NLS.bind((String)Messages.EditModelClient_bpelex_load_error, (Object[])new String[]{file.toString()});
            keepGoing = MessageDialog.openQuestion((Shell)shell, (String)Messages.EditModelClient_load_error_title, (String)msg);
            if (!keepGoing) {
                throw ex;
            }
            try {
                file.delete(true, null);
                editModelClient.loadExtensionsResource();
            }
            catch (CoreException ce) {
                MessageDialog.openError((Shell)shell, (String)Messages.EditModelClient_delete_error_title, (String)Messages.EditModelClient_delete_error_message);
                throw ce;
            }
        }
        try {
            editModelClient.loadArtifactsResource();
        }
        catch (RuntimeException ex) {
            file = editModelClient.getArtifactsFile();
            msg = NLS.bind((String)Messages.EditModelClient_wsdl_load_error, (Object[])new String[]{file.toString()});
            keepGoing = MessageDialog.openQuestion((Shell)shell, (String)Messages.EditModelClient_load_error_title, (String)msg);
            if (!keepGoing) {
                throw ex;
            }
            try {
                file.delete(true, null);
                editModelClient.loadArtifactsResource();
            }
            catch (CoreException ce) {
                MessageDialog.openError((Shell)shell, (String)Messages.EditModelClient_delete_error_title, (String)Messages.EditModelClient_delete_error_message);
                throw ce;
            }
        }
        this.fDesignViewer.setEditModelClient(editModelClient);
        this.getEditDomain().setCommandStack((CommandStack)editModelClient.getCommandStack());
        Resource bpelResource = editModelClient.getPrimaryResourceInfo().getResource();
        BPELReader reader = new BPELReader();
        reader.read(bpelResource, this.getFileInput(), this.fDesignViewer.getResourceSet());
        this.process = reader.getProcess();
        this.bpelModelReconcileAdapter = new BPELModelReconcileAdapter((Document)structuredDocument, this.process, bpelResource, this.fDesignViewer);
        if (this.getEditDomain() != null) {
            ((BPELEditDomain)this.getEditDomain()).setProcess(this.getProcess());
        }
        this.extensionsResource = reader.getExtensionsResource();
        this.extensionMap = reader.getExtensionMap();
        this.modelListenerAdapter = new ModelListenerAdapter();
        this.modelListenerAdapter.setExtensionMap(this.extensionMap);
        this.updateMarkersHard();
    }

    public void modelDeleted(ResourceInfo resourceInfo) {
        if (!this.isDirty()) {
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
    }

    public void modelDirtyStateChanged(ResourceInfo resourceInfo) {
        this.firePropertyChange(257);
    }

    public void modelLocationChanged(ResourceInfo resourceInfo, IFile movedToFile) {
    }

    public void modelReloaded(ResourceInfo resourceInfo) {
        Resource bpelResource = this.fDesignViewer.getEditModelClient().getPrimaryResourceInfo().getResource();
        IFile file = this.getFileInput();
        BPELReader reader = new BPELReader();
        reader.read(bpelResource, file, this.fDesignViewer.getResourceSet());
        this.process = reader.getProcess();
        if (this.getEditDomain() != null) {
            ((BPELEditDomain)this.getEditDomain()).setProcess(this.getProcess());
        }
        this.extensionMap = reader.getExtensionMap();
        this.modelListenerAdapter.setExtensionMap(this.fDesignViewer.getExtensionMap());
        this.fDesignViewer.getGraphicalViewer().setContents((Object)this.getProcess());
        ProcessTrayEditPart processTrayEditPart = (ProcessTrayEditPart)this.fDesignViewer.getTrayViewer().getContents();
        this.fDesignViewer.getGraphicalViewer().removeSelectionChangedListener(processTrayEditPart.getSelectionChangedListener());
        this.fDesignViewer.getTrayViewer().setContents((Object)this.getProcess());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BPELMultipageEditorPart.this.updateMarkersHard();
            }
        });
    }

    public void updateMarkers(EObject modelObject) {
        ArrayList<Long> removed = new ArrayList<Long>();
        for (Map.Entry<Long, EObject> e : this.fMarkers2EObject.entrySet()) {
            if (e.getValue() != modelObject) continue;
            removed.add(e.getKey());
        }
        for (Long key : removed) {
            this.fMarkers2EObject.remove(key);
        }
        modelObject.eNotify(this.fMarkersStale);
        TreeIterator iter = EcoreUtil.getAllContents((EObject)modelObject, (boolean)true);
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            BPELUtil.adapt((Object)obj, IMarkerHolder.class);
        }
        IMarker[] markers = null;
        IFile file = this.getFileInput();
        Resource resource = this.getProcess().eResource();
        try {
            markers = file.findMarkers(null, true, 0);
        }
        catch (CoreException ex) {
            BPELUIPlugin.log(ex);
            return;
        }
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IMarker m = iMarkerArray[n2];
                String href = null;
                EObject target = null;
                try {
                    href = (String)m.getAttribute("address.model");
                    if (href == null) break block10;
                    target = resource.getEObject(href);
                }
                catch (CoreException coreException) {
                    break block10;
                }
                if (target == modelObject) {
                    this.fMarkers2EObject.put(m.getId(), target);
                    EObject obj = target;
                    while (obj != null) {
                        BPELUtil.adapt((Object)obj, IMarkerHolder.class);
                        obj = obj.eContainer();
                    }
                    target.eNotify((Notification)new NotificationImpl(2102, null, (Object)m));
                }
            }
            ++n2;
        }
    }

    protected void updateMarkersHard() {
        for (EObject obj : this.fMarkers2EObject.values()) {
            obj.eNotify(this.fMarkersStale);
        }
        this.fMarkers2EObject.clear();
        IMarker[] markers = null;
        IFile file = this.getFileInput();
        Resource resource = this.getProcess().eResource();
        try {
            markers = file.findMarkers(null, true, 0);
        }
        catch (CoreException ex) {
            BPELUIPlugin.log(ex);
            return;
        }
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IMarker m = iMarkerArray[n2];
                String href = null;
                EObject target = null;
                try {
                    href = (String)m.getAttribute("address.model");
                    if (href == null) break block8;
                    target = resource.getEObject(href);
                }
                catch (CoreException coreException) {
                    break block8;
                }
                if (target != null) {
                    this.fMarkers2EObject.put(m.getId(), target);
                    EObject obj = target;
                    while (obj != null) {
                        BPELUtil.adapt((Object)obj, IMarkerHolder.class);
                        obj = obj.eContainer();
                    }
                    target.eNotify((Notification)new NotificationImpl(2102, null, (Object)m));
                }
            }
            ++n2;
        }
    }

    protected void pageChange(int newPageIndex) {
        this.currentPage = newPageIndex;
        super.pageChange(newPageIndex);
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        this.editDomain = ed;
    }

    protected void showPropertiesView() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.eclipse.ui.views.PropertySheet");
        }
        catch (PartInitException e) {
            BPELUIPlugin.log(e);
        }
    }

    protected void updateTitle() {
        this.setPartName(this.getProcess().getName());
    }

    public void modelMarkersChanged(ResourceInfo resourceInfo, IMarkerDelta[] markerDelta) {
        Resource resource = resourceInfo.getResource();
        IMarkerDelta[] iMarkerDeltaArray = markerDelta;
        int n = markerDelta.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            String href = (String)delta.getAttribute("address.model");
            if (href != null) {
                EObject target = null;
                switch (delta.getKind()) {
                    case 1: {
                        target = resource.getEObject(href);
                        if (target == null) break;
                        this.fMarkers2EObject.put(delta.getId(), target);
                        target.eNotify((Notification)new NotificationImpl(2102, null, (Object)delta.getMarker()));
                        break;
                    }
                    case 4: {
                        target = this.fMarkers2EObject.remove(delta.getId());
                        if (target == null) break;
                        target.eNotify((Notification)new NotificationImpl(2101, (Object)delta.getMarker(), null));
                        break;
                    }
                    case 2: {
                        target = this.fMarkers2EObject.remove(delta.getId());
                        if (target == null) break;
                        target.eNotify((Notification)new NotificationImpl(2103, (Object)delta.getMarker(), null));
                    }
                }
            }
            ++n2;
        }
    }

    public boolean isDirty() {
        return this.fTextEditor.isDirty() || this.editDomain.getCommandStack().isDirty();
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    protected class DesignViewerSelectionListener
    implements ISelectionChangedListener {
        protected DesignViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (BPELMultipageEditorPart.this.getActivePage() != SOURCE_PAGE_INDEX) {
                try {
                    ISelection sel = BPELMultipageEditorPart.this.fDesignViewer.getSelection();
                    Object selectedNode = ((IStructuredSelection)sel).getFirstElement();
                    Element selectedNodeElement = null;
                    if (selectedNode instanceof StartNode) {
                        selectedNodeElement = ((StartNode)selectedNode).getProcess().getElement();
                    } else if (selectedNode instanceof BPELExtensibleElement) {
                        selectedNodeElement = ((BPELExtensibleElement)selectedNode).getElement();
                    }
                    if (selectedNodeElement != null) {
                        if (selectedNodeElement instanceof IDOMNode && ((IDOMNode)selectedNodeElement).getModel().isModelStateChanging()) {
                            return;
                        }
                        StructuredSelection nodeSelection = new StructuredSelection((Object)selectedNodeElement);
                        BPELMultipageEditorPart.this.getTextEditor().getSelectionProvider().setSelection((ISelection)nodeSelection);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class OutlinePage
    extends ContentOutlinePage {
        private PageBook pageBook;
        private Control outline;
        private Canvas overview;
        private IAction showOutlineAction;
        private IAction showOverviewAction;
        static final int ID_OUTLINE = 0;
        static final int ID_OVERVIEW = 1;
        private Thumbnail thumbnail;

        public OutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public EditPartViewer getViewer() {
            return super.getViewer();
        }

        private void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)BPELMultipageEditorPart.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new OutlineTreePartFactory());
            BPELMultipageEditorPart.this.fDesignViewer.registerViewer(this.getViewer());
            ProcessContextMenuProvider provider = new ProcessContextMenuProvider(BPELMultipageEditorPart.this.getDesignEditor(), BPELMultipageEditorPart.this.fDesignViewer.getActionRegistry());
            this.getViewer().setContextMenu((MenuManager)provider);
            this.getSite().registerContextMenu("org.eclipse.bpel.outline.contextmenu", (MenuManager)provider, this.getSite().getSelectionProvider());
            this.getViewer().setKeyHandler(BPELMultipageEditorPart.this.fDesignViewer.getKeyHandler());
            IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
            this.showOutlineAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(0);
                }

                public String getToolTipText() {
                    return Messages.OutlinePage_showOutlineView;
                }
            };
            this.showOutlineAction.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("elcl16/outline.gif"));
            tbm.add(this.showOutlineAction);
            this.showOverviewAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(1);
                }

                public String getToolTipText() {
                    return Messages.OutlinePage_showOverviewView;
                }
            };
            this.showOverviewAction.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("elcl16/overview.gif"));
            tbm.add(this.showOverviewAction);
            this.showPage(0);
        }

        public Control getControl() {
            return this.pageBook;
        }

        public void createControl(Composite parent) {
            this.pageBook = new PageBook(parent, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.getViewer().setContents((Object)BPELMultipageEditorPart.this.getProcess());
        }

        private void initializeOverview() {
            LightweightSystem lws = new LightweightSystem(this.overview);
            RootEditPart rep = BPELMultipageEditorPart.this.fDesignViewer.getGraphicalViewer().getRootEditPart();
            if (rep instanceof GraphicalBPELRootEditPart) {
                GraphicalBPELRootEditPart root = (GraphicalBPELRootEditPart)rep;
                this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
                this.thumbnail.setSource(root.getLayer("Printable Layers"));
                lws.setContents((IFigure)this.thumbnail);
            }
        }

        private void showPage(int id) {
            if (id == 0) {
                this.showOutlineAction.setChecked(true);
                this.showOverviewAction.setChecked(false);
                this.pageBook.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
            } else if (id == 1) {
                this.initializeOverview();
                this.showOutlineAction.setChecked(false);
                this.showOverviewAction.setChecked(true);
                this.pageBook.showPage((Control)this.overview);
                this.thumbnail.setVisible(true);
            }
        }

        public void dispose() {
            super.dispose();
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = BPELMultipageEditorPart.this.fDesignViewer.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REVERT.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }
    }

    public class RefactoringListener
    implements IResourceChangeListener {
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDeltaVisitor dv = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IPath newPath = delta.getMovedToPath();
                    if (delta.getKind() == 2 && newPath != null) {
                        EList imports = BPELMultipageEditorPart.this.process.getImports();
                        for (Import imp : imports) {
                            Path path = new Path(imp.getLocation());
                            IPath folder = ((IFileEditorInput)BPELMultipageEditorPart.this.getEditorInput()).getFile().getFullPath().removeLastSegments(1);
                            if (!path.isAbsolute()) {
                                path = folder.append((IPath)path);
                            }
                            if (!path.equals((Object)delta.getResource().getFullPath())) continue;
                            IPath relPath = newPath.makeRelativeTo(folder);
                            imp.setLocation(relPath.toString());
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BPELMultipageEditorPart.this.doSave(null);
                                }
                            });
                        }
                    }
                    return true;
                }
            };
            try {
                event.getDelta().accept(dv);
            }
            catch (CoreException e) {
                BPELUIPlugin.log(e);
            }
        }
    }

    protected class TextEditorSelectionListener
    implements ISelectionChangedListener {
        protected TextEditorSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (BPELMultipageEditorPart.this.getActivePage() != DESIGN_PAGE_INDEX && (selection = event.getSelection()) instanceof IStructuredSelection) {
                ArrayList<Object> selections = new ArrayList<Object>();
                for (Object domNode : (IStructuredSelection)selection) {
                    Object facade;
                    if (!(domNode instanceof Element) || (facade = BPELEditorUtil.getInstance().findModelObjectForElement(BPELMultipageEditorPart.this.process, (Element)domNode)) == null) continue;
                    selections.add(facade);
                }
                if (!selections.isEmpty()) {
                    StructuredSelection bpelSelection = new StructuredSelection(selections);
                    BPELMultipageEditorPart.this.fDesignViewer.getAdaptingSelectionProvider().setSelection((ISelection)bpelSelection);
                }
            }
        }
    }
}

