/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Policy;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class AddLinkCommand
extends AutoUndoCommand {
    protected Flow flow;
    protected Activity source;
    protected Activity target;
    protected Link link;
    protected Command setNameCmd;
    protected boolean addNewObjectMode = false;

    public void setAddNewObjectMode(boolean addNewObjectMode) {
        this.addNewObjectMode = addNewObjectMode;
    }

    public AddLinkCommand(Command setNameCmd, EObject modelRoot) {
        super(IBPELUIConstants.CMD_ADD_LINK, modelRoot);
        this.setNameCmd = setNameCmd;
    }

    @Override
    public boolean canDoExecute() {
        if (this.link == null || this.source == null || this.target == null) {
            return false;
        }
        if (this.source == this.target) {
            return false;
        }
        return FlowLinkUtil.getCommonFlow(this.source, this.target) != null || this.addNewObjectMode;
    }

    @Override
    public void doExecute() {
        Flow oldParent;
        if (this.setNameCmd != null && !this.setNameCmd.canExecute()) {
            this.setNameCmd = null;
        }
        this.flow = FlowLinkUtil.getCommonFlow(this.source, this.target);
        if (this.flow == null) {
            if (Policy.DEBUG) {
                System.out.println("No common flow found!!");
            }
            return;
        }
        if (this.setNameCmd != null) {
            this.setNameCmd.execute();
        }
        FlowLinkUtil.setLinkSource(this.link, this.source);
        FlowLinkUtil.setLinkTarget(this.link, this.target);
        if (this.link.eContainer() != null && (oldParent = (Flow)this.link.eContainer().eContainer()) != null) {
            FlowLinkUtil.removeFlowLink(oldParent, this.link);
        }
        FlowLinkUtil.addFlowLink(this.flow, this.link);
    }

    public Link getLink() {
        return this.link;
    }

    public void setSource(Activity source) {
        this.source = source;
    }

    public void setTarget(Activity target) {
        this.target = target;
    }

    public void setLink(Link link) {
        this.link = link;
    }
}

