/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.model.Else;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.ElseIfEditPart;
import org.eclipse.bpel.ui.editparts.PickEditPart;
import org.eclipse.bpel.ui.editparts.borders.PickBorder;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;

public class IfEditPart
extends PickEditPart {
    private IfNodeEditPart ifEditPart;

    @Override
    public void activate() {
        super.activate();
        this.getIfNodeEditPart().activate();
    }

    @Override
    public void deactivate() {
        this.getIfNodeEditPart().deactivate();
        super.deactivate();
    }

    @Override
    public void refreshVisuals() {
        this.getIfNodeEditPart().refreshVisuals();
        super.refreshVisuals();
    }

    private void createIfNode() {
        this.ifEditPart = new IfNodeEditPart();
        this.ifEditPart.setModel(this.getModel());
        this.ifEditPart.setParent((EditPart)this);
        this.ifEditPart.createEditPolicies();
        this.ifEditPart.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BPELOrderedLayoutEditPolicy());
    }

    private IfNodeEditPart getIfNodeEditPart() {
        if (this.ifEditPart == null) {
            this.createIfNode();
        }
        return this.ifEditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof ElseIfEditPart) {
            Object childObject = childEditPart.getModel();
            if (childObject instanceof Else) {
                index = -1;
            } else if (childObject instanceof If) {
                index = 0;
            } else {
                If thisObject = (If)this.getModel();
                index = thisObject.getElseIf().indexOf(childObject) + 1;
            }
            super.addChildVisual(childEditPart, index);
        } else {
            this.getIfNodeEditPart().addChildVisual(childEditPart, index);
        }
    }

    @Override
    protected void configureExpandedFigure(IFigure figure) {
        super.configureExpandedFigure(figure);
        this.addChildVisual((EditPart)this.getIfNodeEditPart(), 0);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        if (ModelHelper.isHorizontalLayout(this.getModel())) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new IfOrderedHorizontalLayoutEditPolicy());
        } else {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new IfOrderedLayoutEditPolicy(null, null));
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof ElseIfEditPart) {
            super.removeChildVisual(childEditPart);
        } else {
            this.getIfNodeEditPart().removeChildVisual(childEditPart);
        }
    }

    @Override
    protected void unregisterVisuals() {
        this.getIfNodeEditPart().unregisterVisuals();
        super.unregisterVisuals();
    }

    @Override
    public void switchLayout(boolean horizontal) {
        this.removeEditPolicy("LayoutEditPolicy");
        IfOrderedLayoutEditPolicy newPolicy = null;
        newPolicy = horizontal ? new IfOrderedHorizontalLayoutEditPolicy() : new IfOrderedLayoutEditPolicy(null, null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)newPolicy);
        ((FlowLayout)this.contentFigure.getLayoutManager()).setHorizontal(!horizontal);
        ((PickBorder)this.contentFigure.getBorder()).setHorizontal(horizontal);
        this.getIfNodeEditPart().switchLayout(horizontal);
    }

    private class IfNodeEditPart
    extends ElseIfEditPart {
        private IfNodeEditPart() {
        }

        public List getChildren() {
            ArrayList<EditPart> children = new ArrayList<EditPart>();
            for (EditPart child : this.getParent().getChildren()) {
                if (child instanceof ElseIfEditPart) continue;
                children.add(child);
            }
            return children;
        }

        @Override
        protected void handleModelChanged() {
        }

        @Override
        protected void refreshChildren() {
        }

        protected void addChildVisual(EditPart childEditPart, int index) {
            super.addChildVisual(childEditPart, index);
        }

        protected void removeChildVisual(EditPart childEditPart) {
            super.removeChildVisual(childEditPart);
        }
    }

    private class IfOrderedHorizontalLayoutEditPolicy
    extends IfOrderedLayoutEditPolicy {
        private IfOrderedHorizontalLayoutEditPolicy() {
        }

        @Override
        public void refreshConnections() {
            this.clearConnections();
            if (!this.isCollapsed()) {
                this.polyLineConnectionList = this.createHorizontalConnections((BPELEditPart)this.getHost());
                this.polyLineConnectionList.addAll(this.createVerticalConnections(IfEditPart.this.getIfNodeEditPart()));
            }
        }

        protected ArrayList createVerticalConnections(BPELEditPart parent) {
            ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
            List children = this.getConnectionChildren(parent);
            CenteredConnectionAnchor sourceAnchor = null;
            ConnectionAnchor targetAnchor = null;
            Label nameLabel = ((IfNodeEditPart)parent).nameLabel;
            sourceAnchor = new CenteredConnectionAnchor((IFigure)nameLabel, 3, 0);
            int i = 0;
            while (i < children.size()) {
                BPELEditPart targetPart;
                if (i == 0) {
                    targetPart = (BPELEditPart)children.get(0);
                    targetAnchor = targetPart.getConnectionAnchor(2);
                }
                if (i < children.size() - 1) {
                    BPELEditPart sourcePart = (BPELEditPart)children.get(i);
                    sourceAnchor = sourcePart.getConnectionAnchor(3);
                    targetPart = (BPELEditPart)children.get(i + 1);
                    targetAnchor = targetPart.getConnectionAnchor(2);
                }
                if (sourceAnchor != null && targetAnchor != null) {
                    connections.add(this.createConnection((ConnectionAnchor)sourceAnchor, targetAnchor, this.arrowColor));
                }
                ++i;
            }
            return connections;
        }

        protected ArrayList createHorizontalConnections(BPELEditPart parent) {
            ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
            List children = this.getConnectionChildren(parent);
            BPELEditPart sourcePart = parent;
            ConnectionAnchor sourceAnchor = sourcePart.getConnectionAnchor(2);
            if (children != null) {
                int i = 0;
                while (i < children.size()) {
                    BPELEditPart targetPart = (BPELEditPart)children.get(i);
                    ConnectionAnchor targetAnchor = targetPart.getConnectionAnchor(2);
                    connections.add(this.createConnection(sourceAnchor, targetAnchor, this.arrowColor));
                    ++i;
                }
            }
            return connections;
        }
    }

    private class IfOrderedLayoutEditPolicy
    extends BPELOrderedLayoutEditPolicy {
        private IfOrderedLayoutEditPolicy() {
        }

        @Override
        public void refreshConnections() {
            this.clearConnections();
            if (!this.isCollapsed()) {
                this.polyLineConnectionList = this.createHorizontalConnections((BPELEditPart)this.getHost());
                this.polyLineConnectionList.addAll(this.createVerticalConnections(IfEditPart.this.getIfNodeEditPart()));
            }
        }

        protected void eraseLayoutTargetFeedback(Request request) {
            EditPolicy policy = IfEditPart.this.ifEditPart.getEditPolicy("LayoutEditPolicy");
            policy.eraseTargetFeedback(request);
        }

        protected List getConnectionChildren(BPELEditPart editPart) {
            List children = IfEditPart.this.getChildren();
            ArrayList<Object> newChildren = new ArrayList<Object>();
            if (editPart instanceof ElseIfEditPart) {
                for (EditPart child : children) {
                    if (child instanceof ElseIfEditPart) continue;
                    newChildren.add(child);
                }
            } else {
                for (EditPart child : children) {
                    if (!(child instanceof ElseIfEditPart)) continue;
                    newChildren.add(child);
                }
                newChildren.add(IfEditPart.this.getIfNodeEditPart());
            }
            return newChildren;
        }

        @Override
        public int getFeedbackIndexFor(Request request) {
            EditPolicy policy = IfEditPart.this.ifEditPart.getEditPolicy("LayoutEditPolicy");
            return ((BPELOrderedLayoutEditPolicy)policy).getFeedbackIndexFor(request);
        }

        @Override
        protected void showLayoutTargetFeedback(Request request) {
            EditPolicy policy = IfEditPart.this.ifEditPart.getEditPolicy("LayoutEditPolicy");
            policy.showTargetFeedback(request);
        }

        /* synthetic */ IfOrderedLayoutEditPolicy(IfOrderedLayoutEditPolicy ifOrderedLayoutEditPolicy, IfOrderedLayoutEditPolicy ifOrderedLayoutEditPolicy2) {
            this();
        }
    }
}

