/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.bpel.ui.properties.DateTimeSelector;

public class BPELDateTimeHelpers {
    protected static final int YEAR = 0;
    protected static final int MONTH = 1;
    protected static final int DAY = 2;
    protected static final int HOUR = 3;
    protected static final int MINUTE = 4;
    protected static final int SECOND = 5;
    protected static final String[] dateTimeFormats = new String[]{"yyyy", "MM", "dd", "HH", "mm", "ss"};
    protected static String dateTimeFormat = "yyyy-MM-ddTHH:mm:ss";
    public static final int yearMin = 2002;
    public static final int yearMax = Calendar.getInstance().get(1) + 5;

    protected static int numZeroes(String s, int start) {
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) != '0') break;
            ++i;
        }
        return i - start;
    }

    protected static int numDigits(String s, int start) {
        int i = start;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') break;
            ++i;
        }
        return i - start;
    }

    protected static int fQuotient(int a, int b) {
        return (int)Math.floor((double)a / (double)b);
    }

    protected static int modulo(int a, int b) {
        return a - BPELDateTimeHelpers.fQuotient(a, b) * b;
    }

    protected static int fQuotient3(int a, int low, int high) {
        return BPELDateTimeHelpers.fQuotient(a - low, high - low);
    }

    protected static int modulo3(int a, int low, int high) {
        return BPELDateTimeHelpers.modulo(a - low, high - low) + low;
    }

    protected static int maximumDayInMonthFor(int yearValue, int monthValue) {
        int month = BPELDateTimeHelpers.modulo3(monthValue, 1, 13);
        int year = yearValue + BPELDateTimeHelpers.fQuotient3(monthValue, 1, 13);
        return DateTimeSelector.daysInMonth(month - 1, year);
    }

    public static int[] dateTimePlusDuration(int[] dateTime, int[] duration) {
        int[] result = new int[6];
        int temp = dateTime[1] + duration[1];
        result[1] = BPELDateTimeHelpers.modulo3(temp, 1, 13);
        int carry = BPELDateTimeHelpers.fQuotient3(temp, 1, 13);
        result[0] = dateTime[0] + duration[0] + carry;
        temp = dateTime[5] + duration[5];
        result[5] = BPELDateTimeHelpers.modulo(temp, 60);
        carry = BPELDateTimeHelpers.fQuotient(temp, 60);
        temp = dateTime[4] + duration[4] + carry;
        result[4] = BPELDateTimeHelpers.modulo(temp, 60);
        carry = BPELDateTimeHelpers.fQuotient(temp, 60);
        temp = dateTime[3] + duration[3] + carry;
        result[3] = BPELDateTimeHelpers.modulo(temp, 24);
        carry = BPELDateTimeHelpers.fQuotient(temp, 24);
        int tempDays = dateTime[2] > BPELDateTimeHelpers.maximumDayInMonthFor(result[0], result[1]) ? BPELDateTimeHelpers.maximumDayInMonthFor(result[0], result[1]) : (dateTime[2] < 1 ? 1 : dateTime[2]);
        result[2] = tempDays + duration[2] + carry;
        while (true) {
            if (result[2] < 1) {
                result[2] = result[2] + BPELDateTimeHelpers.maximumDayInMonthFor(result[0], result[1] - 1);
                carry = -1;
            } else {
                if (result[2] <= BPELDateTimeHelpers.maximumDayInMonthFor(result[0], result[1])) break;
                result[2] = result[2] - BPELDateTimeHelpers.maximumDayInMonthFor(result[0], result[1]);
                carry = 1;
            }
            temp = result[1] + carry;
            result[1] = BPELDateTimeHelpers.modulo3(temp, 1, 13);
            result[0] = result[0] + BPELDateTimeHelpers.fQuotient3(temp, 1, 13);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] parseXPathDateTime(String xpath, boolean isValidFrom) {
        int[] v = new int[6];
        if (xpath == null) {
            return null;
        }
        String s = BPELDateTimeHelpers.removeLiteralQuotes(xpath);
        if (s == null && !isValidFrom) {
            return null;
        }
        if (s != null) {
            xpath = s;
        }
        if (xpath.length() < 19) {
            return null;
        }
        int i = BPELDateTimeHelpers.numDigits(xpath, 0);
        if (i < 4) {
            return null;
        }
        int j = BPELDateTimeHelpers.numZeroes(xpath, 0);
        if (i > 4 && j > 0) {
            return null;
        }
        if (j > 3) {
            return null;
        }
        if (xpath.length() < 15 + i) {
            return null;
        }
        try {
            v[0] = Integer.parseInt(xpath.substring(j, i));
            if (v[0] < 2002) return null;
            if (v[0] > yearMax) {
                return null;
            }
            if (xpath.charAt(i++) != '-') {
                return null;
            }
            if (BPELDateTimeHelpers.numDigits(xpath, i) != 2) {
                return null;
            }
            v[1] = Integer.parseInt(xpath.substring(i, i + 2));
            i += 2;
            if (v[1] < 1) return null;
            if (v[1] > 12) {
                return null;
            }
            if (xpath.charAt(i++) != '-') {
                return null;
            }
            if (BPELDateTimeHelpers.numDigits(xpath, i) != 2) {
                return null;
            }
            v[2] = Integer.parseInt(xpath.substring(i, i + 2));
            i += 2;
            if (v[2] < 1) return null;
            if (v[2] > DateTimeSelector.daysInMonth(v[1] - 1, v[0])) {
                return null;
            }
            if (xpath.charAt(i++) != 'T') {
                return null;
            }
            if (BPELDateTimeHelpers.numDigits(xpath, i) != 2) {
                return null;
            }
            v[3] = Integer.parseInt(xpath.substring(i, i + 2));
            i += 2;
            if (v[3] < 0) return null;
            if (v[3] > 23) {
                return null;
            }
            if (xpath.charAt(i++) != ':') {
                return null;
            }
            if (BPELDateTimeHelpers.numDigits(xpath, i) != 2) {
                return null;
            }
            v[4] = Integer.parseInt(xpath.substring(i, i + 2));
            i += 2;
            if (v[4] < 0) return null;
            if (v[4] > 59) {
                return null;
            }
            if (xpath.charAt(i++) != ':') {
                return null;
            }
            if (BPELDateTimeHelpers.numDigits(xpath, i) != 2) {
                return null;
            }
            v[5] = Integer.parseInt(xpath.substring(i, i + 2));
            i += 2;
            if (v[5] < 0) return null;
            if (v[5] > 59) {
                return null;
            }
            if (xpath.length() == i) {
                if (isValidFrom) {
                    return v;
                }
                BPELDateTimeHelpers.convertLocalToGMT(v);
                return v;
            }
            if (xpath.charAt(i) == '.') {
                ++i;
                i += BPELDateTimeHelpers.numDigits(xpath, i);
            }
            int[] delta = new int[6];
            boolean neg = false;
            switch (xpath.charAt(i++)) {
                case 'Z': {
                    if (xpath.length() != i) return null;
                    int[] nArray = v;
                    return nArray;
                }
                case '-': {
                    neg = true;
                }
                case '+': {
                    if (xpath.length() != i + 5) {
                        return null;
                    }
                    if (BPELDateTimeHelpers.numDigits(xpath, i) != 2) {
                        return null;
                    }
                    delta[3] = Integer.parseInt(xpath.substring(i, i + 2));
                    i += 2;
                    if (delta[3] < 0) return null;
                    if (delta[3] > 23) {
                        return null;
                    }
                    if (xpath.charAt(i++) != ':') {
                        return null;
                    }
                    if (BPELDateTimeHelpers.numDigits(xpath, i) != 2) {
                        return null;
                    }
                    delta[4] = Integer.parseInt(xpath.substring(i, i + 2));
                    i += 2;
                    if (delta[4] < 0) return null;
                    if (delta[4] <= 59) break;
                    return null;
                }
            }
            if (neg) {
                delta[3] = -delta[3];
            }
            if (xpath.length() != i) {
                return null;
            }
            if (!isValidFrom) return BPELDateTimeHelpers.dateTimePlusDuration(v, delta);
            return v;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static String removeLiteralQuotes(String s) {
        if (s.length() < 2) {
            return null;
        }
        if (!(s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'')) {
            return null;
        }
        return s.substring(1, s.length() - 1);
    }

    public static String createXPathDateTime(int[] dateTime, boolean isValidFrom) {
        StringBuffer result = new StringBuffer(dateTimeFormat);
        int i = 0;
        while (i < 6) {
            String s = String.valueOf(dateTime[i]);
            if (s.length() < (i == 0 ? 4 : 2)) {
                s = "0" + s;
            }
            BPELDateTimeHelpers.setValueToStringBuffer(dateTimeFormat, result, s, dateTimeFormats[i]);
            ++i;
        }
        if (isValidFrom) {
            return result.toString();
        }
        return "'" + result.toString() + "Z'";
    }

    public static int[] getCurrentLocalDateTime() {
        int[] dateTime = new int[6];
        GregorianCalendar local = new GregorianCalendar();
        dateTime[0] = local.get(1);
        dateTime[1] = local.get(2) + 1;
        dateTime[2] = local.get(5);
        dateTime[3] = local.get(11);
        dateTime[4] = local.get(12);
        dateTime[5] = local.get(13);
        return dateTime;
    }

    public static void convertLocalToGMT(int[] dateTime) {
        GregorianCalendar local = new GregorianCalendar();
        local.set(dateTime[0], dateTime[1], dateTime[2], dateTime[3], dateTime[4], dateTime[5]);
        GregorianCalendar GMTcal = new GregorianCalendar(TimeZone.getTimeZone("GMT+0"));
        GMTcal.setTime(local.getTime());
        dateTime[0] = GMTcal.get(1);
        dateTime[1] = GMTcal.get(2);
        dateTime[2] = GMTcal.get(5);
        dateTime[3] = GMTcal.get(11);
        dateTime[4] = GMTcal.get(12);
        dateTime[5] = GMTcal.get(13);
    }

    public static void convertGMTToLocal(int[] dateTime) {
        GregorianCalendar GMTcal = new GregorianCalendar(TimeZone.getTimeZone("GMT+0"));
        GMTcal.set(dateTime[0], dateTime[1], dateTime[2], dateTime[3], dateTime[4], dateTime[5]);
        GregorianCalendar local = new GregorianCalendar();
        local.setTime(GMTcal.getTime());
        dateTime[0] = local.get(1);
        dateTime[1] = local.get(2);
        dateTime[2] = local.get(5);
        dateTime[3] = local.get(11);
        dateTime[4] = local.get(12);
        dateTime[5] = local.get(13);
    }

    private static void setValueToStringBuffer(String format, StringBuffer dateBuffer, String value, String unit) {
        int beginIdx = format.indexOf(unit);
        if (beginIdx < 0) {
            return;
        }
        int endIdx = beginIdx + unit.length();
        dateBuffer.replace(beginIdx, endIdx, value);
    }

    public static int[] parseXPathDuration(String dtStr) {
        if (dtStr == null) {
            return null;
        }
        if ((dtStr = BPELDateTimeHelpers.removeLiteralQuotes(dtStr)) == null) {
            return null;
        }
        int pos = 0;
        if (dtStr.length() < 3) {
            return null;
        }
        if (dtStr.charAt(pos++) != 'P') {
            return null;
        }
        if (dtStr.endsWith("P") || dtStr.endsWith("T")) {
            return null;
        }
        int[] value = new int[6];
        StringBuffer digits = new StringBuffer();
        boolean timePart = false;
        int i = 0;
        while (i < 6) {
            if (pos == dtStr.length()) break;
            if (dtStr.charAt(pos) == 'T') {
                ++pos;
                if (timePart) {
                    return null;
                }
                timePart = true;
            }
            digits.setLength(0);
            while (Character.isDigit(dtStr.charAt(pos))) {
                digits.append(dtStr.charAt(pos++));
                if (pos < dtStr.length()) continue;
                return null;
            }
            switch (dtStr.charAt(pos++)) {
                case 'Y': {
                    if (timePart || i > 0) {
                        return null;
                    }
                    i = 0;
                    break;
                }
                case 'M': {
                    if (i > (timePart ? 4 : 1)) {
                        return null;
                    }
                    i = timePart ? 4 : 1;
                    break;
                }
                case 'D': {
                    if (timePart || i > 2) {
                        return null;
                    }
                    i = 2;
                    break;
                }
                case 'H': {
                    if (!timePart || i > 3) {
                        return null;
                    }
                    i = 3;
                    break;
                }
                case 'S': {
                    if (!timePart || i > 5) {
                        return null;
                    }
                    i = 5;
                    break;
                }
                default: {
                    return null;
                }
            }
            try {
                value[i] = Integer.parseInt(digits.toString());
                if (value[i] < 0) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++i;
        }
        return value;
    }

    public static String createXPathDuration(int[] duration) {
        String result = "P";
        String spec = "YMDHMS";
        boolean timePart = false;
        int i = 0;
        while (i < 6) {
            int nv = duration[i];
            if (nv > 0) {
                if (i >= 3 && !timePart) {
                    timePart = true;
                    result = String.valueOf(result) + "T";
                }
                result = String.valueOf(result) + nv;
                result = String.valueOf(result) + spec.charAt(i);
            }
            ++i;
        }
        return "P".equals(result) ? "'P0D'" : "'" + result + "'";
    }
}

