/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.xpath;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.IFactory;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.xpath.XPathValidator;

public class Factory
implements IFactory<Validator> {
    static final String PACKAGE_NAME = Factory.class.getPackage().getName();
    public static final IFactory<Validator> INSTANCE = new Factory();
    Logger mLogger = Logger.getLogger(this.getClass().getName());

    @Override
    public Validator create(QName qname) {
        String nsURI = qname.getNamespaceURI();
        if ("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(nsURI) || "http://www.w3.org/TR/1999/REC-xpath-19991116".equals(nsURI) || "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath2.0".equals(nsURI)) {
            Validator val = this.createValidator(qname.getLocalPart());
            if (val == null) {
                return new XPathValidator();
            }
            return val;
        }
        return null;
    }

    Validator createValidator(String nodeName) {
        Object obj;
        Class<?> clazz;
        String name = String.valueOf(Character.toUpperCase(nodeName.charAt(0))) + nodeName.substring(1);
        String validatorClass = String.valueOf(PACKAGE_NAME) + "." + name;
        try {
            clazz = Class.forName(validatorClass);
        }
        catch (ClassNotFoundException e) {
            this.mLogger.log(Level.FINE, "Validator not found in this factory {0}", e.getMessage());
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Exception ex) {
            this.mLogger.log(Level.WARNING, "Validator class cannot be created.", ex);
            return null;
        }
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        this.mLogger.log(Level.WARNING, "Object is {0} is not a validator", obj);
        return null;
    }
}

