/*******************************************************************************
 * Copyright (c) 2005, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.ui.expressions.IEditorConstants;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * Details section for the JoinCondition of an activity (a boolean expression).
 */
public class JoinConditionSection extends ExpressionSection {

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.bpel.ui.properties.ExpressionSection
	 * #getExpressionType()
	 */
	@Override
	protected String getExpressionType() {
		return IEditorConstants.ET_JOIN;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.bpel.ui.properties.ExpressionSection
	 * #getExpressionTarget()
	 */
	@Override
	protected EObject getExpressionTarget() {
		Activity activity = getModel();
		return activity.getTargets();
	}

	@Override
	protected void saveExpressionToModel() {

		if( this.modelUpdate.get())
			return;
		
		if (getExpressionTarget()==null) {
			Targets targets = BPELFactory.eINSTANCE.createTargets();
			Activity activity = getModel();
			activity.setTargets(targets);
		}
		super.saveExpressionToModel();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.bpel.ui.properties.ExpressionSection
	 * #getStructuralFeature(org.eclipse.emf.ecore.EObject)
	 */
	@Override
	protected EStructuralFeature getStructuralFeature (EObject object) {
		return object instanceof Activity ? BPELPackage.eINSTANCE.getTargets_JoinCondition() : null;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.bpel.ui.properties.BPELPropertySection
	 * #getMarkers(java.lang.Object)
	 */
	@Override
	protected IMarker[] getMarkers (Object input) {

		IMarker[] result = EMPTY_MARKERS;
		if( input instanceof Activity ) {
			Activity activity = (Activity) input;
			Targets targets = activity.getTargets();
			if( targets != null )
				result = super.getMarkers( targets.getJoinCondition());
		}

		return result;
	}

}
