/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.assist.FieldAssistAdapter;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.commands.AddMessageExchangeCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetMessageExchangeCommand;
import org.eclipse.bpel.ui.details.providers.MessageExchangeContentProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.proposal.providers.ModelContentProposalProvider;
import org.eclipse.bpel.ui.proposal.providers.RunnableProposal;
import org.eclipse.bpel.ui.proposal.providers.Separator;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.NameDialog;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MessageExchangeSection
extends BPELPropertySection {
    Composite parentComposite;
    private Label messExLabel;
    private Text messExName;
    private Button messExBrowseButton;
    private IControlContentAdapter fTextContentAdapter = new TextContentAdapter(){

        public void insertControlContents(Control control, String text, int cursorPosition) {
            if (text != null) {
                super.insertControlContents(control, text, cursorPosition);
            }
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            if (text != null) {
                super.setControlContents(control, text, cursorPosition);
            }
        }
    };

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                try {
                    if (ModelHelper.isMessageExchangeAffected(MessageExchangeSection.this.getInput(), n)) {
                        MessageExchangeSection.this.updateMessExWidgets();
                    }
                }
                catch (Exception e) {
                    BPELUIPlugin.log(e);
                }
            }
        }};
    }

    @Override
    protected void basicSetInput(EObject input) {
        super.basicSetInput(input);
        this.updateMessExWidgets();
    }

    protected void createMessExWidgets(Composite composite) {
        this.messExLabel = this.fWidgetFactory.createLabel(composite, Messages.MessageExchangeImplSection_1);
        this.messExName = this.fWidgetFactory.createText(composite, "", 0);
        this.messExBrowseButton = this.fWidgetFactory.createButton(composite, "", 132100);
        RunnableProposal proposal = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.MessageExchangeImplSection_Create_Global;
            }

            @Override
            public void run() {
                MessageExchangeSection.this.createMessageExchange((EObject)BPELUtils.getProcess(MessageExchangeSection.this.getInput()), null);
            }
        };
        RunnableProposal proposal2 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.MessageExchangeImplSection_Create_Local;
            }

            @Override
            public void run() {
                MessageExchangeSection.this.createMessageExchange(ModelHelper.getContainingScope(MessageExchangeSection.this.getInput()), null);
            }
        };
        RunnableProposal proposal3 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.MessageExchangeImplSection_Clear;
            }

            @Override
            public void run() {
                SetMessageExchangeCommand cmd = new SetMessageExchangeCommand((EObject)MessageExchangeSection.this.getInput(), null);
                cmd.setLabel(IBPELUIConstants.CMD_ADD_MESSAGEEXCHANGE);
                MessageExchangeSection.this.runCommand((Command)cmd);
            }
        };
        MessageExchangeContentProvider provider = new MessageExchangeContentProvider();
        ModelContentProposalProvider proposalProvider = new ModelContentProposalProvider(new ModelContentProposalProvider.ValueProvider(){

            @Override
            public Object value() {
                return MessageExchangeSection.this.getInput();
            }
        }, provider);
        proposalProvider.addProposalToEnd(new Separator());
        proposalProvider.addProposalToEnd(proposal);
        proposalProvider.addProposalToEnd(proposal2);
        proposalProvider.addProposalToEnd(proposal3);
        final FieldAssistAdapter contentAssist = new FieldAssistAdapter((Control)this.messExName, this.fTextContentAdapter, (IContentProposalProvider)proposalProvider, null, null, false);
        contentAssist.setLabelProvider((ILabelProvider)new ModelLabelProvider());
        contentAssist.setPopupSize(new Point(300, 100));
        contentAssist.setFilterStyle(3);
        contentAssist.setProposalAcceptanceStyle(2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal3);
        contentAssist.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal chosenProposal) {
                if (chosenProposal.getContent() == null) {
                    return;
                }
                MessageExchange me = null;
                try {
                    me = (MessageExchange)((Adapter)chosenProposal).getTarget();
                }
                catch (Throwable throwable) {
                    return;
                }
                SetMessageExchangeCommand cmd = new SetMessageExchangeCommand((EObject)MessageExchangeSection.this.getInput(), me);
                cmd.setLabel(IBPELUIConstants.CMD_ADD_MESSAGEEXCHANGE);
                MessageExchangeSection.this.runCommand((Command)cmd);
            }
        });
        this.messExBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                contentAssist.openProposals();
            }
        });
        this.messExName.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    MessageExchangeSection.this.findAndSetOrCreateMessageExchange(MessageExchangeSection.this.messExName.getText());
                }
            }
        });
        FlatFormData data = new FlatFormData();
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.messExName, 2, 128);
        data.bottom = new FlatFormAttachment((Control)this.messExName, -2, 1024);
        this.messExBrowseButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.messExLabel, 105));
        data.right = new FlatFormAttachment((Control)this.messExBrowseButton, 0);
        this.messExName.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.messExName, -5);
        data.top = new FlatFormAttachment((Control)this.messExName, 0, 0x1000000);
        this.messExLabel.setLayoutData((Object)data);
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.parentComposite = this.createFlatFormComposite(parent);
        this.createMessExWidgets(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_message_exchange");
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.messExName.setFocus();
    }

    void findAndSetOrCreateMessageExchange(String name) {
        name = name.trim();
        Object model = this.getInput();
        MessageExchange me = null;
        if (name.length() > 0 && (me = (MessageExchange)ModelHelper.findElementByName(ModelHelper.getContainingScope(model), name, MessageExchange.class)) == null) {
            this.createMessageExchange(ModelHelper.getContainingScope(model), name);
            return;
        }
        SetMessageExchangeCommand cmd = new SetMessageExchangeCommand((EObject)model, me);
        cmd.setLabel(IBPELUIConstants.CMD_ADD_MESSAGEEXCHANGE);
        this.runCommand((Command)cmd);
    }

    private void createMessageExchange(EObject ref, String name) {
        NameDialog nameDialog;
        MessageExchange me = BPELFactory.eINSTANCE.createMessageExchange();
        if (name == null) {
            name = "";
        }
        if ((nameDialog = new NameDialog(this.parentComposite.getShell(), Messages.MessageExchange_Create_Dialog_Title, Messages.MessageExchange_Create_Dialog_NameField_Label, name, BPELUtil.getNCNameValidator())).open() == 1) {
            return;
        }
        me.setName(nameDialog.getValue());
        CompoundCommand cmd = new CompoundCommand();
        cmd.add((Command)new AddMessageExchangeCommand(ref, me));
        cmd.add((Command)new SetMessageExchangeCommand((EObject)this.getInput(), me));
        cmd.setLabel(IBPELUIConstants.CMD_ADD_MESSAGEEXCHANGE);
        this.runCommand((Command)cmd);
    }

    private void updateMessExWidgets() {
        MessageExchange messEx = ModelHelper.getMessageExchange(this.getInput());
        if (messEx == null) {
            this.messExName.setText("");
        } else {
            ILabeledElement labeledElement = BPELUtil.adapt((Object)messEx, ILabeledElement.class);
            this.messExName.setText(labeledElement.getLabel(messEx));
        }
    }
}

