/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractStyledTextExpressionSection
extends BPELPropertySection {
    protected Composite fEditorArea;
    protected StyledText expressionText;
    protected Font boldFont;
    protected String title;
    protected Label titleLabel;
    protected EStructuralFeature fStructuralFeature;
    protected AtomicBoolean modelUpdate = new AtomicBoolean(false);

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        Expression e = this.getExprFromModel();
        if (e != null && this.fAdapters.length > 0) {
            this.fAdapters[0].addToObject((Notifier)e);
        }
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        this.modelUpdate.set(true);
        super.basicSetInput(newInput);
        this.fStructuralFeature = this.getStructuralFeature(newInput);
        Expression exp = this.getExprFromModel();
        Object o = exp != null ? exp.getBody() : null;
        String content = o == null ? "" : String.valueOf(o);
        this.expressionText.setText(content);
        this.expressionText.setSelection(content.length());
        this.expressionText.setFocus();
        this.modelUpdate.set(false);
    }

    protected EObject getExpressionTarget() {
        return this.getInput();
    }

    protected String getExpressionType() {
        return "any";
    }

    protected EStructuralFeature getStructuralFeature() {
        return this.fStructuralFeature;
    }

    protected abstract EStructuralFeature getStructuralFeature(EObject var1);

    protected Expression getExprFromModel() {
        Object o;
        Expression result = null;
        EObject target = this.getExpressionTarget();
        if (target != null && (o = target.eGet(this.getStructuralFeature())) instanceof Expression) {
            result = (Expression)o;
        }
        return result;
    }

    protected Expression getExpression4Target(Expression expression) {
        return expression;
    }

    protected boolean isBodyAffected(Notification n) {
        return n.getOldValue() instanceof Expression || n.getNewValue() instanceof Expression || n.getNotifier() instanceof Expression || n.getFeature() == this.getStructuralFeature();
    }

    @Override
    public final boolean isValidMarker(IMarker marker) {
        boolean result = false;
        try {
            String context = (String)marker.getAttribute("href.context");
            result = "name".equals(context);
        }
        catch (Exception exception) {}
        return result;
    }

    protected String getCommandLabel() {
        return IBPELUIConstants.CMD_EDIT_EXPRESSION;
    }

    @Override
    protected void createClient(Composite parent) {
        this.fEditorArea = this.getWidgetFactory().createComposite(parent);
        this.fEditorArea.setLayout((Layout)new GridLayout());
        if (this.title != null) {
            FontData[] fontData = parent.getDisplay().getSystemFont().getFontData();
            fontData[0].setStyle(1);
            this.boldFont = new Font((Device)parent.getDisplay(), fontData[0]);
            this.titleLabel = this.fWidgetFactory.createLabel(this.fEditorArea, this.title);
            this.titleLabel.setFont(this.boldFont);
        }
        this.getWidgetFactory().createLabel(this.fEditorArea, this.getStyledTextLabelString());
        this.expressionText = this.createStyledText(this.fEditorArea);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractStyledTextExpressionSection.this.saveExpressionToModel();
            }
        });
    }

    protected void saveExpressionToModel() {
        if (this.modelUpdate.get()) {
            return;
        }
        CompoundCommand result = new CompoundCommand();
        Condition exp = BPELFactory.eINSTANCE.createCondition();
        exp.setBody((Object)(this.expressionText != null ? this.expressionText.getText().trim() : ""));
        exp.setExpressionLanguage(this.getExpressionLanguage());
        result.add((Command)new SetCommand(this.getExpressionTarget(), this.getExpression4Target((Expression)exp), this.getStructuralFeature()));
        this.getCommandFramework().execute((Command)result);
    }

    @Override
    public void dispose() {
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
        super.dispose();
    }

    protected abstract StyledText createStyledText(Composite var1);

    protected abstract String getStyledTextLabelString();

    protected abstract String getExpressionLanguage();
}

