/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.xpath10;

import org.eclipse.bpel.xpath10.Expr;

public class BinaryExpr
extends Expr {
    String fOperator;
    Expr fLHS;
    Expr fRHS;

    public BinaryExpr(String op, Expr lhs, Expr rhs) {
        super("");
        this.fOperator = op;
        this.fLHS = lhs;
        this.fRHS = rhs;
    }

    public String getOperator() {
        return this.fOperator;
    }

    public Expr getLHS() {
        return this.fLHS;
    }

    public Expr getRHS() {
        return this.fRHS;
    }

    @Override
    protected String asText() {
        StringBuilder sb = new StringBuilder();
        if (this.isWrapParen()) {
            sb.append("(");
        }
        sb.append(this.fLHS != null ? this.fLHS.getText() : "?");
        sb.append(" ");
        sb.append(this.getOperator());
        sb.append(" ");
        sb.append(this.fRHS != null ? this.fRHS.getText() : "?");
        if (this.isWrapParen()) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    protected String asString() {
        StringBuilder sb = new StringBuilder();
        if (this.isWrapParen()) {
            sb.append("(");
        }
        sb.append(this.getLHS()).append(" ").append(this.getOperator()).append(" ").append(this.getRHS());
        if (this.isWrapParen()) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public int getPosition() {
        return this.getLHS().getPosition();
    }

    @Override
    public int getEndPosition() {
        return this.getRHS().getEndPosition();
    }
}

