/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.xpath10;

import java.util.List;
import org.eclipse.bpel.xpath10.AllNodeStep;
import org.eclipse.bpel.xpath10.BinaryExpr;
import org.eclipse.bpel.xpath10.CommentNodeStep;
import org.eclipse.bpel.xpath10.FilterExpr;
import org.eclipse.bpel.xpath10.FunctionCallExpr;
import org.eclipse.bpel.xpath10.LiteralExpr;
import org.eclipse.bpel.xpath10.LocationPath;
import org.eclipse.bpel.xpath10.NameStep;
import org.eclipse.bpel.xpath10.NumberExpr;
import org.eclipse.bpel.xpath10.PathExpr;
import org.eclipse.bpel.xpath10.Predicate;
import org.eclipse.bpel.xpath10.ProcessingInstructionNodeStep;
import org.eclipse.bpel.xpath10.TextNodeStep;
import org.eclipse.bpel.xpath10.UnaryExpr;
import org.eclipse.bpel.xpath10.UnionExpr;
import org.eclipse.bpel.xpath10.VariableReferenceExpr;

public class Visitor {
    protected void visit(PathExpr expr) {
        this.visit(expr.getFilterExpr());
        this.visit(expr.getLocationPath());
    }

    protected void visit(LocationPath expr) {
        this.visitList(expr.getSteps());
    }

    protected void visit(FilterExpr expr) {
        this.visit(expr.getExpr());
        this.visitList(expr.getPredicates());
    }

    protected void visit(BinaryExpr expr) {
        this.visit(expr.getLHS());
        this.visit(expr.getRHS());
    }

    protected void visit(UnaryExpr expr) {
        this.visit(expr.getExpr());
    }

    protected void visit(UnionExpr expr) {
        this.visit(expr.getLHS());
        this.visit(expr.getRHS());
    }

    protected void visit(NumberExpr expr) {
    }

    protected void visit(LiteralExpr expr) {
    }

    protected void visit(VariableReferenceExpr expr) {
    }

    protected void visit(FunctionCallExpr expr) {
        this.visitList(expr.getParameters());
    }

    protected void visit(NameStep step) {
        this.visitList(step.getPredicates());
    }

    protected void visit(ProcessingInstructionNodeStep step) {
        this.visitList(step.getPredicates());
    }

    protected void visit(AllNodeStep step) {
        this.visitList(step.getPredicates());
    }

    protected void visit(TextNodeStep step) {
        this.visitList(step.getPredicates());
    }

    protected void visit(CommentNodeStep step) {
        this.visitList(step.getPredicates());
    }

    protected void visit(Predicate predicate) {
        this.visit(predicate.getExpr());
    }

    void visitList(List<?> list) {
        for (Object next : list) {
            this.visit(next);
        }
    }

    public void visit(Object obj) {
        if (obj instanceof PathExpr) {
            this.visit((PathExpr)obj);
        } else if (obj instanceof LocationPath) {
            this.visit((LocationPath)obj);
        } else if (obj instanceof BinaryExpr) {
            this.visit((BinaryExpr)obj);
        } else if (obj instanceof FilterExpr) {
            this.visit((FilterExpr)obj);
        } else if (obj instanceof UnaryExpr) {
            this.visit((UnaryExpr)obj);
        } else if (obj instanceof NumberExpr) {
            this.visit((NumberExpr)obj);
        } else if (obj instanceof LiteralExpr) {
            this.visit((LiteralExpr)obj);
        } else if (obj instanceof VariableReferenceExpr) {
            this.visit((VariableReferenceExpr)obj);
        } else if (obj instanceof FunctionCallExpr) {
            this.visit((FunctionCallExpr)obj);
        } else if (obj instanceof List) {
            this.visitList((List)obj);
        } else if (obj instanceof NameStep) {
            this.visit((NameStep)obj);
        } else if (obj instanceof ProcessingInstructionNodeStep) {
            this.visit((ProcessingInstructionNodeStep)obj);
        } else if (obj instanceof AllNodeStep) {
            this.visit((AllNodeStep)obj);
        } else if (obj instanceof TextNodeStep) {
            this.visit((TextNodeStep)obj);
        } else if (obj instanceof CommentNodeStep) {
            this.visit((CommentNodeStep)obj);
        } else if (obj instanceof Predicate) {
            this.visit((Predicate)obj);
        }
    }
}

