/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.bpel.common.ui.tray.AdaptingSelectionProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class BPELAdaptingSelectionProvider
extends AdaptingSelectionProvider {
    protected IStructuredSelection cachedEditPartSelection;

    public BPELAdaptingSelectionProvider(EditPartViewer viewer) {
        super(viewer);
    }

    public BPELAdaptingSelectionProvider() {
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.cachedSelection = this.calculateSelection((IStructuredSelection)selection);
        this.internalSetSelection(this.cachedSelection);
        this.cachedEditPartSelection = this.calculateEditPartSelection();
        this.fireSelectionChanged((ISelectionProvider)this, (ISelection)this.cachedSelection);
    }

    protected IStructuredSelection calculateEditPartSelection() {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        HashSet<Object> modelObjectSet = new HashSet<Object>();
        for (EditPartViewer v : this.viewers) {
            List viewerParts = v.getSelectedEditParts();
            for (EditPart ep : viewerParts) {
                Object model = ep.getModel();
                if (!modelObjectSet.add(model)) continue;
                result.add(ep);
            }
        }
        if (result.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(result);
    }

    public IStructuredSelection getEditPartSelection() {
        if (this.cachedEditPartSelection == null) {
            this.cachedEditPartSelection = this.calculateEditPartSelection();
        }
        return this.cachedEditPartSelection;
    }
}

