/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.util.List;
import org.eclipse.bpel.common.ui.tray.AddChildInTrayAction;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELMultipageEditorPart;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.actions.AbstractDeclarationAction;
import org.eclipse.bpel.ui.actions.BPELDuplicateAction;
import org.eclipse.bpel.ui.actions.EditPartContextAction;
import org.eclipse.bpel.ui.actions.ShowPaletteInPaletteViewAction;
import org.eclipse.bpel.ui.actions.editpart.IEditPartAction;
import org.eclipse.bpel.ui.adapters.IEditPartActionContributor;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.CorrelationSetsEditPart;
import org.eclipse.bpel.ui.editparts.MessageExchangesEditPart;
import org.eclipse.bpel.ui.editparts.PartnerLinksEditPart;
import org.eclipse.bpel.ui.editparts.ReferencePartnerLinksEditPart;
import org.eclipse.bpel.ui.editparts.VariablesEditPart;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class ProcessContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private ITextEditor textEditor;
    protected static final String EDITPART_ACTIONS = "org.eclipse.bpel.ui.EditPartActions";
    protected static final String FREQUENT_ACTIONS = "org.eclipse.bpel.ui.FrequentActions";
    protected static final String ADVANCED_ACTIONS = "additions";
    protected static final String LAYOUT_ACTIONS = "org.eclipse.bpel.ui.LayoutActions";
    protected static final String DEBUG_ACTIONS = "org.eclipse.bpel.ui.DebugActions";

    public ProcessContextMenuProvider(BPELEditor editor, ActionRegistry registry) {
        super((EditPartViewer)editor.getGraphicalViewer());
        this.actionRegistry = registry;
        this.textEditor = editor.getMultipageEditor().getTextEditor();
    }

    public void buildContextMenu(IMenuManager menu) {
        BPELEditPart p;
        Object model;
        IEditPartActionContributor contributor;
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.undo"));
        menu.add((IContributionItem)new Separator(EDITPART_ACTIONS));
        menu.add((IContributionItem)new Separator(FREQUENT_ACTIONS));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.copy"));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.edit"));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.rest"));
        menu.add((IContributionItem)new Separator(ADVANCED_ACTIONS));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.view"));
        menu.add((IContributionItem)new Separator(LAYOUT_ACTIONS));
        menu.add((IContributionItem)new Separator(DEBUG_ACTIONS));
        menu.add((IContributionItem)new Separator("group.showIn"));
        menu.appendToGroup("org.eclipse.gef.group.undo", this.textEditor.getAction(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("org.eclipse.gef.group.undo", this.textEditor.getAction(ITextEditorActionConstants.REDO));
        IAction action = this.actionRegistry.getAction((Object)ActionFactory.REVERT.getId());
        if (action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.undo", action);
        }
        menu.appendToGroup("org.eclipse.gef.group.copy", this.actionRegistry.getAction((Object)"BPELCutAction"));
        menu.appendToGroup("org.eclipse.gef.group.copy", this.actionRegistry.getAction((Object)"BPELCopyAction"));
        menu.appendToGroup("org.eclipse.gef.group.copy", this.actionRegistry.getAction((Object)"BPELPasteAction"));
        menu.appendToGroup("org.eclipse.gef.group.copy", this.actionRegistry.getAction((Object)BPELDuplicateAction.ACTION_ID));
        MenuManager addMenu = new MenuManager(Messages.ProcessContextMenuProvider_Add_1);
        List selected = this.getViewer().getSelectedEditParts();
        if (selected.size() == 1 && selected.get(0) instanceof BPELEditPart && (contributor = BPELUtil.adapt(model = (p = (BPELEditPart)selected.get(0)).getModel(), IEditPartActionContributor.class)) != null) {
            for (IEditPartAction iEditPartAction : contributor.getEditPartActions((EditPart)p)) {
                String s = iEditPartAction.getToolTip();
                ImageDescriptor imageDes = iEditPartAction.getIcon();
                if (s == null || imageDes == null) continue;
                EditPartContextAction conAction = new EditPartContextAction(null, (EditPart)p, iEditPartAction);
                if (iEditPartAction instanceof AbstractDeclarationAction) {
                    addMenu.add((IAction)conAction);
                    continue;
                }
                menu.appendToGroup(EDITPART_ACTIONS, (IAction)conAction);
            }
        }
        if (addMenu.getItems().length > 0) {
            addMenu.add((IContributionItem)new Separator());
        }
        MenuManager insertMenu = new MenuManager(Messages.ProcessContextMenuProvider_Insert_Before_2);
        BPELEditor bpelEditor = ((BPELMultipageEditorPart)((DefaultEditDomain)this.getViewer().getEditDomain()).getEditorPart()).getDesignEditor();
        for (IAction anAction : bpelEditor.getAppendNewActions()) {
            if (anAction == null) continue;
            if (anAction instanceof SelectionAction) {
                ((SelectionAction)anAction).update();
            }
            if (!anAction.isEnabled()) continue;
            addMenu.add(anAction);
        }
        for (IAction anAction : bpelEditor.getInsertNewActions()) {
            if (anAction == null) continue;
            if (anAction instanceof SelectionAction) {
                ((SelectionAction)anAction).update();
            }
            if (!anAction.isEnabled()) continue;
            insertMenu.add(anAction);
        }
        if (!addMenu.isEmpty()) {
            menu.appendToGroup(FREQUENT_ACTIONS, (IContributionItem)addMenu);
        }
        if (!insertMenu.isEmpty()) {
            menu.appendToGroup(FREQUENT_ACTIONS, (IContributionItem)insertMenu);
        }
        MenuManager changeTypeMenu = new MenuManager(Messages.ProcessContextMenuProvider_Change_Type_3);
        for (IAction iAction : bpelEditor.getChangeTypeActions()) {
            if (iAction == null || !iAction.isEnabled()) continue;
            changeTypeMenu.add(iAction);
        }
        menu.appendToGroup(FREQUENT_ACTIONS, (IContributionItem)changeTypeMenu);
        action = this.actionRegistry.getAction((Object)AddChildInTrayAction.calculateId(PartnerLinksEditPart.class));
        if (action != null && action.isEnabled()) {
            menu.appendToGroup(FREQUENT_ACTIONS, action);
        }
        if ((action = this.actionRegistry.getAction((Object)AddChildInTrayAction.calculateId(ReferencePartnerLinksEditPart.class))) != null && action.isEnabled()) {
            menu.appendToGroup(FREQUENT_ACTIONS, action);
        }
        if ((action = this.actionRegistry.getAction((Object)AddChildInTrayAction.calculateId(VariablesEditPart.class))) != null && action.isEnabled()) {
            menu.appendToGroup(FREQUENT_ACTIONS, action);
        }
        if ((action = this.actionRegistry.getAction((Object)AddChildInTrayAction.calculateId(CorrelationSetsEditPart.class))) != null && action.isEnabled()) {
            menu.appendToGroup(FREQUENT_ACTIONS, action);
        }
        if ((action = this.actionRegistry.getAction((Object)AddChildInTrayAction.calculateId(MessageExchangesEditPart.class))) != null && action.isEnabled()) {
            menu.appendToGroup(FREQUENT_ACTIONS, action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.bpel.ui.actions.MakePartner2WayAction")) != null && action.isEnabled()) {
            menu.appendToGroup(FREQUENT_ACTIONS, action);
        }
        menu.appendToGroup("org.eclipse.gef.group.edit", this.actionRegistry.getAction((Object)"BPELDeleteAction"));
        action = this.actionRegistry.getAction((Object)ActionFactory.RENAME.getId());
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        action = this.actionRegistry.getAction((Object)"org.eclipse.gef.zoom_in");
        IAction action2 = this.actionRegistry.getAction((Object)"org.eclipse.gef.zoom_out");
        if (action.isEnabled() || action2.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.view", action);
            menu.appendToGroup("org.eclipse.gef.group.view", action2);
        }
        if ((action = this.actionRegistry.getAction((Object)"ToggleAutoFlowLayout")) != null && action.isEnabled()) {
            menu.appendToGroup(LAYOUT_ACTIONS, action);
            action.setChecked(true);
        }
        if ((action = this.actionRegistry.getAction((Object)"AutoArrangeFlowsAction")) != null && action.isEnabled()) {
            menu.appendToGroup(LAYOUT_ACTIONS, action);
        }
        if ((action = this.actionRegistry.getAction((Object)"ToggleLayoutOrientationAction")) != null && action.isEnabled()) {
            menu.appendToGroup(LAYOUT_ACTIONS, action);
        }
        if ((action = this.actionRegistry.getAction((Object)"ToggleShowFaultHandler")) != null && action.isEnabled()) {
            menu.appendToGroup(LAYOUT_ACTIONS, action);
            action.setChecked(true);
        }
        if ((action = this.actionRegistry.getAction((Object)"ToggleShowCompensationHandler")) != null && action.isEnabled()) {
            menu.appendToGroup(LAYOUT_ACTIONS, action);
            action.setChecked(true);
        }
        if ((action = this.actionRegistry.getAction((Object)"ToggleShowTerminationHandler")) != null && action.isEnabled()) {
            menu.appendToGroup(LAYOUT_ACTIONS, action);
            action.setChecked(true);
        }
        if ((action = this.actionRegistry.getAction((Object)"ToggleShowEventHandler")) != null && action.isEnabled()) {
            menu.appendToGroup(LAYOUT_ACTIONS, action);
            action.setChecked(true);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.bpel.common.ui.actions.ShowPropertiesAction")) != null && action.isEnabled()) {
            menu.appendToGroup("group.showIn", action);
            action.setChecked(false);
        }
        if ((action = this.actionRegistry.getAction((Object)ShowPaletteInPaletteViewAction.ACTION_ID)) != null && action.isEnabled()) {
            menu.appendToGroup("group.showIn", action);
            action.setChecked(false);
        }
    }
}

