/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.xpath10;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpel.xpath10.Expr;
import org.eclipse.bpel.xpath10.Step;

public class LocationPath
extends Expr {
    List<Step> fSteps = new ArrayList<Step>();
    boolean fAbsolute = false;

    public LocationPath(boolean abs, Step ... steps) {
        super(null);
        this.fAbsolute = abs;
        Step[] stepArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            Step s = stepArray[n2];
            this.addStep(s);
            ++n2;
        }
    }

    public void addStep(Step s) {
        if (s != null) {
            this.fSteps.add(s);
        }
    }

    public void addFirstStep(Step s) {
        if (s != null) {
            this.fSteps.add(0, s);
        }
    }

    public List<Step> getSteps() {
        return this.fSteps;
    }

    public boolean isAbsolute() {
        return this.fAbsolute;
    }

    public void setIsAbsolute(boolean v) {
        this.fAbsolute = v;
    }

    @Override
    protected String asText() {
        StringBuilder buf = new StringBuilder();
        if (this.isAbsolute()) {
            buf.append("/");
        }
        Iterator<Step> stepIter = this.getSteps().iterator();
        while (stepIter.hasNext()) {
            buf.append(stepIter.next().getText());
            if (!stepIter.hasNext()) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append(this.getClass().getSimpleName());
        buf.append(",").append(this.isAbsolute()).append(",");
        Iterator<Step> stepIter = this.getSteps().iterator();
        while (stepIter.hasNext()) {
            buf.append(stepIter.next());
            if (!stepIter.hasNext()) continue;
            buf.append("/");
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public int getPosition() {
        return this.fSteps.size() > 0 ? this.fSteps.get(0).getPosition() : -1;
    }

    @Override
    public int getEndPosition() {
        int size = this.fSteps.size();
        return size > 0 ? this.fSteps.get(size - 1).getEndPosition() : -1;
    }
}

