/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import java.util.List;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.OutlineTreeEditPart;
import org.eclipse.bpel.ui.extensions.ActionDescriptor;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeTypeAction
extends SelectionAction {
    protected AbstractUIObjectFactory factory;

    public ChangeTypeAction(IWorkbenchPart editor, AbstractUIObjectFactory factory) {
        this(editor, factory, factory.getTypeLabel());
    }

    public ChangeTypeAction(IWorkbenchPart editor, AbstractUIObjectFactory factory, String label) {
        super(editor);
        this.factory = factory;
        this.setId(this.calculateID());
        this.setText(label);
        this.setToolTipText(NLS.bind((String)Messages.ChangeTypeAction_Change_type_to_1, (Object[])new Object[]{this.getText()}));
        this.setImageDescriptor(factory.getSmallImageDescriptor());
    }

    protected String calculateID() {
        return "changeType." + this.factory.getUniqueIdString();
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createReplaceInListCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    private Command createReplaceInListCommand(List list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() != 1) {
            return null;
        }
        if (!(list.get(0) instanceof BPELEditPart) && !(list.get(0) instanceof OutlineTreeEditPart)) {
            return null;
        }
        EditPart editPart = (EditPart)list.get(0);
        EClass editPartModelEClass = ((EObject)editPart.getModel()).eClass();
        if (editPartModelEClass == this.factory.getModelType()) {
            return null;
        }
        boolean isToTypeAnAction = BPELUtil.isBPELAction(this.factory.getModelType());
        boolean isFromTypeAnAction = BPELUtil.isBPELAction(editPartModelEClass);
        if (isFromTypeAnAction || isToTypeAnAction) {
            ActionDescriptor desc;
            if (isFromTypeAnAction && isToTypeAnAction && (desc = BPELUIRegistry.getInstance().getActionDescriptor(this.factory.getModelType())) != null) {
                Object parent = editPart.getParent().getModel();
                Object current = editPart.getModel();
                Object newType = this.factory.createInstance();
                return desc.getAction().getChangeActionTypeCommand(parent, current, newType);
            }
            return null;
        }
        CreateRequest request = new CreateRequest();
        request.setType((Object)"changeType");
        request.setFactory((CreationFactory)this.factory);
        return editPart.getCommand((Request)request);
    }

    public void run() {
        this.execute(this.createReplaceInListCommand(this.getSelectedObjects()));
    }
}

