/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.IFactory;
import org.eclipse.bpel.validator.model.Validator;

public class RuleFactory {
    public static final RuleFactory INSTANCE = new RuleFactory();
    List<IFactory<Validator>> fFactories = new ArrayList<IFactory<Validator>>(16);

    public Validator createValidator(QName qname) {
        Validator top = null;
        for (IFactory<Validator> factory : this.fFactories) {
            Validator next = factory.create(qname);
            if (next == null) continue;
            if (top == null) {
                top = next;
                continue;
            }
            top.attach(next);
        }
        return top;
    }

    public List<IFactory<Validator>> getFactories() {
        return this.fFactories;
    }

    public void registerFactory(IFactory<Validator> factory) {
        if (this.fFactories.contains(factory)) {
            return;
        }
        this.fFactories.add(factory);
    }
}

