/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.details.providers.ColumnTableProvider;
import org.eclipse.bpel.ui.dialogs.NamespaceMappingDialog;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.NamespacePrefixElement;
import org.eclipse.bpel.ui.properties.NamespacePrefixesProvider;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.TableCursor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class NamespacePrefixesSection
extends BPELPropertySection {
    protected Composite parentComposite;
    protected Composite activityComposite;
    protected Label tabLabel;
    protected Table prefixesTable;
    protected TableViewer prefixesViewer;
    protected ColumnTableProvider tableProvider;
    protected TableCursor tableCursor = null;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected void addAllAdapters() {
        Object obj;
        super.addAllAdapters();
        if (this.fAdapters.length > 0 && this.getModel() != null && (obj = this.getModel()) instanceof Process) {
            EList list = ((Process)obj).getImports();
            int i = 0;
            while (i < list.size()) {
                this.fAdapters[0].addToObject((Notifier)((Import)list.get(i)));
                ++i;
            }
        }
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                NamespacePrefixesSection.this.prefixesViewer.setInput(NamespacePrefixesSection.this.getInput());
            }
        }};
    }

    protected void createWidgets(Composite parent) {
        final Button assignPrefixButton = this.fWidgetFactory.createButton(parent, Messages.NamespacePrefixesSection_4, 8);
        assignPrefixButton.setEnabled(false);
        assignPrefixButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NamespacePrefixesSection.this.assignPrefix();
            }
        });
        FlatFormData data = new FlatFormData();
        data.right = new FlatFormAttachment(100, -25);
        data.top = new FlatFormAttachment(0, 4);
        assignPrefixButton.setLayoutData((Object)data);
        this.tabLabel = this.fWidgetFactory.createLabel(parent, Messages.NamespacePrefixesSection);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.top = new FlatFormAttachment((Control)assignPrefixButton, 4);
        this.tabLabel.setLayoutData((Object)data);
        this.prefixesTable = this.fWidgetFactory.createTable(parent, 66056);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(100, -25);
        data.top = new FlatFormAttachment((Control)this.tabLabel, 4);
        data.bottom = new FlatFormAttachment(100, -5);
        this.prefixesTable.setLayoutData((Object)data);
        this.prefixesTable.setLinesVisible(true);
        this.prefixesTable.setHeaderVisible(true);
        this.tableProvider = new ColumnTableProvider();
        this.tableProvider.add(new PrefixColumn());
        this.tableProvider.add(new NamespaceColumn());
        this.tableProvider.add(new ContextColumn());
        this.tableProvider.add(new LocationColumn());
        this.prefixesViewer = new TableViewer(this.prefixesTable);
        this.tableProvider.createTableLayout(this.prefixesTable);
        this.prefixesViewer.setLabelProvider((IBaseLabelProvider)this.tableProvider);
        this.prefixesViewer.setCellModifier((ICellModifier)this.tableProvider);
        this.prefixesViewer.setContentProvider((IContentProvider)new NamespacePrefixesProvider());
        this.prefixesViewer.setColumnProperties(this.tableProvider.getColumnProperties());
        this.prefixesViewer.setCellEditors(this.tableProvider.createCellEditors((Composite)this.prefixesTable));
        this.prefixesViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection sel = (StructuredSelection)event.getSelection();
                    NamespacePrefixElement elem = (NamespacePrefixElement)sel.getFirstElement();
                    if (elem != null && (elem.prefix == null || elem.prefix.length() == 0)) {
                        assignPrefixButton.setEnabled(true);
                    } else {
                        assignPrefixButton.setEnabled(false);
                    }
                }
            }
        });
        this.tableCursor = BPELUtil.createTableCursor(this.prefixesTable, this.prefixesViewer);
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        if (this.getInput() != null) {
            this.prefixesViewer.setInput(this.getInput());
        }
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.parentComposite = this.createFlatFormComposite(parent);
        this.createWidgets(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parentComposite, "org.eclipse.bpel.ui.property_namespace_prefix");
    }

    @Override
    public Object getUserContext() {
        return ((StructuredSelection)this.prefixesViewer.getSelection()).getFirstElement();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.prefixesTable.setFocus();
        if (userContext != null) {
            this.prefixesViewer.setSelection((ISelection)new StructuredSelection(userContext));
        }
    }

    void assignPrefix() {
        ISelection selection = this.prefixesViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IStructuredSelection ssel = null;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        ssel = (IStructuredSelection)selection;
        NamespacePrefixElement elem = (NamespacePrefixElement)ssel.getFirstElement();
        EObject modelObject = elem.context;
        if (modelObject == null) {
            modelObject = this.fModelObject;
        }
        NamespaceMappingDialog dialog = new NamespaceMappingDialog(this.tabLabel.getShell(), modelObject);
        dialog.setNamespace(elem.namespace);
        if (dialog.open() == 1) {
            return;
        }
        BPELUtils.setPrefix((EObject)modelObject, (String)elem.namespace, (String)dialog.getPrefix());
        elem.prefix = dialog.getPrefix();
        elem.context = modelObject;
        this.prefixesViewer.refresh();
    }

    @Override
    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        return super.isValidMarker(marker);
    }

    public class ContextColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.NamespacePrefixesSection_2;
        }

        @Override
        public String getProperty() {
            return "Context";
        }

        @Override
        public int getInitialWeight() {
            return 10;
        }

        public String getText(Object element) {
            String s = null;
            EObject obj = ((NamespacePrefixElement)element).context;
            if (obj instanceof Process) {
                s = "Process " + ((Process)obj).getName();
            } else if (obj instanceof Activity) {
                s = "Activity " + ((Activity)obj).getName();
            }
            return s == null ? "" : s;
        }
    }

    public class LocationColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.NamespacePrefixesSection_3;
        }

        @Override
        public String getProperty() {
            return "Location";
        }

        @Override
        public int getInitialWeight() {
            return 40;
        }

        public String getText(Object element) {
            String s = ((NamespacePrefixElement)element).location;
            return s == null ? "" : s;
        }
    }

    public class NamespaceColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.NamespacePrefixesSection_1;
        }

        @Override
        public String getProperty() {
            return "Namespace";
        }

        @Override
        public int getInitialWeight() {
            return 40;
        }

        public String getText(Object element) {
            String s = ((NamespacePrefixElement)element).namespace;
            return s == null ? "" : s;
        }
    }

    public class PrefixColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.NamespacePrefixesSection_0;
        }

        @Override
        public String getProperty() {
            return "NamespacePrefix";
        }

        @Override
        public int getInitialWeight() {
            return 10;
        }

        public String getText(Object element) {
            String s = ((NamespacePrefixElement)element).prefix;
            return s == null ? "" : s;
        }
    }
}

