/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.bpel.common.wsdl.importhelpers.WsdlImportHelper;
import org.eclipse.bpel.common.wsdl.parsers.WsdlParser;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypeFactory;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypePackage;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.resource.BPELResourceFactoryImpl;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Templates;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.bpel.ui.wizards.NewBpelFileFirstPage;
import org.eclipse.bpel.ui.wizards.NewBpelFilePortTypePage;
import org.eclipse.bpel.ui.wizards.NewBpelFileTemplatePage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.xml.sax.SAXException;

public class NewBpelFileWizardUtils {
    private final NewBpelFileFirstPage firstPage;
    private final NewBpelFileTemplatePage wsdlPage;
    private final NewBpelFilePortTypePage portTypePage;
    private final IFile targetFile;

    public NewBpelFileWizardUtils(NewBpelFileFirstPage firstPage, NewBpelFileTemplatePage wsdlPage, NewBpelFilePortTypePage portTypePage, IFile targetFile) {
        this.firstPage = firstPage;
        this.wsdlPage = wsdlPage;
        this.portTypePage = portTypePage;
        this.targetFile = targetFile;
    }

    public void createResourcesFromTemplate(IProgressMonitor monitor) throws CoreException {
        Map<String, Object> tplProperties = this.firstPage.getProcessTemplateProperties();
        tplProperties.putAll(this.wsdlPage.getProcessTemplateProperties());
        List<Templates.TemplateResource> tplResources = this.wsdlPage.getSelectedTemplate().getResources();
        monitor.subTask(Messages.BPELCreateOperation_0);
        for (Templates.TemplateResource tplResource : tplResources) {
            String result = tplResource.process(tplProperties);
            Path path = new Path(tplResource.getName(tplProperties));
            IFile targetFile = this.targetFile.getParent().getFile((IPath)path);
            if (targetFile.exists()) {
                targetFile.setContents((InputStream)new ByteArrayInputStream(result.getBytes()), true, true, monitor);
            } else {
                targetFile.create((InputStream)new ByteArrayInputStream(result.getBytes()), true, monitor);
            }
            monitor.worked(1);
        }
    }

    public void createResourcesFromWsdl(IProgressMonitor monitor) throws IOException, CoreException {
        monitor.subTask("Processing the original WSDL definition...");
        String newWsdlUrl = this.portTypePage.getWsdlUrl();
        if (this.portTypePage.isImportWsdl()) {
            File targetDirectory = this.targetFile.getParent().getLocation().toFile();
            try {
                Map uriToImportedFile = new WsdlImportHelper().importWsdlOrXsdAndDependencies(targetDirectory, new String[]{newWsdlUrl});
                File importedWsdlFile = (File)uriToImportedFile.get(newWsdlUrl);
                if (importedWsdlFile == null) {
                    throw new IOException("The WSDL file could not be found after import.");
                }
                newWsdlUrl = importedWsdlFile.getName();
            }
            catch (IllegalArgumentException e) {
                throw new IOException("The WSDL could not be imported in the project.", e);
            }
            catch (URISyntaxException e) {
                throw new IOException("The WSDL could not be imported in the project.", e);
            }
            catch (SAXException e) {
                throw new IOException("The WSDL could not be imported in the project.", e);
            }
            catch (ParserConfigurationException e) {
                throw new IOException("The WSDL could not be imported in the project.", e);
            }
        }
        monitor.worked(2);
        HashMap<String, Boolean> saveOptions = new HashMap<String, Boolean>();
        saveOptions.put("bpel.skip.auto.import", Boolean.TRUE);
        ResourceSet resourceSet = WsdlParser.createBasicResourceSetForWsdl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpel", new BPELResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://docs.oasis-open.org/wsbpel/2.0/plnktype", (Object)PartnerlinktypePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://docs.oasis-open.org/wsbpel/2.0/process/executable", (Object)BPELPackage.eINSTANCE);
        monitor.subTask("Generating the WSDL for the artifacts...");
        Definition artifactsDefinition = this.generateWsdlArtifacts(monitor, newWsdlUrl);
        IFile wsdlFile = this.targetFile.getParent().getFile((IPath)new Path(this.computeWsdlArtifactsName()));
        URI emfUri = URI.createPlatformResourceURI((String)wsdlFile.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(emfUri);
        resource.getContents().add((Object)artifactsDefinition);
        resource.save(saveOptions);
        monitor.worked(2);
        monitor.subTask("Generating the BPEL file...");
        Process bpelProcess = this.generateBpelProcess(monitor, artifactsDefinition, newWsdlUrl);
        emfUri = URI.createPlatformResourceURI((String)this.targetFile.getFullPath().toString(), (boolean)true);
        resource = resourceSet.createResource(emfUri);
        resource.getContents().add((Object)bpelProcess);
        resource.save(saveOptions);
        monitor.worked(2);
        if (this.firstPage.isAbstractProcess()) {
            java.net.URI fileUri = this.targetFile.getLocation().toFile().toURI();
            String newContent = WsdlImportHelper.readResourceContent((java.net.URI)fileUri);
            newContent = newContent.replace(BPELConstants.NAMESPACE, "http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
            ByteArrayInputStream is = new ByteArrayInputStream(newContent.getBytes());
            this.targetFile.setContents((InputStream)is, true, false, monitor);
            monitor.worked(2);
        }
    }

    private Definition generateWsdlArtifacts(IProgressMonitor monitor, String newWsdlUrl) {
        PortType portType = this.portTypePage.getPortType();
        Definition businessDefinition = (Definition)portType.eContainer();
        Definition artifactsDefinition = WSDLFactory.eINSTANCE.createDefinition();
        artifactsDefinition.setTargetNamespace(String.valueOf(businessDefinition.getTargetNamespace()) + "Artifacts");
        artifactsDefinition.getNamespaces().put("tns", businessDefinition.getTargetNamespace());
        org.eclipse.wst.wsdl.Import wsdlImport = WSDLFactory.eINSTANCE.createImport();
        wsdlImport.setLocationURI(newWsdlUrl);
        wsdlImport.setNamespaceURI(businessDefinition.getTargetNamespace());
        artifactsDefinition.addImport((Import)wsdlImport);
        PartnerLinkType plType = PartnerlinktypeFactory.eINSTANCE.createPartnerLinkType();
        plType.setName(String.valueOf(portType.getQName().getLocalPart()) + "PLT");
        Role plRole = PartnerlinktypeFactory.eINSTANCE.createRole();
        plRole.setName(String.valueOf(portType.getQName().getLocalPart()) + "Role");
        plRole.setPortType((Object)portType);
        plType.getRole().add((Object)plRole);
        artifactsDefinition.getEExtensibilityElements().add((Object)plType);
        plType.setEnclosingDefinition(artifactsDefinition);
        return artifactsDefinition;
    }

    private Process generateBpelProcess(IProgressMonitor monitor, Definition artifactsDefinition, String newWsdlUrl) {
        PortType portType = this.portTypePage.getPortType();
        Definition businessDefinition = (Definition)portType.eContainer();
        Process bpelProcess = BPELFactory.eINSTANCE.createProcess();
        bpelProcess.setName(this.targetFile.getName());
        bpelProcess.setTargetNamespace(businessDefinition.getTargetNamespace());
        bpelProcess.setPartnerLinks(BPELFactory.eINSTANCE.createPartnerLinks());
        bpelProcess.setVariables(BPELFactory.eINSTANCE.createVariables());
        org.eclipse.bpel.model.Import bpelImport = BPELFactory.eINSTANCE.createImport();
        bpelImport.setLocation(newWsdlUrl);
        bpelImport.setNamespace(businessDefinition.getTargetNamespace());
        bpelImport.setImportType("http://schemas.xmlsoap.org/wsdl/");
        bpelProcess.getImports().add((Object)bpelImport);
        bpelImport = BPELFactory.eINSTANCE.createImport();
        bpelImport.setLocation(this.computeWsdlArtifactsName());
        bpelImport.setNamespace(String.valueOf(businessDefinition.getTargetNamespace()) + "Artifacts");
        bpelImport.setImportType("http://schemas.xmlsoap.org/wsdl/");
        bpelProcess.getImports().add((Object)bpelImport);
        PartnerLink pl = BPELFactory.eINSTANCE.createPartnerLink();
        for (Object elt : artifactsDefinition.getEExtensibilityElements()) {
            if (!(elt instanceof PartnerLinkType)) continue;
            pl.setPartnerLinkType((PartnerLinkType)elt);
            pl.setName("bpelProcessPartner");
            pl.setMyRole((Role)((PartnerLinkType)elt).getRole().get(0));
            bpelProcess.getPartnerLinks().getChildren().add((Object)pl);
            break;
        }
        Sequence mainSequence = BPELFactory.eINSTANCE.createSequence();
        mainSequence.setName("MainSequence");
        bpelProcess.setActivity((Activity)mainSequence);
        Pick mainPick = BPELFactory.eINSTANCE.createPick();
        mainPick.setName("SwitchInvokedOperation");
        mainPick.setCreateInstance(Boolean.valueOf(true));
        mainSequence.getActivities().add((Object)mainPick);
        Collection definitions = WsdlParser.findAllWsdlDefinitions((Definition)businessDefinition);
        for (Object o : portType.getOperations()) {
            this.addOperationDerivedElements((Operation)o, bpelProcess, mainPick, pl, definitions);
        }
        return bpelProcess;
    }

    private void addOperationDerivedElements(Operation operation, Process bpelProcess, Pick mainPick, PartnerLink partnerLink, Collection<Definition> definitions) {
        String opName = BPELUtil.lowerCaseFirstLetter(operation.getName());
        Variable var = BPELFactory.eINSTANCE.createVariable();
        var.setName(String.valueOf(opName) + "Request");
        this.findAndSetVariableXmlType(var, operation.getEInput().getEMessage().getQName(), definitions);
        bpelProcess.getVariables().getChildren().add((Object)var);
        OnMessage onMessage = BPELFactory.eINSTANCE.createOnMessage();
        onMessage.setPartnerLink(partnerLink);
        onMessage.setVariable(var);
        onMessage.setOperation(operation);
        mainPick.getMessages().add((Object)onMessage);
        if (operation.getOutput() != null) {
            var = BPELFactory.eINSTANCE.createVariable();
            var.setName(String.valueOf(opName) + "Response");
            this.findAndSetVariableXmlType(var, operation.getEOutput().getEMessage().getQName(), definitions);
            bpelProcess.getVariables().getChildren().add((Object)var);
            Reply reply = BPELFactory.eINSTANCE.createReply();
            reply.setName("ReplyTo" + BPELUtil.upperCaseFirstLetter(opName));
            reply.setVariable(var);
            reply.setOperation(operation);
            reply.setPartnerLink(partnerLink);
            onMessage.setActivity((Activity)reply);
        } else {
            onMessage.setActivity((Activity)BPELFactory.eINSTANCE.createEmpty());
        }
        if (operation.getFaults() != null) {
            for (Object oo : operation.getFaults().values()) {
                Fault fault = (Fault)oo;
                var = BPELFactory.eINSTANCE.createVariable();
                var.setName(String.valueOf(opName) + fault.getName());
                this.findAndSetVariableXmlType(var, fault.getEMessage().getQName(), definitions);
                bpelProcess.getVariables().getChildren().add((Object)var);
            }
        }
    }

    private void findAndSetVariableXmlType(Variable variable, QName messageName, Collection<Definition> definitions) {
        boolean found = false;
        boolean processed = false;
        for (Definition def : definitions) {
            for (Object o : def.getEMessages()) {
                Message msg = (Message)o;
                if (!messageName.equals(msg.getQName())) continue;
                found = true;
                if (msg.getEParts().size() != 1) continue;
                processed = true;
                Part part = (Part)msg.getEParts().get(0);
                if (part.getTypeDefinition() != null) {
                    variable.setType(part.getTypeDefinition());
                    continue;
                }
                if (part.getElementDeclaration() == null) continue;
                variable.setXSDElement(part.getElementDeclaration());
            }
        }
        if (!found) {
            BPELUIPlugin.log(new Exception("The message " + messageName + " could not be found."), 4);
        } else if (!processed) {
            BPELUIPlugin.log(new Exception("The message " + messageName + " contains more than 1 part. This case is not supported."), 4);
        } else if (variable.getXSDElement() == null && variable.getType() == null) {
            BPELUIPlugin.log(new Exception("The XML type could not be set for the variable " + variable.getName() + ". Please, report a bug."), 4);
        }
    }

    private String computeWsdlArtifactsName() {
        Path path = new Path(this.targetFile.getName());
        return String.valueOf(path.removeFileExtension().toString()) + "Artifacts.wsdl";
    }
}

