/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class WhileValidator
extends CActivityValidator {
    protected String exprLanguage;
    protected INode conditionExpr;
    protected INode activity;

    @Override
    protected void start() {
        super.start();
        this.conditionExpr = this.mNode.getNode(ND_CONDITION);
        this.activity = mSelector.selectNode(this.mNode, "*", Filters.ACTIVITIES);
    }

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_CONDITION, 1, 1);
        this.checkChild(Filters.ACTIVITIES, 1, 1);
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Check if a condition is present on the while activity", date="10/2/2006", sa=1000, errors="BPELC_NO_EXPRESSION")
    public void rule_BasicSanityCheck_11() {
        if (this.conditionExpr == null) {
            IProblem problem = this.createError();
            problem.fill("BPELC_NO_EXPRESSION", AT_CONDITION, this.toString(this.mNode.nodeName()));
        }
    }
}

