/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import org.eclipse.bpel.common.ui.tray.TraySash;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TrayComposite
extends SashForm {
    private static final int DEFAULT_TRAY_WIDTH = 92;
    public static final int EVENT_COLLAPSED_STATE_CHANGED = 9999999;
    public static final int STATE_EXPANDED = 1;
    public static final int STATE_COLLAPSED = 2;
    public int marginHeight = 0;
    public int marginWidth = 0;
    protected Composite editorControl = new Composite((Composite)this, 0);
    protected TraySash sashControl;
    protected Control trayControl;
    protected int trayState;
    protected int trayWidth;

    public TrayComposite(Composite parent, int style) {
        super(parent, style | 0x100);
        this.editorControl.setLayout((Layout)new FillLayout());
        this.sashControl = new TraySash(this, (Composite)this, 512);
        this.setState(2);
        this.setTrayWidth(92);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TrayComposite.this.layout();
            }
        });
    }

    public Composite getEditorComposite() {
        return this.editorControl;
    }

    public void setTrayControl(Control trayControl) {
        Assert.isTrue((trayControl.getParent() == this ? 1 : 0) != 0);
        this.trayControl = trayControl;
    }

    protected boolean isInState(int state) {
        return (this.trayState & state) != 0;
    }

    public void setState(int trayState) {
        if (this.trayState != trayState) {
            this.trayState = trayState;
            Event event = new Event();
            event.type = 9999999;
            this.notifyListeners(9999999, event);
            this.layout();
        }
    }

    public void setTrayWidth(int width) {
        if (this.trayWidth != width) {
            this.trayWidth = width;
            this.layout();
        }
    }

    public void layout(boolean changed) {
        if (this.editorControl == null || this.editorControl.isDisposed() || this.trayControl == null || this.trayControl.isDisposed()) {
            return;
        }
        Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        this.setRedraw(false);
        if (this.isInState(2)) {
            int titleWidth = this.sashControl.computeSize((int)-1, (int)-1).x;
            this.editorControl.setBounds(area.x, area.y, area.width - titleWidth, area.height);
            this.sashControl.setBounds(area.x + area.width - titleWidth, area.y, titleWidth, area.height);
            this.trayControl.setVisible(false);
        } else if (this.isInState(1)) {
            int titleWidth = this.sashControl.computeSize((int)-1, (int)-1).x;
            if (changed) {
                int trayWeight;
                int editorWeight = area.width - titleWidth - this.trayWidth;
                int sashWeight = titleWidth >= 0 ? titleWidth : 0;
                int n = trayWeight = this.trayWidth >= 0 ? this.trayWidth : 0;
                if (editorWeight < 0) {
                    editorWeight = 0;
                }
                this.setWeights(new int[]{editorWeight, sashWeight, trayWeight});
            }
            this.editorControl.setBounds(area.x, area.y, area.width - titleWidth - this.trayWidth, area.height);
            this.sashControl.setBounds(area.x + area.width - titleWidth - this.trayWidth, area.y, titleWidth, area.height);
            this.trayControl.setBounds(area.x + area.width - this.trayWidth, area.y, this.trayWidth, area.height);
            this.trayControl.setVisible(true);
        }
        this.sashControl.layout(true);
        this.setRedraw(true);
        this.update();
    }

    public Rectangle getClientArea() {
        Rectangle rect = super.getClientArea();
        rect.x += this.marginWidth;
        rect.y += this.marginHeight;
        rect.width -= this.marginWidth * 2;
        rect.height -= this.marginHeight * 2;
        return rect;
    }

    public class ResizeListener
    extends MouseAdapter
    implements MouseMoveListener {
        protected boolean dragging = false;
        protected boolean correctState = false;
        protected int origX;

        public void mouseDown(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            this.dragging = true;
            this.correctState = TrayComposite.this.isInState(1);
            this.origX = me.x;
        }

        public void mouseMove(MouseEvent me) {
            if (this.dragging && this.correctState) {
                int shiftAmount = me.x - this.origX;
                int newWidth = TrayComposite.this.trayWidth - shiftAmount;
                Point minSize = TrayComposite.this.trayControl.computeSize(-1, -1);
                Point maxSize = TrayComposite.this.getSize();
                if (newWidth >= minSize.x && newWidth <= maxSize.x / 2) {
                    TrayComposite.this.setTrayWidth(newWidth);
                }
            }
        }

        public void mouseUp(MouseEvent me) {
            this.dragging = false;
            this.correctState = false;
        }
    }
}

