/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.IValue;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.rules.CValidator;

public class ToValidator
extends CValidator {
    static QName[] ENDPOINT_REFRENCE = new QName[]{AT_MY_ROLE, AT_PARTNER_ROLE};
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_COPY);
    protected INode fVariableNode;
    protected INode fQueryNode;
    protected INode fPartnerLinkNode;
    protected INode fPropertyNode;
    protected Validator fExprValidator;
    protected String fPropertyName;
    protected String fPartName;
    protected INode fMessageTypeNode;
    protected INode fPartNode;
    protected String fExpressionLanguage;

    @Override
    protected void start() {
        super.start();
        this.fVariableNode = this.mModelQuery.lookup(this.mNode, 1, this.mNode.getAttribute(AT_VARIABLE));
        this.fPartName = this.mNode.getAttribute(AT_PART);
        this.fQueryNode = this.mNode.getNode(ND_QUERY);
        this.fPartnerLinkNode = this.mModelQuery.lookup(this.mNode, 2, this.mNode.getAttribute(AT_PARTNER_LINK));
        this.fPropertyName = this.mNode.getAttribute(AT_PROPERTY);
        this.fExpressionLanguage = this.getLanguage(this.mNode, AT_EXPRESSIONLANGUAGE);
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the allowed formats of the <to> element", date="01/15/2007", sa=32, errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC_TO__VARIANT", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckToVariant_10() {
        int variant = 0;
        if (this.fVariableNode != null) {
            ++variant;
            if (!this.checkValidator(this.mNode, this.fVariableNode, AT_VARIABLE, 0) || !this.checkAttributeNode(this.mNode, this.fVariableNode, AT_VARIABLE, 0)) {
                this.disableRules();
            }
        }
        if (this.fPartnerLinkNode != null) {
            ++variant;
            if (!this.checkValidator(this.mNode, this.fPartnerLinkNode, AT_PARTNER_LINK, 0) || !this.checkAttributeNode(this.mNode, this.fPartnerLinkNode, AT_PARTNER_LINK, 0)) {
                this.disableRules();
            }
        }
        if (variant == 0) {
            ++variant;
        }
        if (variant == 0) {
            IProblem problem = this.createError();
            problem.fill("BPELC_TO__VARIANT", this.toString(this.mNode.nodeName()), variant);
            this.disableRules();
        } else if (variant > 1) {
            IProblem problem = this.createError();
            problem.fill("BPELC_TO__VARIANT", this.toString(this.mNode.nodeName()), variant);
            this.disableRules();
        }
    }

    @ARule(desc="Variables used in <to> must not have part set if they are schema types.  (part must not be set) ", author="michal.chmielewski@oracle.com", date="01/15/2007", sa=34, errors="BPELC_TO__VARIABLE_PART,BPELC__PA_NO_PART")
    public void rule_CheckVariableAndPartVariant_18() {
        if (this.isUndefined(this.fVariableNode) || this.isDefined(this.fPropertyNode)) {
            return;
        }
        INode varTypeNode = this.getValue(this.fVariableNode, "type", null);
        if (this.isUndefined(varTypeNode)) {
            return;
        }
        this.setValue("type", varTypeNode);
        if (!WSDL_ND_MESSAGE.equals(varTypeNode.nodeName())) {
            if (!ToValidator.isEmpty(this.fPartName)) {
                IProblem problem = this.createError();
                problem.fill("BPELC_TO__VARIABLE_PART", this.toString(this.mNode.nodeName()), AT_VARIABLE, this.fVariableNode.getAttribute(AT_NAME));
            }
        } else if (!ToValidator.isEmpty(this.fPartName)) {
            INode partNode = this.mModelQuery.lookup(varTypeNode, 13, this.fPartName);
            if (this.isUndefined(partNode)) {
                IProblem problem = this.createError();
                problem.fill("BPELC__PA_NO_PART", this.toString(this.mNode.nodeName()), this.fPartName, varTypeNode);
                return;
            }
            INode partType = this.mModelQuery.lookup(partNode, 16, this.fPartName);
            if (this.isDefined(partType)) {
                this.setValue("type", partType);
            }
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="<to> spec with partnerLink must have partnerRole set.", date="01/10/2007", sa=37, errors="BPELC_TO__PARTNER_LINK")
    public void rule_CheckPartnerLinkVariant_20() {
        if (this.isUndefined(this.fPartnerLinkNode)) {
            return;
        }
        String partnerRole = this.fPartnerLinkNode.getAttribute(AT_PARTNER_ROLE);
        if (ToValidator.isEmptyOrWhitespace(partnerRole)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_TO__PARTNER_LINK", this.toString(this.mNode.nodeName()), this.fPartnerLinkNode.getAttribute(AT_NAME), AT_PARTNER_ROLE);
        } else {
            INode portType = this.getValue(this.fPartnerLinkNode, "role.portType." + partnerRole, null);
            this.setValue("type", portType);
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Check variable reference expression as used in a <to> element.", date="01/10/2007", sa=33, warnings="BPELC__NO_EXPRESSION_VALIDATOR")
    public void rule_CheckExpressionVariant_50() {
        if (this.fVariableNode != null || this.fPropertyNode != null || this.fPartnerLinkNode != null || this.fPartName != null || this.fQueryNode != null) {
            return;
        }
        if (this.fExprValidator == null) {
            this.fExprValidator = this.createExpressionValidator(new QName(this.fExpressionLanguage, this.mNode.nodeName().getLocalPart()));
            if (this.fExprValidator == null) {
                return;
            }
            this.attach(this.fExprValidator);
        }
        this.setValue("type", new IValue<Object>(){

            @Override
            public Object get() {
                return ToValidator.this.fExprValidator.getValue("expression.type");
            }
        });
    }
}

