/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.bpel.ui.wizards.NewBpelFileFirstPage;
import org.eclipse.bpel.ui.wizards.NewBpelFileLocationPage;
import org.eclipse.bpel.ui.wizards.NewBpelFilePortTypePage;
import org.eclipse.bpel.ui.wizards.NewBpelFileTemplatePage;
import org.eclipse.bpel.ui.wizards.NewBpelFileWizardUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewBpelFileWizard
extends Wizard
implements INewWizard {
    static final String DIALOG_SETTINGS_PROCESS_NAME = "process-name";
    static final String DIALOG_SETTINGS_PROCESS_TPL_KEY = "process-template-key";
    private IStructuredSelection selection;
    private IWorkbench fWorkbench;
    private NewBpelFileFirstPage firstPage;
    private NewBpelFileLocationPage locationPage;
    private NewBpelFileTemplatePage wsdlPage;
    private NewBpelFilePortTypePage portTypePage;

    public NewBpelFileWizard() {
        this.setWindowTitle(Messages.NewFileWizard_1);
        this.setDialogSettings(BPELUIPlugin.INSTANCE.getDialogSettingsFor((Object)this));
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.fWorkbench = workbench;
        this.selection = currentSelection;
    }

    public void addPages() {
        this.firstPage = new NewBpelFileFirstPage();
        this.locationPage = new NewBpelFileLocationPage(this.selection);
        this.wsdlPage = new NewBpelFileTemplatePage();
        this.portTypePage = new NewBpelFilePortTypePage();
        this.addPage((IWizardPage)this.firstPage);
        this.addPage((IWizardPage)this.portTypePage);
        this.addPage((IWizardPage)this.wsdlPage);
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean canFinish() {
        boolean complete;
        boolean bl = complete = this.firstPage.isPageComplete() && this.locationPage.isPageComplete();
        if (complete) {
            complete = this.firstPage.getCreationMode() == NewBpelFileFirstPage.BpelCreationMode.CREATE_NEW_BPEL ? this.wsdlPage.isPageComplete() : this.portTypePage.isPageComplete();
        }
        return complete;
    }

    public boolean performFinish() {
        boolean success;
        IFile bpelFile;
        block16: {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("Creating the process...", -1);
                            NewBpelFileWizardUtils utils = new NewBpelFileWizardUtils(NewBpelFileWizard.this.firstPage, NewBpelFileWizard.this.wsdlPage, NewBpelFileWizard.this.portTypePage, NewBpelFileWizard.this.locationPage.getProcessFile());
                            if (NewBpelFileWizard.this.firstPage.getCreationMode() == NewBpelFileFirstPage.BpelCreationMode.GENERATE_BPEL_FROM_WSDL) {
                                utils.createResourcesFromWsdl(monitor);
                            } else {
                                utils.createResourcesFromTemplate(monitor);
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            bpelFile = this.locationPage.getProcessFile();
            success = true;
            try {
                this.getContainer().run(false, true, runnable);
            }
            catch (InvocationTargetException e) {
                success = true;
                BPELUIPlugin.log(e);
                try {
                    bpelFile.getProject().refreshLocal(2, null);
                }
                catch (CoreException e2) {
                    BPELUIPlugin.log(e2);
                }
                break block16;
            }
            catch (InterruptedException e) {
                try {
                    success = true;
                    BPELUIPlugin.log(e);
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        bpelFile.getProject().refreshLocal(2, null);
                    }
                    catch (CoreException e3) {
                        BPELUIPlugin.log(e3);
                    }
                }
            }
            try {
                bpelFile.getProject().refreshLocal(2, null);
            }
            catch (CoreException e) {
                BPELUIPlugin.log(e);
            }
        }
        if (success) {
            final IWorkbenchPage page = this.fWorkbench.getActiveWorkbenchWindow().getActivePage();
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)bpelFile);
                    }
                    catch (PartInitException e) {
                        BPELUIPlugin.log(e);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)bpelFile, (IWorkbenchWindow)page.getWorkbenchWindow());
        }
        return success;
    }
}

