/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.BPELPlugin;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.resource.BPELResourceSetImpl;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.ImportResolver;
import org.eclipse.bpel.model.util.XSDUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;

public class XSDImportResolver
implements ImportResolver {
    @Override
    public String getImportType() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    protected <T extends EObject> T findAndLoad(Import imp, String kind, Class<T> clazz) {
        Resource baseResource = imp.eResource();
        String location = imp.getLocation();
        if (baseResource == null) {
            return null;
        }
        if (!baseResource.getURI().isRelative()) {
            location = URI.createURI((String)location).resolve(baseResource.getURI()).toString();
        }
        URI locationURI = URI.createURI((String)location);
        BPELResourceSetImpl hackedResourceSet = BPELUtils.slightlyHackedResourceSet((EObject)imp);
        Resource result = null;
        try {
            result = hackedResourceSet.getResource(locationURI, true, kind);
        }
        catch (Throwable t) {
            BPELPlugin.log("Resource " + locationURI + " cannot be read.", t, 2);
            return null;
        }
        if (result.getContents().size() == 0) {
            BPELPlugin.log("Resource " + locationURI + " is empty.", null, 2);
            return null;
        }
        try {
            return (T)((EObject)clazz.cast(result.getContents().get(0)));
        }
        catch (Throwable t) {
            BPELPlugin.log("Resource " + locationURI + " is not of the expected kind.", t, 2);
            return null;
        }
    }

    @Override
    public EObject resolve(Import imp, QName qname, String name, String refType) {
        EObject result = null;
        if (!this.getImportType().equals(imp.getImportType())) {
            return result;
        }
        if (!XSDUtil.isSchemaType(refType) && !"top.element".equals(refType)) {
            return result;
        }
        if (imp.getLocation() == null) {
            return result;
        }
        XSDSchema schema = this.findAndLoad(imp, "xsd", XSDSchema.class);
        if ("top.element".equals(refType)) {
            return schema;
        }
        result = XSDUtil.resolve(schema, qname, name, refType);
        return result;
    }

    @Override
    public List<Object> resolve(Import imp, int what) {
        if (!this.getImportType().equals(imp.getImportType())) {
            return Collections.emptyList();
        }
        if (what == 2) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(1);
        XSDSchema schema = this.findAndLoad(imp, "xsd", XSDSchema.class);
        if (schema != null) {
            list.add(schema);
        }
        return list;
    }
}

