/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.fnmeta;

import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.bpel.fnmeta.FunctionRegistry;
import org.eclipse.bpel.fnmeta.IFunctionRegistryLoader;
import org.eclipse.bpel.fnmeta.model.Function;
import org.eclipse.bpel.fnmeta.model.Registry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ClasspathFunctionRegistryLoader
implements IFunctionRegistryLoader {
    ClassLoader fLoader = null;
    ResourceSet fResourceSet = null;

    public ClasspathFunctionRegistryLoader(ResourceSet obj) {
        this.fLoader = obj.getClass().getClassLoader();
        this.fResourceSet = obj;
    }

    @Override
    public void load(FunctionRegistry registry) {
        Enumeration<URL> list = null;
        try {
            list = this.fLoader.getResources("fn.fnmeta");
            while (list.hasMoreElements()) {
                URL url = list.nextElement();
                URI uri = URI.createURI((String)url.toExternalForm());
                Resource resource = this.fResourceSet.getResource(uri, true);
                if (resource.getContents().size() <= 0) continue;
                Registry r = (Registry)resource.getContents().get(0);
                registry.add((List<Function>)r.getFunctions());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

