/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.figures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.FaultHandlerEditPart;
import org.eclipse.bpel.ui.editparts.borders.RoundRectangleBorderWithDecoration;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.figures.ManhattanConnectionRouterEx;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.gef.editparts.LayerManager;

public abstract class AbstractHandlerLinker {
    private List<PolylineConnection> handlerConnectionsList = new ArrayList<PolylineConnection>();
    private BPELEditPart editPart;
    private IFigure connLayer;

    public AbstractHandlerLinker(BPELEditPart editPart) {
        this.editPart = editPart;
        this.connLayer = ((LayerManager)editPart.getViewer().getEditPartRegistry().get(LayerManager.ID)).getLayer((Object)"Connection Layer");
    }

    public void refreshHandlerLinks() {
        PolylineConnection conn;
        this.clearHandlerConnections();
        CenteredConnectionAnchor source = null;
        CenteredConnectionAnchor target = null;
        BPELEditor editor = ModelHelper.getBPELEditor(this.editPart.getModel());
        if (editor == null) {
            return;
        }
        Map reg = editor.getGraphicalViewer().getEditPartRegistry();
        FaultHandlerEditPart fhEditPart = (FaultHandlerEditPart)reg.get(this.getFaultHandler());
        FaultHandlerEditPart ehEditPart = (FaultHandlerEditPart)reg.get(this.getEventHandler());
        FaultHandlerEditPart chEditPart = (FaultHandlerEditPart)reg.get(this.getCompensationHandler());
        FaultHandlerEditPart thEditPart = (FaultHandlerEditPart)reg.get(this.getTerminationHandler());
        if (this.isShowFH()) {
            if (fhEditPart == null) {
                return;
            }
            source = new CenteredConnectionAnchor(this.getFHFigure(), this.getFHSourceAnchorLoc(), 0);
            target = new CenteredConnectionAnchor(this.getFHHandlerFigure(fhEditPart), this.getFHTargetAnchorLoc(), 0);
            conn = new PolylineConnection();
            conn.setSourceAnchor((ConnectionAnchor)source);
            conn.setTargetAnchor((ConnectionAnchor)target);
            conn.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("handlerLinkOne"));
            conn.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouterEx(this.getFHRoutingStartConstraint(), this.getFHRoutingEndConstraint()));
            this.handlerConnectionsList.add(conn);
            this.connLayer.add((IFigure)conn);
        }
        if (this.isShowEH()) {
            if (ehEditPart == null) {
                return;
            }
            source = new CenteredConnectionAnchor(this.getEHFigure(), this.getEHSourceAnchorLoc(), 0);
            target = new CenteredConnectionAnchor(this.getFHHandlerFigure(ehEditPart), this.getEHTargetAnchorLoc(), 0);
            conn = new PolylineConnection();
            conn.setSourceAnchor((ConnectionAnchor)source);
            conn.setTargetAnchor((ConnectionAnchor)target);
            conn.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("handlerLinkThree"));
            conn.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouterEx(this.getEHRoutingStartConstraint(), this.getEHRoutingEndConstraint()));
            this.handlerConnectionsList.add(conn);
            this.connLayer.add((IFigure)conn);
        }
        if (this.isShowCH()) {
            if (chEditPart == null) {
                return;
            }
            source = new CenteredConnectionAnchor(this.getCHFigure(), this.getCHSourceAnchorLoc(), 0);
            target = new CenteredConnectionAnchor(this.getFHHandlerFigure(chEditPart), this.getCHTargetAnchorLoc(), 0);
            conn = new PolylineConnection();
            conn.setSourceAnchor((ConnectionAnchor)source);
            conn.setTargetAnchor((ConnectionAnchor)target);
            conn.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("handlerLinkTwo"));
            conn.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouterEx(this.getCHRoutingStartConstraint(), this.getCHRoutingEndConstraint()));
            this.handlerConnectionsList.add(conn);
            this.connLayer.add((IFigure)conn);
        }
        if (this.isShowTH()) {
            if (thEditPart == null) {
                return;
            }
            source = new CenteredConnectionAnchor(this.getTHFigure(), this.getTHSourceAnchorLoc(), 0);
            target = new CenteredConnectionAnchor(this.getFHHandlerFigure(thEditPart), this.getTHTargetAnchorLoc(), 0);
            conn = new PolylineConnection();
            conn.setSourceAnchor((ConnectionAnchor)source);
            conn.setTargetAnchor((ConnectionAnchor)target);
            conn.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("handlerLinkFour"));
            conn.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouterEx(this.getTHRoutingStartConstraint(), this.getTHRoutingEndConstraint()));
            this.handlerConnectionsList.add(conn);
            this.connLayer.add((IFigure)conn);
        }
    }

    public void clearHandlerConnections() {
        if (this.handlerConnectionsList.size() > 0) {
            for (PolylineConnection p : this.handlerConnectionsList) {
                this.connLayer.remove((IFigure)p);
            }
            this.handlerConnectionsList.clear();
        }
    }

    protected abstract FaultHandler getFaultHandler();

    protected abstract EventHandler getEventHandler();

    protected abstract CompensationHandler getCompensationHandler();

    protected abstract TerminationHandler getTerminationHandler();

    protected abstract boolean isShowCH();

    protected abstract boolean isShowEH();

    protected abstract boolean isShowFH();

    protected abstract boolean isShowTH();

    protected int getFHTargetAnchorLoc() {
        return this.isHorizontalLayout() ? 2 : 0;
    }

    protected int getEHTargetAnchorLoc() {
        return this.isHorizontalLayout() ? 2 : 0;
    }

    protected int getCHTargetAnchorLoc() {
        return this.isHorizontalLayout() ? 2 : 0;
    }

    protected int getTHTargetAnchorLoc() {
        return this.isHorizontalLayout() ? 2 : 0;
    }

    protected Ray getFHRoutingStartConstraint() {
        switch (this.getFHSourceAnchorLoc()) {
            case 1: {
                return ManhattanConnectionRouterEx.DOWN;
            }
        }
        return ManhattanConnectionRouterEx.RIGHT;
    }

    protected Ray getFHRoutingEndConstraint() {
        switch (this.getFHTargetAnchorLoc()) {
            case 0: {
                return ManhattanConnectionRouterEx.UP;
            }
        }
        return ManhattanConnectionRouterEx.LEFT;
    }

    protected Ray getEHRoutingStartConstraint() {
        switch (this.getEHSourceAnchorLoc()) {
            case 1: {
                return ManhattanConnectionRouterEx.DOWN;
            }
        }
        return ManhattanConnectionRouterEx.RIGHT;
    }

    protected Ray getEHRoutingEndConstraint() {
        switch (this.getEHTargetAnchorLoc()) {
            case 0: {
                return ManhattanConnectionRouterEx.UP;
            }
        }
        return ManhattanConnectionRouterEx.LEFT;
    }

    protected Ray getCHRoutingStartConstraint() {
        switch (this.getCHSourceAnchorLoc()) {
            case 1: {
                return ManhattanConnectionRouterEx.DOWN;
            }
        }
        return ManhattanConnectionRouterEx.RIGHT;
    }

    protected Ray getCHRoutingEndConstraint() {
        switch (this.getCHTargetAnchorLoc()) {
            case 0: {
                return ManhattanConnectionRouterEx.UP;
            }
        }
        return ManhattanConnectionRouterEx.LEFT;
    }

    protected Ray getTHRoutingStartConstraint() {
        switch (this.getTHSourceAnchorLoc()) {
            case 1: {
                return ManhattanConnectionRouterEx.DOWN;
            }
        }
        return ManhattanConnectionRouterEx.RIGHT;
    }

    protected Ray getTHRoutingEndConstraint() {
        switch (this.getCHTargetAnchorLoc()) {
            case 0: {
                return ManhattanConnectionRouterEx.UP;
            }
        }
        return ManhattanConnectionRouterEx.LEFT;
    }

    protected abstract IFigure getFHFigure();

    protected abstract IFigure getCHFigure();

    protected abstract IFigure getTHFigure();

    protected abstract IFigure getEHFigure();

    protected int getFHSourceAnchorLoc() {
        return this.isHorizontalLayout() ? 1 : 3;
    }

    protected int getCHSourceAnchorLoc() {
        return this.isHorizontalLayout() ? 1 : 3;
    }

    protected int getTHSourceAnchorLoc() {
        return this.isHorizontalLayout() ? 1 : 3;
    }

    protected int getEHSourceAnchorLoc() {
        return this.isHorizontalLayout() ? 1 : 3;
    }

    protected boolean isHorizontalLayout() {
        return ModelHelper.getBPELEditor(this.editPart.getModel()).isHorizontalLayout();
    }

    protected IFigure getFHHandlerFigure(FaultHandlerEditPart fhEditPart) {
        return ((RoundRectangleBorderWithDecoration)fhEditPart.getContentPane().getBorder()).getDecorationFigure();
    }
}

