/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.bpel.common.extension.model.Extension;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.extension.model.impl.ExtensionImpl;
import org.eclipse.bpel.common.extension.model.impl.ExtensionMapImpl;
import org.eclipse.bpel.common.extension.model.notify.ExtensionModelNotification;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.commands.util.IAutoUndoRecorder;
import org.eclipse.bpel.ui.commands.util.IUndoHandler;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class ModelAutoUndoRecorder
implements IAutoUndoRecorder {
    protected Set<Resource> ignoreResources = new HashSet<Resource>();
    protected boolean VERBOSE_DEBUG = false;
    protected boolean DEBUG = this.VERBOSE_DEBUG;
    protected Set<Notifier> listenerRootSet = new HashSet<Notifier>();
    protected List<Object> currentChangeList = null;
    protected ModelAutoUndoAdapter modelAutoUndoAdapter = new ModelAutoUndoAdapter();

    protected boolean ignoreChange(Notification n) {
        Resource res = null;
        if (n.getNotifier() instanceof ResourceSet) {
            return true;
        }
        if (n.getNotifier() instanceof Resource) {
            res = (Resource)n.getNotifier();
        } else if (n.getNotifier() instanceof EObject) {
            res = ((EObject)n.getNotifier()).eResource();
        } else {
            return true;
        }
        if (res != null && this.ignoreResources.contains(res)) {
            if (this.VERBOSE_DEBUG) {
                System.out.println("IGNORING -- " + (n.isTouch() ? "<t>  " : "CHG: ") + BPELUtil.debug(n));
            }
            return true;
        }
        return false;
    }

    protected void recordChange(Notification n) {
        if (this.currentChangeList == null) {
            return;
        }
        if (n.getNotifier() instanceof Extension) {
            return;
        }
        if (n.getNotifier() instanceof ExtensionMapImpl) {
            if (n.getFeatureID(ExtensionMap.class) == 1) {
                if (this.DEBUG) {
                    System.out.println("ignoring impl notification: " + BPELUtil.debug(n));
                }
                return;
            }
            if (n instanceof ExtensionModelNotification) {
                ExtensionModelNotification emn = (ExtensionModelNotification)n;
                ExtensionMap extensionMap = (ExtensionMap)n.getNotifier();
                if (n.getFeatureID(ExtensionMap.class) == 996) {
                    EObject object = (EObject)emn.getArg1();
                    EObject oldExt = (EObject)emn.getArg2();
                    EObject newExt = (EObject)extensionMap.get((Object)object);
                    if (this.DEBUG) {
                        System.out.println("record PUT: " + BPELUtil.debugObject(object) + ": " + BPELUtil.debugObject(oldExt) + " ==> " + BPELUtil.debugObject(newExt));
                    }
                    this.currentChangeList.add(new EMapSingleChangeHandler(extensionMap, object, oldExt, newExt));
                } else if (n.getFeatureID(ExtensionMap.class) == 998) {
                    EObject object = (EObject)emn.getArg1();
                    EObject oldExt = (EObject)emn.getArg2();
                    EObject newExt = null;
                    if (this.DEBUG) {
                        System.out.println("record REMOVE: " + BPELUtil.debugObject(object) + ": " + BPELUtil.debugObject(oldExt) + " ==> " + BPELUtil.debugObject(newExt));
                    }
                    this.currentChangeList.add(new EMapSingleChangeHandler(extensionMap, object, oldExt, newExt));
                } else if (n.getFeatureID(ExtensionMap.class) == 997) {
                    Map oldContents = (Map)emn.getArg1();
                    HashMap newContents = new HashMap(extensionMap);
                    if (this.DEBUG) {
                        System.out.println("record PUTALL: " + oldContents.size() + " items ==> " + newContents.size() + " items");
                    }
                    this.currentChangeList.add(new EMapMultiChangeHandler(extensionMap, oldContents, newContents));
                } else if (n.getFeatureID(ExtensionMap.class) == 999) {
                    Map oldContents = (Map)emn.getArg1();
                    Map newContents = Collections.EMPTY_MAP;
                    if (this.DEBUG) {
                        System.out.println("record CLEAR: " + oldContents.size() + " items ==> " + newContents.size() + " items");
                    }
                    this.currentChangeList.add(new EMapMultiChangeHandler(extensionMap, oldContents, newContents));
                } else if (this.DEBUG) {
                    System.out.println("WARNING: ModelAutoUndoRecorder.recordChange(): unknown event type from ExtensionMapImpl");
                }
                return;
            }
            if (this.DEBUG) {
                System.out.println("ExtensionMap: " + BPELUtil.debug(n));
            }
        }
        if (this.DEBUG) {
            System.out.println(String.valueOf(n.isTouch() ? "<t>  " : "CHG: ") + BPELUtil.debug(n));
        }
        this.currentChangeList.add(n);
    }

    public void startIgnoringResource(Resource resource) {
        this.ignoreResources.add(resource);
    }

    public void stopIgnoringResource(Resource resource) {
        this.ignoreResources.remove(resource);
    }

    @Override
    public void startChanges(List<Object> modelRoots) {
        if (this.VERBOSE_DEBUG) {
            System.out.println("startChanges()");
        }
        if (this.currentChangeList != null) {
            throw new IllegalStateException("startChages(): pending current change list");
        }
        this.currentChangeList = new ArrayList<Object>();
        this.addModelRoots(modelRoots);
    }

    @Override
    public List<Object> finishChanges() {
        if (this.currentChangeList == null) {
            throw new IllegalStateException("Nothing to finish, currentChangeList is committed");
        }
        if (this.VERBOSE_DEBUG) {
            System.out.println("finishChanges(): " + this.currentChangeList.size());
        }
        List<Object> result = this.currentChangeList;
        this.currentChangeList = null;
        this.clearModelRoots();
        return result;
    }

    protected void addModelRoot(Object root) {
        if (root instanceof EObject) {
            root = ((EObject)root).eResource();
        }
        if (root instanceof Notifier) {
            EList adapters = ((Notifier)root).eAdapters();
            if (!adapters.contains((Object)this.modelAutoUndoAdapter)) {
                if (this.VERBOSE_DEBUG) {
                    System.out.println(" >>> Add Root: " + root);
                }
                adapters.add(this.modelAutoUndoAdapter);
                this.listenerRootSet.add((Notifier)root);
            } else if (this.VERBOSE_DEBUG) {
                System.out.println(" >>> Overlapping Root: " + root);
            }
        }
    }

    @Override
    public void addModelRoots(List<Object> modelRoots) {
        boolean gotExtensionMap = false;
        for (Object root : modelRoots) {
            this.addModelRoot(root);
            if (gotExtensionMap) continue;
            BPELEditor bpelEditor = ModelHelper.getBPELEditor(root);
            if (bpelEditor != null) {
                this.addModelRoot(bpelEditor.getExtensionMap());
            }
            gotExtensionMap = true;
        }
    }

    protected void clearModelRoots() {
        if (this.VERBOSE_DEBUG) {
            System.out.println(" <<< Clear Model Roots");
        }
        for (Notifier notifier : this.listenerRootSet) {
            while (notifier instanceof EObject && ((EObject)notifier).eContainer().eAdapters().contains((Object)this.modelAutoUndoAdapter)) {
                notifier = ((EObject)notifier).eContainer();
            }
            notifier.eAdapters().remove((Object)this.modelAutoUndoAdapter);
        }
        this.listenerRootSet.clear();
    }

    @Override
    public boolean isRecordingChanges() {
        return this.currentChangeList != null;
    }

    @Override
    public void insertUndoHandler(IUndoHandler undoHandler) {
        if (this.currentChangeList != null) {
            this.currentChangeList.add(undoHandler);
        } else if (this.DEBUG) {
            System.out.println("WARNING: insertUndoHandler() while not recording changes!");
        }
    }

    protected void undoNotification(Notification n) {
        block19: {
            block20: {
                if (n.getNotifier() instanceof ExtensionImpl) {
                    if (this.DEBUG) {
                        System.out.println("ignore ExtensionImpl change: " + BPELUtil.debug(n));
                    }
                    return;
                }
                if (this.DEBUG) {
                    System.out.println(String.valueOf(n.isTouch() ? "<t> " : "undo: ") + BPELUtil.debug(n));
                }
                EStructuralFeature feature = (EStructuralFeature)n.getFeature();
                if (!(n.getNotifier() instanceof EObject)) break block20;
                EObject obj = (EObject)n.getNotifier();
                switch (n.getEventType()) {
                    case 5: 
                    case 6: {
                        Assert.isTrue((boolean)feature.isMany());
                        obj.eSet(feature, n.getOldValue());
                        break block19;
                    }
                    case 3: {
                        Assert.isTrue((boolean)feature.isMany());
                        List list = (List)obj.eGet(feature, true);
                        try {
                            list.remove(n.getPosition());
                        }
                        catch (ClassCastException e) {
                            if (this.DEBUG) {
                                e.printStackTrace();
                            }
                            break block19;
                        }
                    }
                    case 4: {
                        Assert.isTrue((boolean)feature.isMany());
                        List list = (List)obj.eGet(feature, true);
                        if (n.getPosition() == -1) {
                            list.add(n.getOldValue());
                        } else {
                            list.add(n.getPosition(), n.getOldValue());
                        }
                        break block19;
                    }
                    case 1: 
                    case 2: {
                        if (feature.isMany() && n.getPosition() >= 0) {
                            List list = (List)obj.eGet(feature, true);
                            list.set(n.getPosition(), n.getOldValue());
                        } else if (n.wasSet()) {
                            obj.eSet(feature, n.getOldValue());
                        } else {
                            obj.eUnset(feature);
                        }
                        break block19;
                    }
                    case 7: {
                        Assert.isTrue((boolean)feature.isMany());
                        obj.eSet(feature, n.getOldValue());
                        break block19;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            System.err.println("undoNotification on non-EObject not implemented yet");
            new Exception().printStackTrace(System.err);
        }
    }

    protected void redoNotification(Notification n) {
        block14: {
            block13: {
                if (this.DEBUG) {
                    System.out.println(String.valueOf(n.isTouch() ? "<t> " : "redo: ") + BPELUtil.debug(n));
                }
                EStructuralFeature feature = (EStructuralFeature)n.getFeature();
                if (!(n.getNotifier() instanceof EObject)) break block13;
                EObject obj = (EObject)n.getNotifier();
                switch (n.getEventType()) {
                    case 5: 
                    case 6: {
                        Assert.isTrue((boolean)feature.isMany());
                        obj.eSet(feature, n.getNewValue());
                        break block14;
                    }
                    case 3: {
                        Assert.isTrue((boolean)feature.isMany());
                        List list = (List)obj.eGet(feature, true);
                        list.add(n.getPosition(), n.getNewValue());
                        break block14;
                    }
                    case 4: {
                        Assert.isTrue((boolean)feature.isMany());
                        List list = (List)obj.eGet(feature, true);
                        if (n.getPosition() == -1) {
                            list.remove(n.getOldValue());
                        } else {
                            list.remove(n.getPosition());
                        }
                        break block14;
                    }
                    case 1: {
                        if (feature.isMany() && n.getPosition() >= 0) {
                            List list = (List)obj.eGet(feature, true);
                            list.set(n.getPosition(), n.getNewValue());
                        } else {
                            obj.eSet(feature, n.getNewValue());
                        }
                        break block14;
                    }
                    case 2: {
                        obj.eUnset(feature);
                        break block14;
                    }
                    case 7: {
                        Assert.isTrue((boolean)feature.isMany());
                        obj.eSet(feature, n.getNewValue());
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            System.err.println("redoNotification on non-EObject not implemented yet");
            new Exception().printStackTrace(System.err);
        }
    }

    @Override
    public void undo(List<Object> changes) {
        if (this.VERBOSE_DEBUG) {
            System.out.println("UNDOING " + changes.size() + " changes");
        }
        int i = changes.size();
        while (--i >= 0) {
            Object change = changes.get(i);
            if (change instanceof Notification) {
                try {
                    this.undoNotification((Notification)change);
                }
                catch (RuntimeException e) {
                    BPELUIPlugin.log(e);
                }
                continue;
            }
            if (!(change instanceof IUndoHandler)) continue;
            ((IUndoHandler)change).undo();
        }
    }

    @Override
    public void redo(List<Object> changes) {
        if (this.VERBOSE_DEBUG) {
            System.out.println("REDOING " + changes.size() + " changes");
        }
        for (Object change : changes) {
            if (change instanceof Notification) {
                try {
                    this.redoNotification((Notification)change);
                }
                catch (RuntimeException e) {
                    BPELUIPlugin.log(e);
                }
                continue;
            }
            if (!(change instanceof IUndoHandler)) continue;
            ((IUndoHandler)change).redo();
        }
    }

    public static IAutoUndoRecorder getFromAdapter(Notifier notifier) {
        for (Adapter a : notifier.eAdapters()) {
            if (!(a instanceof ModelAutoUndoAdapter)) continue;
            return ((ModelAutoUndoAdapter)a).getAutoUndoRecorder();
        }
        return null;
    }

    class EMapMultiChangeHandler
    implements IUndoHandler {
        ExtensionMap fExtensionMap;
        Map fOldContents;
        Map fNewContents;

        public EMapMultiChangeHandler(ExtensionMap extensionMap, Map oldContents, Map newContents) {
            this.fExtensionMap = extensionMap;
            this.fOldContents = oldContents;
            this.fNewContents = newContents;
        }

        @Override
        public void undo() {
            if (ModelAutoUndoRecorder.this.DEBUG) {
                System.out.println("undo multi-change");
            }
            this.fExtensionMap.clear();
            if (this.fOldContents != null) {
                this.fExtensionMap.putAll(this.fOldContents);
            }
        }

        @Override
        public void redo() {
            if (ModelAutoUndoRecorder.this.DEBUG) {
                System.out.println("redo multi-change");
            }
            this.fExtensionMap.clear();
            if (this.fNewContents != null) {
                this.fExtensionMap.putAll(this.fNewContents);
            }
        }
    }

    class EMapSingleChangeHandler
    implements IUndoHandler {
        ExtensionMap fExtensionMap;
        EObject fExtendedObject;
        EObject fOldExtension;
        EObject fNewExtension;

        public EMapSingleChangeHandler(ExtensionMap extensionMap, EObject extendedObject, EObject oldExtension, EObject newExtension) {
            this.fExtensionMap = extensionMap;
            this.fExtendedObject = extendedObject;
            this.fOldExtension = oldExtension;
            this.fNewExtension = newExtension;
        }

        @Override
        public void undo() {
            if (ModelAutoUndoRecorder.this.DEBUG) {
                System.out.println("undo single change");
            }
            if (this.fOldExtension == null) {
                if (this.fExtensionMap.containsKey((Object)this.fExtendedObject)) {
                    this.fExtensionMap.remove((Object)this.fExtendedObject);
                }
            } else {
                this.fExtensionMap.put((Object)this.fExtendedObject, (Object)this.fOldExtension);
            }
        }

        @Override
        public void redo() {
            if (ModelAutoUndoRecorder.this.DEBUG) {
                System.out.println("redo single change");
            }
            if (this.fNewExtension == null) {
                if (this.fExtensionMap.containsKey((Object)this.fExtendedObject)) {
                    this.fExtensionMap.remove((Object)this.fExtendedObject);
                }
            } else {
                this.fExtensionMap.put((Object)this.fExtendedObject, (Object)this.fNewExtension);
            }
        }
    }

    class ModelAutoUndoAdapter
    extends EContentAdapter {
        ModelAutoUndoAdapter() {
        }

        protected ModelAutoUndoRecorder getAutoUndoRecorder() {
            return ModelAutoUndoRecorder.this;
        }

        protected void handleContainment(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: {
                    Notifier newValue = (Notifier)notification.getNewValue();
                    if (newValue == null || newValue.eAdapters().contains((Object)this)) break;
                    newValue.eAdapters().add((Object)this);
                    break;
                }
                case 3: {
                    Notifier newValue = (Notifier)notification.getNewValue();
                    if (newValue == null || newValue.eAdapters().contains((Object)this)) break;
                    newValue.eAdapters().add((Object)this);
                    break;
                }
                case 5: {
                    Collection newValues = (Collection)notification.getNewValue();
                    for (Notifier next : newValues) {
                        if (next.eAdapters().contains((Object)this)) continue;
                        next.eAdapters().add((Object)this);
                    }
                    break;
                }
            }
        }

        public void setTarget(Notifier aTarget) {
            this.target = aTarget;
            EList contents = null;
            if (this.target instanceof EObject) {
                contents = ((EObject)aTarget).eContents();
            } else if (this.target instanceof ResourceSet) {
                contents = ((ResourceSet)this.target).getResources();
            } else if (this.target instanceof Resource) {
                contents = ((Resource)this.target).getContents();
            } else {
                return;
            }
            for (Object next : contents) {
                Notifier notifier = (Notifier)next;
                if (notifier.eAdapters().contains((Object)this)) continue;
                notifier.eAdapters().add((Object)this);
            }
        }

        public void notifyChanged(Notification n) {
            switch (n.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (ModelAutoUndoRecorder.this.ignoreChange(n)) break;
                    ModelAutoUndoRecorder.this.recordChange(n);
                }
            }
            super.notifyChanged(n);
        }
    }
}

